/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.NamedReferencePair;
import com.sun.enterprise.deployment.OrderedSet;
import com.sun.enterprise.deployment.RelationshipDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.Role;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.runtime.IASPersistenceManagerDescriptor;
import com.sun.enterprise.deployment.runtime.PersistenceManagerInUse;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.DescriptorVisitor;
import com.sun.enterprise.deployment.util.EjbBundleVisitor;
import com.sun.enterprise.deployment.util.EjbVisitor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;

public class EjbBundleDescriptor
extends BundleDescriptor {
    public static final String SPEC_VERSION = "2.1";
    private long uniqueId;
    private Set ejbs = new HashSet();
    private Set relationships = new HashSet();
    private String relationshipsDescription;
    private String ejbClientJarUri;
    private Vector configured_pms = null;
    private PersistenceManagerInUse pm_inuse = null;
    private ResourceReferenceDescriptor cmpResourceReference;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EjbBundleDescriptor.class);
    static Logger _logger = DOLUtils.getDefaultLogger();

    public EjbBundleDescriptor() {
        this.setSpecVersion(SPEC_VERSION);
    }

    public boolean isEJB20() {
        return !this.isEJB11();
    }

    public boolean isEJB11() {
        return this.getSpecVersion().startsWith("1");
    }

    public String getEjbClientJarUri() {
        if (this.ejbClientJarUri == null) {
            this.ejbClientJarUri = "";
        }
        return this.ejbClientJarUri;
    }

    public void setEjbClientJarUri(String ejbClientJarUri) {
        this.ejbClientJarUri = ejbClientJarUri;
        this.changed();
    }

    public void addEjbBundleDescriptor(EjbBundleDescriptor ejbBundleDescriptor) {
        super.addBundleDescriptor(ejbBundleDescriptor);
        Iterator ejbs = ejbBundleDescriptor.getEjbs().iterator();
        while (ejbs.hasNext()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)ejbs.next();
            ejbDescriptor.setEjbBundleDescriptor(this);
            this.getEjbs().add(ejbDescriptor);
        }
        WebServicesDescriptor thisWebServices = this.getWebServices();
        WebServicesDescriptor otherWebServices = ejbBundleDescriptor.getWebServices();
        Iterator i = otherWebServices.getWebServices().iterator();
        while (i.hasNext()) {
            WebService ws = (WebService)i.next();
            thisWebServices.addWebService(new WebService(ws));
        }
        this.changed();
    }

    public void classesChanged() {
        Iterator ejbs = this.getEjbs().iterator();
        while (ejbs.hasNext()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)ejbs.next();
            ejbDescriptor.classesChanged();
        }
    }

    public Collection getNamedDescriptors() {
        Vector<EjbDescriptor> namedDescriptors = new Vector<EjbDescriptor>();
        Iterator ejbs = this.getEjbs().iterator();
        while (ejbs.hasNext()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)ejbs.next();
            namedDescriptors.add(ejbDescriptor);
            namedDescriptors.addAll(super.getNamedDescriptorsFrom(ejbDescriptor));
        }
        return namedDescriptors;
    }

    public Vector getNamedReferencePairs() {
        Vector<NamedReferencePair> pairs = new Vector<NamedReferencePair>();
        Iterator ejbs = this.getEjbs().iterator();
        while (ejbs.hasNext()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)ejbs.next();
            pairs.add(NamedReferencePair.createEjbPair(ejbDescriptor, ejbDescriptor));
            pairs.addAll(super.getNamedReferencePairsFrom(ejbDescriptor));
        }
        return pairs;
    }

    public Set getResourceReferenceDescriptors() {
        HashSet resourceReferences = new HashSet();
        Iterator itr = this.getEjbs().iterator();
        while (itr.hasNext()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)itr.next();
            resourceReferences.addAll(ejbDescriptor.getResourceReferenceDescriptors());
        }
        return resourceReferences;
    }

    public boolean hasEjbReferences() {
        Iterator itr = this.getEjbs().iterator();
        while (itr.hasNext()) {
            EjbDescriptor nextEjbDescriptor = (EjbDescriptor)itr.next();
            if (nextEjbDescriptor.getEjbReferenceDescriptors().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Set getEjbs() {
        return this.ejbs;
    }

    public boolean hasEjbByName(String name) {
        Iterator itr = this.getEjbs().iterator();
        while (itr.hasNext()) {
            Descriptor next = (Descriptor)itr.next();
            if (!next.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public EjbDescriptor getEjbByName(String name) {
        Iterator itr = this.getEjbs().iterator();
        while (itr.hasNext()) {
            Descriptor next = (Descriptor)itr.next();
            if (!next.getName().equals(name)) continue;
            return (EjbDescriptor)next;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionbeanbundle", "Referencing error: this bundle has no bean of name: {0}", new Object[]{name}));
    }

    public void addEjb(EjbDescriptor ejbDescriptor) {
        ejbDescriptor.setEjbBundleDescriptor(this);
        this.getEjbs().add(ejbDescriptor);
        super.changed();
    }

    public void removeEjb(EjbDescriptor ejbDescriptor) {
        ejbDescriptor.setEjbBundleDescriptor(null);
        this.getEjbs().remove(ejbDescriptor);
        super.changed();
    }

    void replaceEjb(EjbDescriptor oldEjbDescriptor, EjbDescriptor newEjbDescriptor) {
        oldEjbDescriptor.setEjbBundleDescriptor(null);
        this.getEjbs().remove(oldEjbDescriptor);
        newEjbDescriptor.setEjbBundleDescriptor(this);
        this.getEjbs().add(newEjbDescriptor);
    }

    public boolean containsCMPEntity() {
        Set ejbs = this.getEjbs();
        if (ejbs == null) {
            return false;
        }
        Iterator ejbsItr = ejbs.iterator();
        while (ejbsItr.hasNext()) {
            if (!(ejbsItr.next() instanceof EjbCMPEntityDescriptor)) continue;
            return true;
        }
        return false;
    }

    public boolean areResourceReferencesValid() {
        Iterator itr = this.getEjbs().iterator();
        while (itr.hasNext()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)itr.next();
            Iterator roleRefs = ejbDescriptor.getRoleReferences().iterator();
            while (roleRefs.hasNext()) {
                RoleReference roleReference = (RoleReference)roleRefs.next();
                Role referredRole = roleReference.getRole();
                if (referredRole.getName().equals("") || super.getRoles().contains(referredRole)) continue;
                _logger.log(Level.FINE, localStrings.getLocalString("enterprise.deployment.badrolereference", "Warning: Bad role reference to {0}", new Object[]{referredRole}));
                _logger.log(Level.FINE, "Roles:  " + this.getRoles());
                return false;
            }
        }
        return true;
    }

    public void removeRole(Role role) {
        if (super.getRoles().contains(role)) {
            Iterator itr = this.getEjbs().iterator();
            while (itr.hasNext()) {
                EjbDescriptor ejbDescriptor = (EjbDescriptor)itr.next();
                ejbDescriptor.removeRole(role);
            }
            super.removeRole(role);
        }
    }

    public boolean hasPermissionedRoles() {
        Iterator itr = this.getEjbs().iterator();
        while (itr.hasNext()) {
            EjbDescriptor nextEjbDescriptor = (EjbDescriptor)itr.next();
            if (nextEjbDescriptor.getPermissionedMethodsByPermission().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasContainerTransactions() {
        Iterator itr = this.getEjbs().iterator();
        while (itr.hasNext()) {
            EjbDescriptor nextEjbDescriptor = (EjbDescriptor)itr.next();
            if (nextEjbDescriptor.getMethodContainerTransactions().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasAssemblyInformation() {
        return !this.getRoles().isEmpty() || this.hasPermissionedRoles() || this.hasContainerTransactions();
    }

    public void addRelationship(RelationshipDescriptor relDesc) {
        this.relationships.add(relDesc);
        super.changed();
    }

    public void removeRelationship(RelationshipDescriptor relDesc) {
        this.relationships.remove(relDesc);
        super.changed();
    }

    public String getRelationshipsDescription() {
        if (this.relationshipsDescription == null) {
            this.relationshipsDescription = "";
        }
        return this.relationshipsDescription;
    }

    public void setRelationshipsDescription(String relationshipsDescription) {
        this.relationshipsDescription = relationshipsDescription;
    }

    public Set getRelationships() {
        return this.relationships;
    }

    public boolean hasRelationships() {
        return this.relationships.size() > 0;
    }

    public boolean hasRelationship(RelationshipDescriptor rd) {
        return this.relationships.contains(rd);
    }

    public ResourceReferenceDescriptor getCMPResourceReference() {
        return this.cmpResourceReference;
    }

    public void setCMPResourceReference(ResourceReferenceDescriptor resourceReference) {
        this.cmpResourceReference = resourceReference;
        this.changed();
    }

    public Descriptor getDescriptorByName(String name) {
        try {
            return this.getEjbByName(name);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    public String getName() {
        if ("".equals(super.getName())) {
            super.setName("Ejb1");
        }
        return super.getName();
    }

    private void doMethodDescriptorConversions() throws Exception {
        Iterator itr = this.getEjbs().iterator();
        while (itr.hasNext()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)itr.next();
            ejbDescriptor.doMethodDescriptorConversions();
        }
    }

    public void setUniqueId(long id) {
        this.uniqueId = id;
        EjbDescriptor[] descs = this.ejbs.toArray(new EjbDescriptor[this.ejbs.size()]);
        Arrays.sort(descs, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((EjbDescriptor)o1).getName().compareTo(((EjbDescriptor)o2).getName());
            }
        });
        for (int i = 0; i < descs.length; ++i) {
            descs[i].setUniqueId(id | (long)i);
        }
    }

    public long getUniqueId() {
        return this.uniqueId;
    }

    public static int getIdFromEjbId(long ejbId) {
        long id = ejbId >> 32;
        return (int)id;
    }

    public boolean hasWebServiceClients() {
        Iterator ejbs = this.getEjbs().iterator();
        while (ejbs.hasNext()) {
            EjbDescriptor next = (EjbDescriptor)ejbs.next();
            Set serviceRefs = next.getServiceReferenceDescriptors();
            if (serviceRefs.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Set getServiceReferenceDescriptors() {
        OrderedSet serviceRefs = new OrderedSet();
        Iterator ejbs = this.getEjbs().iterator();
        while (ejbs.hasNext()) {
            EjbDescriptor next = (EjbDescriptor)ejbs.next();
            serviceRefs.addAll(next.getServiceReferenceDescriptors());
        }
        return serviceRefs;
    }

    public void print(StringBuffer toStringBuffer) {
        toStringBuffer.append("EjbBundleDescriptor\n");
        super.print(toStringBuffer);
        if (this.cmpResourceReference != null) {
            toStringBuffer.append("\ncmp resource ");
            ((Descriptor)this.cmpResourceReference).print(toStringBuffer);
        }
        toStringBuffer.append("\nclient JAR ").append(this.getEjbClientJarUri());
        Iterator itr = this.getEjbs().iterator();
        while (itr.hasNext()) {
            toStringBuffer.append("\n------------\n");
            ((Descriptor)itr.next()).print(toStringBuffer);
            toStringBuffer.append("\n------------");
        }
    }

    public void visit(DescriptorVisitor aVisitor) {
        if (aVisitor instanceof EjbBundleVisitor) {
            this.visit((EjbBundleVisitor)((Object)aVisitor));
        } else {
            super.visit(aVisitor);
        }
    }

    public void visit(EjbBundleVisitor aVisitor) {
        Iterator itr;
        aVisitor.accept(this);
        EjbVisitor ejbVisitor = aVisitor.getEjbVisitor();
        if (ejbVisitor != null) {
            itr = this.getEjbs().iterator();
            while (itr.hasNext()) {
                EjbDescriptor anEjb = (EjbDescriptor)itr.next();
                anEjb.visit(ejbVisitor);
            }
        }
        if (this.hasRelationships()) {
            itr = this.getRelationships().iterator();
            while (itr.hasNext()) {
                RelationshipDescriptor rd = (RelationshipDescriptor)itr.next();
                aVisitor.accept(rd);
            }
        }
        itr = this.getWebServices().getWebServices().iterator();
        while (itr.hasNext()) {
            WebService aWebService = (WebService)itr.next();
            aVisitor.accept(aWebService);
        }
    }

    public ModuleType getModuleType() {
        return ModuleType.EJB;
    }

    public void setPersistenceManagerInuse(String id, String ver) {
        this.pm_inuse = new PersistenceManagerInUse(id, ver);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("***IASEjbBundleDescriptor.setPersistenceManagerInUse done -#- ");
        }
    }

    public void setPersistenceManagerInUse(PersistenceManagerInUse inuse) {
        this.pm_inuse = inuse;
    }

    public PersistenceManagerInUse getPersistenceManagerInUse() {
        return this.pm_inuse;
    }

    public void addPersistenceManager(IASPersistenceManagerDescriptor pmDesc) {
        if (this.configured_pms == null) {
            this.configured_pms = new Vector();
        }
        this.configured_pms.add(pmDesc);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("***IASEjbBundleDescriptor.addPersistenceManager done -#- ");
        }
    }

    public IASPersistenceManagerDescriptor getPreferredPersistenceManager() {
        boolean debug = _logger.isLoggable(Level.FINE);
        if (this.configured_pms == null || this.configured_pms.size() == 0) {
            return null;
        }
        String pminuse_id = this.pm_inuse.get_pm_identifier().trim();
        String pminuse_ver = this.pm_inuse.get_pm_version().trim();
        if (debug) {
            _logger.fine("IASPersistenceManagerDescriptor.getPreferred - inid*" + pminuse_id.trim() + "*");
            _logger.fine("IASPersistenceManagerDescriptor.getPreferred - inver*" + pminuse_ver.trim() + "*");
        }
        int size = this.configured_pms.size();
        for (int i = 0; i < size; ++i) {
            IASPersistenceManagerDescriptor pmdesc = (IASPersistenceManagerDescriptor)this.configured_pms.elementAt(i);
            String pmdesc_id = pmdesc.getPersistenceManagerIdentifier();
            String pmdesc_ver = pmdesc.getPersistenceManagerVersion();
            if (debug) {
                _logger.fine("IASPersistenceManagerDescriptor.getPreferred - pmid*" + pmdesc_id.trim() + "*");
                _logger.fine("IASPersistenceManagerDescriptor.getPreferred - pmver*" + pmdesc_ver.trim() + "*");
            }
            if (!pmdesc_id.trim().equals(pminuse_id) || !pmdesc_ver.trim().equals(pminuse_ver)) continue;
            if (debug) {
                _logger.fine("***IASEjbBundleDescriptor.getPreferredPersistenceManager done -#- ");
            }
            return pmdesc;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.nomatchingpminusefound", "No PersistenceManager found that matches specified PersistenceManager in use."));
    }

    public Vector getPersistenceManagers() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("***IASEjbBundleDescriptor.getPersistenceManagers done -#- ");
        }
        return this.configured_pms;
    }
}

