/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployapi;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.admin.common.ByteChunk;
import com.sun.enterprise.admin.common.ObjectNames;
import com.sun.enterprise.admin.common.ParamInfo;
import com.sun.enterprise.admin.common.exception.AFException;
import com.sun.enterprise.admin.util.ArgChecker;
import com.sun.enterprise.admin.util.Debug;
import com.sun.enterprise.admin.util.StringValidator;
import com.sun.enterprise.deployment.client.ServerConnectionIdentifier;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import javax.enterprise.deploy.spi.Target;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class SunTarget
implements Target,
Serializable {
    private ServerConnectionIdentifier connectionInfo;
    private String appServer;
    private boolean connected = false;
    private MBeanServerConnection mbsc = null;
    private String targetType;
    private static StringManager localStrings = StringManager.getManager(SunTarget.class);
    private static final String DAS_TARGET_NAME = "server";
    private static final String PREPARE_DOWNLOAD = "prepareDownload";
    private static final String GET_STUB_FILE_LOCATION = "getClientStubJarLocation";
    private static final String GET_WSDL_FILE_LOCATION = "getWsdlFileLocation";
    private static final String DOWNLOAD_FILE = "downloadFile";
    private static final String UPLOAD_OPERATION = "uploadToServer";

    public SunTarget(ServerConnectionIdentifier svi) {
        this.connectionInfo = svi;
    }

    public SunTarget(SunTarget other) {
        this.connectionInfo = other.connectionInfo;
        this.appServer = other.appServer;
        this.mbsc = other.mbsc;
        this.targetType = other.targetType;
    }

    public String getDescription() {
        new Version();
        return System.getProperty(localStrings.getString("enterprise.deployapi.spi.suntargetdescription", Version.getProductName(), this.getHostName()));
    }

    public String getName() {
        return this.appServer;
    }

    public void release() {
        this.connected = false;
    }

    public String getHostName() {
        return this.connectionInfo.getHostName();
    }

    public String getPort() {
        return new Integer(this.connectionInfo.getHostPort()).toString();
    }

    public ServerConnectionIdentifier getConnectionInfo() {
        return this.connectionInfo;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String toString() {
        return this.getHostName() + ":" + (this.getPort() != null ? this.getPort() : "DefaultPort") + "_" + this.appServer;
    }

    public String debugString() {
        String s = "";
        if (this.connected) {
            s = "Connected ";
        }
        return s + "Server " + this.getHostName() + ":" + (this.getPort() != null ? this.getPort() : "DefaultPort") + "; Name: " + this.appServer;
    }

    public boolean equals(Object other) {
        if (other instanceof SunTarget) {
            SunTarget theOther = (SunTarget)other;
            return this.connectionInfo.equals(theOther.connectionInfo) && this.getName() != null && this.getName().equals(theOther.getName()) && this.getTargetType() != null && this.getTargetType().equals(theOther.getTargetType());
        }
        return false;
    }

    public boolean isManagedBySameDAS(Object other) {
        if (other instanceof SunTarget) {
            SunTarget theOther = (SunTarget)other;
            return this.connectionInfo.equals(theOther.connectionInfo);
        }
        return false;
    }

    public boolean isDAS() {
        return this.appServer.equals(DAS_TARGET_NAME);
    }

    public String getAppServerInstance() {
        return this.appServer;
    }

    public void setAppServerInstance(String appServer) {
        this.appServer = appServer;
    }

    public void setTargetType(String type) {
        this.targetType = type;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public void setMBeanServerConnection(MBeanServerConnection mbsc) {
        this.mbsc = mbsc;
    }

    public MBeanServerConnection getMBeanServerConnection() {
        return this.mbsc;
    }

    public String exportClientStubs(String appName, int appType, String destDir) throws AFException {
        File f = new File(destDir);
        if (!f.exists()) {
            String msg = localStrings.getString("suntarget.desstdir_does_not_exist", destDir);
            throw new AFException(msg);
        }
        if (!f.isDirectory()) {
            String msg = localStrings.getString("suntarget.desstdir_is_not_directory", destDir);
            throw new AFException(msg);
        }
        if (!f.canWrite()) {
            String msg = localStrings.getString("suntarget.cannot_write_to_destdir", destDir);
            throw new AFException(msg);
        }
        try {
            ObjectName objName = ObjectNames.getSystemServicesObjectName();
            Object[] params = new Object[]{appName};
            String[] signature = new String[]{"java.lang.String"};
            String filePath = (String)this.mbsc.invoke(objName, GET_STUB_FILE_LOCATION, params, signature);
            String fileName = appName + "Client.jar";
            this.downloadFile(filePath, destDir, fileName);
            String exportedFileLocation = new File(destDir, fileName).getAbsolutePath();
            return exportedFileLocation;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AFException(e.getMessage());
        }
    }

    public String exportWsdlFile(String appName, String moduleName, int appType, String wsdlFileUri, String destDir) throws AFException {
        ArgChecker.checkValid(appName, "appName", StringValidator.getInstance());
        if (appType != 1001 && appType != 1003 && appType != 1002) {
            String msg = localStrings.getString("suntarget.invalid_app_type");
            throw new AFException(msg);
        }
        File f = new File(destDir);
        f.mkdirs();
        if (!f.exists()) {
            String msg = localStrings.getString("suntarget.desstdir_does_not_exist", destDir);
            throw new AFException(msg);
        }
        if (!f.isDirectory()) {
            String msg = localStrings.getString("suntarget.desstdir_is_not_directory", destDir);
            throw new AFException(msg);
        }
        if (!f.canWrite()) {
            String msg = localStrings.getString("suntarget.cannot_write_to_destdir", destDir);
            throw new AFException(msg);
        }
        String filePath = null;
        try {
            ObjectName objName = ObjectNames.getSystemServicesObjectName();
            Object[] params = new Object[]{appName, moduleName, wsdlFileUri};
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
            filePath = (String)this.mbsc.invoke(objName, GET_WSDL_FILE_LOCATION, params, signature);
            if (wsdlFileUri.lastIndexOf(47) != -1) {
                File absolutePath;
                String wsdlDir = wsdlFileUri.startsWith("META-INF/wsdl") ? "META-INF/wsdl/" : "WEB-INF/wsdl/";
                if (wsdlDir.length() < wsdlFileUri.lastIndexOf(47)) {
                    String intermediateDirs = wsdlFileUri.substring(wsdlDir.length(), wsdlFileUri.lastIndexOf(47));
                    absolutePath = new File(destDir, intermediateDirs);
                } else {
                    absolutePath = new File(destDir);
                }
                absolutePath.mkdirs();
                destDir = absolutePath.getAbsolutePath();
                wsdlFileUri = wsdlFileUri.substring(wsdlFileUri.lastIndexOf(47) + 1);
            }
        }
        catch (Exception e) {
            throw new AFException(e.getMessage());
        }
        this.downloadFile(filePath, destDir, wsdlFileUri);
        String exportedFileLocation = new File(destDir, wsdlFileUri).getAbsolutePath();
        return exportedFileLocation;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String uploadFile(String filePath, String name) throws AFException {
        String remotePath = null;
        File f = null;
        RandomAccessFile file = null;
        String fileName = null;
        try {
            try {
                ObjectName mbeanName = ObjectNames.getControllerObjectName();
                f = new File(filePath);
                file = new RandomAccessFile(f, "r");
                if (name != null && name.length() > 0) {
                    int lastDot = filePath.lastIndexOf(".");
                    if (lastDot != -1) {
                        String ext = filePath.substring(lastDot);
                        fileName = name + ext;
                    }
                } else {
                    fileName = f.getName();
                }
                Debug.println("UploadFile : fileName = " + fileName);
                byte[] bytes = new byte[0xA00000];
                int bytesRead = 0;
                long totalBytesRead = 0L;
                boolean isFirstChunk = true;
                boolean isLastChunk = false;
                long fileSize = file.length();
                int index = 0;
                long begin = System.currentTimeMillis();
                while ((bytesRead = file.read(bytes)) != -1) {
                    totalBytesRead += (long)bytesRead;
                    if (bytesRead < bytes.length) {
                        byte[] realBytes = new byte[bytesRead];
                        for (int i = 0; i < bytesRead; ++i) {
                            realBytes[i] = bytes[i];
                        }
                        bytes = realBytes;
                    }
                    if (totalBytesRead == fileSize) {
                        isLastChunk = true;
                    }
                    ByteChunk aChunk = new ByteChunk(bytes, fileName, isFirstChunk, isLastChunk);
                    aChunk.setTargetDir(this.appServer);
                    ParamInfo paramInfo = new ParamInfo(UPLOAD_OPERATION, aChunk);
                    Object result = this.mbsc.invoke(mbeanName, paramInfo.getOperationName(), paramInfo.getParams(), paramInfo.getSignature());
                    remotePath = (String)result;
                    Debug.println("DEBUG : Chunk[" + index + "] sent");
                    ++index;
                    isFirstChunk = false;
                }
                long end = System.currentTimeMillis();
                Debug.println("Time to transfer : " + (end - begin) + " ms");
                Debug.println("File transferred to " + remotePath);
            }
            catch (Exception e) {
                throw new AFException(e.getLocalizedMessage());
            }
            Object var23_24 = null;
            if (file == null) return remotePath;
        }
        catch (Throwable throwable) {
            Object var23_25 = null;
            if (file == null) throw throwable;
            try {
                file.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        file.close();
        return remotePath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void downloadFile(String filePath, String destinationDirPath, String appName) throws AFException {
        File destDir = new File(destinationDirPath);
        if (!destDir.exists()) {
            String msg = localStrings.getString("suntarget.desstdir_does_not_exist", destinationDirPath);
            throw new AFException(msg);
        }
        FileOutputStream fos = null;
        try {
            try {
                ObjectName controllerObjectName = ObjectNames.getControllerObjectName();
                this.mbsc.invoke(controllerObjectName, PREPARE_DOWNLOAD, new Object[]{filePath}, new String[]{"java.lang.String"});
                fos = new FileOutputStream(new File(destinationDirPath, appName));
                boolean lastChunk = false;
                int chunkIndex = 0;
                while (!lastChunk) {
                    Object[] params = new Object[]{new Integer(chunkIndex)};
                    String[] signature = new String[]{"int"};
                    ByteChunk chunk = (ByteChunk)this.mbsc.invoke(controllerObjectName, DOWNLOAD_FILE, params, signature);
                    ++chunkIndex;
                    lastChunk = chunk.isLast();
                    byte[] bytes = chunk.getBytes();
                    fos.write(bytes, 0, bytes.length);
                }
                Object var14_15 = null;
                if (fos == null) return;
            }
            catch (Exception e) {
                throw new AFException(e.toString());
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            if (fos == null) throw throwable;
            try {
                fos.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        fos.close();
        return;
    }
}

