/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployapi;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.archivist.AbstractArchive;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.archivist.InputJarArchive;
import com.sun.enterprise.deployment.archivist.JarArchiveFactory;
import com.sun.enterprise.deployment.archivist.MemoryMappedArchive;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javax.enterprise.deploy.shared.ModuleType;
import org.xml.sax.SAXParseException;

public class SunDeploymentPlan {
    public void getDeploymentPlan(File archive, OutputStream os) throws IOException, SAXParseException {
        Archivist archivist = ArchivistFactory.getArchivistForArchive(archive);
        InputJarArchive jar = new InputJarArchive();
        jar.open(archive.getAbsolutePath());
        JarOutputStream jos = new JarOutputStream(os);
        if (archivist.getModuleType().equals(ModuleType.EAR)) {
            DeploymentDescriptorFile ddFile = archivist.getStandardDDFile();
            InputStream is = new BufferedInputStream(jar.getEntry(ddFile.getDeploymentDescriptorPath()));
            Application app = (Application)ddFile.read(is);
            ((InputStream)is).close();
            Iterator itr = app.getModules();
            while (itr.hasNext()) {
                Enumeration e;
                ModuleDescriptor module = (ModuleDescriptor)itr.next();
                Archivist subArchivist = ArchivistFactory.getArchivistForType(module.getModuleType());
                AbstractArchive subJar = jar.getEmbeddedArchive(module.getArchiveUri());
                String runtimeDDPath = subArchivist.getRuntimeDeploymentDescriptorPath();
                InputStream subIs = subJar.getEntry(runtimeDDPath);
                String entryName = module.getArchiveUri() + "." + runtimeDDPath.substring(runtimeDDPath.lastIndexOf(47) + 1);
                this.copy(subIs, entryName, jos);
                String mappingPath = "META-INF/sun-cmp-mappings.xml";
                subIs = subJar.getEntry(mappingPath);
                if (subIs != null) {
                    this.copy(subIs, module.getArchiveUri() + ".sun-cmp-mappings.xml", jos);
                }
                if ((e = subJar.entries()) != null) {
                    while (e.hasMoreElements()) {
                        entryName = (String)e.nextElement();
                        if (!entryName.endsWith(".dbschema")) continue;
                        subIs = subJar.getEntry(entryName);
                        this.copy(subIs, module.getArchiveUri() + "." + entryName.replaceAll("/", "#"), jos);
                    }
                }
                subJar.close();
            }
            String runtimeDDPath = archivist.getRuntimeDeploymentDescriptorPath();
            is = jar.getEntry(runtimeDDPath);
            if (is != null) {
                this.copy(new BufferedInputStream(is), runtimeDDPath.substring(runtimeDDPath.lastIndexOf(47) + 1), jos);
            }
        } else {
            String runtimeDDPath = archivist.getRuntimeDeploymentDescriptorPath();
            InputStream is = new BufferedInputStream(jar.getEntry(runtimeDDPath));
            this.copy(is, runtimeDDPath.substring(runtimeDDPath.lastIndexOf(47) + 1), jos);
            runtimeDDPath = "META-INF/sun-cmp-mappings.xml";
            is = new BufferedInputStream(jar.getEntry(runtimeDDPath));
            this.copy(is, runtimeDDPath.substring(runtimeDDPath.lastIndexOf(47) + 1), jos);
            Enumeration entries = jar.entries();
            while (entries.hasMoreElements()) {
                String entryName = (String)entries.nextElement();
                if (!entryName.endsWith(".dbschema")) continue;
                is = jar.getEntry(entryName);
                this.copy(is, entryName.replace('/', '#'), jos);
            }
        }
        jos.close();
        jar.close();
    }

    public void mergeDeploymentPlan(AbstractArchive jar, InputStream deploymentPlan, OutputStream out) throws IOException, SAXParseException {
        JarOutputStream jos;
        block23: {
            MemoryMappedArchive dpArchive;
            Vector dpEntries;
            Archivist archivist;
            block21: {
                String runtimeDDPath;
                InputStream is;
                block22: {
                    archivist = ArchivistFactory.getArchivistForArchive(jar);
                    dpEntries = new Vector();
                    dpArchive = null;
                    if (deploymentPlan != null) {
                        dpArchive = new MemoryMappedArchive(deploymentPlan);
                        Enumeration e = dpArchive.entries();
                        while (e.hasMoreElements()) {
                            dpEntries.add(e.nextElement());
                        }
                    }
                    jos = new JarOutputStream(out);
                    if (!archivist.getModuleType().equals(ModuleType.EAR)) break block21;
                    DeploymentDescriptorFile ddFile = archivist.getStandardDDFile();
                    is = new BufferedInputStream(jar.getEntry(ddFile.getDeploymentDescriptorPath()));
                    Application app = (Application)ddFile.read(is);
                    ((InputStream)is).close();
                    Iterator itr = app.getModules();
                    while (itr.hasNext()) {
                        Manifest m;
                        String entryName;
                        ModuleDescriptor moduleDesc = (ModuleDescriptor)itr.next();
                        Archivist subArchivist = ArchivistFactory.getArchivistForType(moduleDesc.getModuleType());
                        String archiveUri = moduleDesc.getArchiveUri();
                        AbstractArchive subIn = jar.getEmbeddedArchive(archiveUri);
                        String runtimeDDPath2 = subArchivist.getRuntimeDeploymentDescriptorPath();
                        jos.putNextEntry(new JarEntry(archiveUri));
                        JarOutputStream subOut = new JarOutputStream(jos);
                        if (dpArchive != null) {
                            String mangledName;
                            if (runtimeDDPath2 != null && dpEntries.contains(mangledName = archiveUri + "." + runtimeDDPath2.substring(runtimeDDPath2.lastIndexOf(47) + 1))) {
                                this.copy(dpArchive.getEntry(mangledName), runtimeDDPath2, subOut);
                            }
                            if (dpEntries.contains(mangledName = archiveUri + ".sun-cmp-mappings.xml")) {
                                this.copy(dpArchive.getEntry(mangledName), "META-INF/sun-cmp-mappings.xml", subOut);
                            }
                            Enumeration e = dpArchive.entries();
                            while (e.hasMoreElements()) {
                                entryName = (String)e.nextElement();
                                if (!entryName.startsWith(archiveUri + ".") || !entryName.endsWith(".dbschema")) continue;
                                String originalName = entryName.substring(archiveUri.length() + 1);
                                originalName.replace('#', '/');
                                this.copy(dpArchive.getEntry(entryName), originalName, subOut);
                            }
                        }
                        if ((m = subIn.getManifest()) != null) {
                            subOut.putNextEntry(new JarEntry("META-INF/MANIFEST.MF"));
                            m.write(subOut);
                            subOut.flush();
                            subOut.closeEntry();
                        }
                        Enumeration entries = subIn.entries();
                        while (entries.hasMoreElements()) {
                            entryName = (String)entries.nextElement();
                            try {
                                this.copy(subIn.getEntry(entryName), entryName, subOut);
                            }
                            catch (Exception e) {}
                        }
                        subOut.finish();
                        jos.flush();
                        jos.closeEntry();
                        subIn.close();
                    }
                    runtimeDDPath = archivist.getRuntimeDeploymentDescriptorPath();
                    Enumeration entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        String entryName = (String)entries.nextElement();
                        if (app.getModuleDescriptorByUri(entryName) != null || entryName.equals(runtimeDDPath)) continue;
                        try {
                            this.copy(jar.getEntry(entryName), entryName, jos);
                        }
                        catch (Exception e) {}
                    }
                    this.copyManifest(jar, jos);
                    if (dpArchive == null || runtimeDDPath == null) break block22;
                    is = dpArchive.getEntry(runtimeDDPath.substring(runtimeDDPath.lastIndexOf(47) + 1));
                    if (is != null) {
                        this.copy(is, runtimeDDPath, jos);
                    }
                    break block23;
                }
                is = jar.getEntry(runtimeDDPath);
                if (is == null) break block23;
                this.copy(is, runtimeDDPath, jos);
                break block23;
            }
            String runtimeDDPath = archivist.getRuntimeDeploymentDescriptorPath();
            if (runtimeDDPath != null && dpEntries.contains(runtimeDDPath.substring(runtimeDDPath.lastIndexOf(47) + 1))) {
                this.copy(dpArchive.getEntry(runtimeDDPath.substring(runtimeDDPath.lastIndexOf(47) + 1)), runtimeDDPath, jos);
            }
            if (dpEntries.contains("sun-cmp-mappings.xml")) {
                this.copy(dpArchive.getEntry("sun-cmp-mappings.xml"), "META-INF/sun-cmp-mappings.xml", jos);
            }
            Iterator itr = dpEntries.iterator();
            while (itr.hasNext()) {
                String name = (String)itr.next();
                if (!name.endsWith(".dbschema")) continue;
                this.copy(dpArchive.getEntry(name), name.replace('#', '/'), jos);
            }
            Enumeration entries = jar.entries();
            while (entries.hasMoreElements()) {
                String entryName = (String)entries.nextElement();
                try {
                    this.copy(jar.getEntry(entryName), entryName, jos);
                }
                catch (Exception e) {}
            }
        }
        jos.flush();
        jos.close();
    }

    private void copy(InputStream is, String entryName, JarOutputStream out) throws IOException {
        JarEntry ze = new JarEntry(entryName);
        out.putNextEntry(ze);
        Archivist.copyWithoutClose(is, out);
        is.close();
        out.flush();
        out.closeEntry();
    }

    private void copyManifest(AbstractArchive in, JarOutputStream jarOut) throws IOException {
        Manifest manifest = in.getManifest();
        if (manifest != null) {
            jarOut.putNextEntry(new JarEntry("META-INF/MANIFEST.MF"));
            manifest.write(jarOut);
            jarOut.closeEntry();
        }
    }

    public static void main(String[] args) {
        try {
            SunDeploymentPlan dp = new SunDeploymentPlan();
            File f = new File("deployment.plan");
            dp.getDeploymentPlan(new File(args[0]), new FileOutputStream(f));
            dp.mergeDeploymentPlan(new JarArchiveFactory().openArchive(args[0]), new FileInputStream(f), new FileOutputStream(new File("merged.ear")));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

