/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployapi;

import com.sun.appserv.management.client.ConnectionSource;
import com.sun.enterprise.admin.util.HostAndPort;
import com.sun.enterprise.deployapi.DeploymentStatusImpl;
import com.sun.enterprise.deployapi.SunDeploymentManager;
import com.sun.enterprise.deployapi.SunTarget;
import com.sun.enterprise.deployapi.SunTargetModuleID;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.deployment.client.JESProgressObject;
import com.sun.enterprise.deployment.client.RollBackAction;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.util.Print;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Iterator;
import java.util.Vector;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public abstract class ProgressObjectImpl
implements Runnable,
JESProgressObject {
    protected CommandType commandType;
    protected Object[] args;
    private Vector listeners = new Vector();
    protected SunTarget target;
    protected SunTarget[] targetsList;
    protected String moduleID;
    protected ModuleType moduleType;
    protected DeploymentStatusImpl deploymentStatus = null;
    protected TargetModuleID[] targetModuleIDs = null;
    protected Vector deliveredEvents = new Vector();
    protected DeploymentStatus finalDeploymentStatus = null;
    protected boolean deployActionCompleted;
    protected String warningMessages;
    private static StringManager localStrings = StringManager.getManager(ProgressObjectImpl.class);
    protected static final String APPS_CONFIGMBEAN_OBJNAME = "com.sun.appserv:type=applications,category=config";

    public ProgressObjectImpl(SunTarget target) {
        this.target = target;
        this.deploymentStatus = new DeploymentStatusImpl(this);
        this.deploymentStatus.setState(StateType.RELEASED);
        this.finalDeploymentStatus = new DeploymentStatus();
        this.deployActionCompleted = false;
    }

    public ProgressObjectImpl(SunTarget[] targets) {
        this.targetsList = targets;
        this.deploymentStatus = new DeploymentStatusImpl(this);
        this.deploymentStatus.setState(StateType.RELEASED);
        this.finalDeploymentStatus = new DeploymentStatus();
        this.deployActionCompleted = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProgressListener(ProgressListener pol) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.add(pol);
            if (this.deliveredEvents.size() > 0) {
                Print.dprintln("Delivering undelivered messages...");
                Iterator i = this.deliveredEvents.iterator();
                while (i.hasNext()) {
                    pol.handleProgressEvent((ProgressEvent)i.next());
                }
            }
        }
    }

    public void cancel() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("cancel not supported");
    }

    public ClientConfiguration getClientConfiguration(TargetModuleID id) {
        return null;
    }

    public javax.enterprise.deploy.spi.status.DeploymentStatus getDeploymentStatus() {
        DeploymentStatusImpl result = new DeploymentStatusImpl(this);
        result.setState(this.deploymentStatus.getState());
        result.setMessage(this.deploymentStatus.getMessage());
        return this.deploymentStatus;
    }

    public DeploymentStatus getCompletedStatus() {
        if (this.deployActionCompleted) {
            return this.finalDeploymentStatus;
        }
        return null;
    }

    public TargetModuleID[] getResultTargetModuleIDs() {
        if (this.targetModuleIDs == null) {
            if (this.target != null) {
                this.initializeTargetModuleIDs(this.moduleID, null, null);
            } else if (this.targetsList != null) {
                this.initializeTargetModuleIDForAllServers(this.moduleID, null, null);
            }
        }
        return this.targetModuleIDs;
    }

    protected void initializeTargetModuleIDs(String moduleID, Application app, MBeanServerConnection mbsc) {
        SunTargetModuleID parentTargetModuleID = new SunTargetModuleID(moduleID, this.target);
        parentTargetModuleID.setModuleType(this.getModuleType());
        this.targetModuleIDs = new SunTargetModuleID[1];
        this.targetModuleIDs[0] = parentTargetModuleID;
        if (mbsc == null) {
            return;
        }
        HostAndPort webHost = null;
        try {
            Object[] params = new Object[]{moduleID, Boolean.FALSE};
            String[] signature = new String[]{"java.lang.String", "boolean"};
            ObjectName applicationsMBean = new ObjectName(APPS_CONFIGMBEAN_OBJNAME);
            webHost = (HostAndPort)mbsc.invoke(applicationsMBean, "getHostAndPort", params, signature);
        }
        catch (Exception e) {
            Print.dprintStackTrace(e.getLocalizedMessage(), e);
        }
        if (app == null) {
            return;
        }
        if (!app.isVirtual()) {
            Iterator moduleItr = app.getModules();
            while (moduleItr.hasNext()) {
                ModuleDescriptor md = (ModuleDescriptor)moduleItr.next();
                SunTargetModuleID subModule = new SunTargetModuleID(moduleID + "#" + md.getArchiveUri(), this.target);
                subModule.setModuleType(md.getModuleType());
                if (md.getModuleType().equals(ModuleType.WAR) && webHost != null) {
                    this.initTargetModuleIDWebURL(subModule, webHost, (WebBundleDescriptor)md.getDescriptor());
                }
                parentTargetModuleID.addChildTargetModuleID(subModule);
            }
        } else {
            BundleDescriptor bd = app.getStandaloneBundleDescriptor();
            if (bd.getModuleType().equals(ModuleType.WAR)) {
                this.initTargetModuleIDWebURL(parentTargetModuleID, webHost, (WebBundleDescriptor)bd);
            }
        }
    }

    protected void initializeTargetModuleIDForAllServers(String moduleID, Application app, MBeanServerConnection mbsc) {
        if (this.targetsList == null) {
            return;
        }
        this.targetModuleIDs = new SunTargetModuleID[this.targetsList.length];
        for (int i = 0; i < this.targetsList.length; ++i) {
            SunTargetModuleID parentTargetModuleID = new SunTargetModuleID(moduleID, this.targetsList[i]);
            parentTargetModuleID.setModuleType(this.getModuleType());
            this.targetModuleIDs[i] = parentTargetModuleID;
            if (app == null) continue;
            HostAndPort webHost = null;
            try {
                Object[] params = new Object[]{moduleID, Boolean.FALSE};
                String[] signature = new String[]{"java.lang.String", "boolean"};
                ObjectName applicationsMBean = new ObjectName(APPS_CONFIGMBEAN_OBJNAME);
                webHost = (HostAndPort)mbsc.invoke(applicationsMBean, "getHostAndPort", params, signature);
            }
            catch (Exception e) {
                Print.dprintStackTrace(e.getLocalizedMessage(), e);
            }
            if (!app.isVirtual()) {
                Iterator moduleItr = app.getModules();
                while (moduleItr.hasNext()) {
                    ModuleDescriptor md = (ModuleDescriptor)moduleItr.next();
                    SunTargetModuleID subModule = new SunTargetModuleID(moduleID + "#" + md.getArchiveUri(), this.targetsList[i]);
                    subModule.setModuleType(md.getModuleType());
                    if (md.getModuleType().equals(ModuleType.WAR) && webHost != null) {
                        this.initTargetModuleIDWebURL(subModule, webHost, (WebBundleDescriptor)md.getDescriptor());
                    }
                    parentTargetModuleID.addChildTargetModuleID(subModule);
                }
                continue;
            }
            BundleDescriptor bd = app.getStandaloneBundleDescriptor();
            if (!bd.getModuleType().equals(ModuleType.WAR)) continue;
            this.initTargetModuleIDWebURL(parentTargetModuleID, webHost, (WebBundleDescriptor)bd);
        }
    }

    private void initTargetModuleIDWebURL(SunTargetModuleID tm, HostAndPort webHost, WebBundleDescriptor bd) {
        if (webHost == null) {
            return;
        }
        try {
            SunDeploymentManager sdm;
            String contextRoot = bd.getContextRoot();
            if (!contextRoot.startsWith("/")) {
                contextRoot = "/" + contextRoot;
            }
            String host = (sdm = new SunDeploymentManager(tm.getConnectionInfo())).isPE() ? tm.getConnectionInfo().getHostName() : webHost.getHost();
            URL webURL = new URL("http", host, webHost.getPort(), contextRoot);
            tm.setWebURL(webURL.toExternalForm());
        }
        catch (Exception e) {
            Print.dprintStackTrace(e.getLocalizedMessage(), e);
        }
    }

    public boolean isCancelSupported() {
        return false;
    }

    public boolean isStopSupported() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProgressListener(ProgressListener pol) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.remove(pol);
        }
    }

    public void stop() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("stop not supported");
    }

    public void setCommand(CommandType commandType, Object[] args) {
        this.commandType = commandType;
        this.args = args;
    }

    public abstract void run();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireProgressEvent(ProgressEvent progressEvent) {
        Vector currentListeners = null;
        Vector vector = this.listeners;
        synchronized (vector) {
            currentListeners = (Vector)this.listeners.clone();
            this.deliveredEvents.add(progressEvent);
        }
        Iterator listenersItr = currentListeners.iterator();
        while (listenersItr.hasNext()) {
            ((ProgressListener)listenersItr.next()).handleProgressEvent(progressEvent);
        }
        currentListeners = null;
    }

    protected void fireProgressEvent(StateType state, String message) {
        if (state != null) {
            this.deploymentStatus.setState(state);
        }
        DeploymentStatusImpl depStatus = new DeploymentStatusImpl(this);
        depStatus.setState(this.deploymentStatus.getState());
        depStatus.setMessage(message);
        SunTargetModuleID tmi = new SunTargetModuleID(this.moduleID, this.target);
        tmi.setModuleType(this.getModuleType());
        this.fireProgressEvent(new ProgressEvent((Object)this, (TargetModuleID)tmi, (javax.enterprise.deploy.spi.status.DeploymentStatus)depStatus));
    }

    protected void fireProgressEvent(StateType state, String message, SunTarget aTarget) {
        if (state != null) {
            this.deploymentStatus.setState(state);
        }
        DeploymentStatusImpl depStatus = new DeploymentStatusImpl(this);
        depStatus.setState(this.deploymentStatus.getState());
        depStatus.setMessage(message);
        SunTargetModuleID tmi = new SunTargetModuleID(this.moduleID, aTarget);
        tmi.setModuleType(this.getModuleType());
        this.fireProgressEvent(new ProgressEvent((Object)this, (TargetModuleID)tmi, (javax.enterprise.deploy.spi.status.DeploymentStatus)depStatus));
    }

    CommandType getCommandType() {
        return this.commandType;
    }

    public void setModuleType(ModuleType moduleType) {
        this.moduleType = moduleType;
    }

    public ModuleType getModuleType() {
        return this.moduleType;
    }

    protected String getThrowableString(Throwable t) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bos);
        t.printStackTrace(ps);
        ps.close();
        return bos.toString();
    }

    protected String getDeploymentStatusMessage(DeploymentStatus status) {
        if (status == null) {
            return null;
        }
        if (status != null && status.getStatus() >= 2) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(bos);
        DeploymentStatus.parseDeploymentStatus(status, pw);
        byte[] statusBytes = bos.toByteArray();
        String statusString = new String(statusBytes);
        if (status.getStatus() == 1) {
            this.warningMessages = this.warningMessages == null ? statusString : this.warningMessages + statusString;
            return null;
        }
        return statusString;
    }

    protected void setupForNormalExit(String message, SunTarget aTarget) {
        String i18nmsg;
        if (this.warningMessages == null) {
            i18nmsg = localStrings.getString("enterprise.deployment.client.action_completed", message);
            this.finalDeploymentStatus.setStageStatus(2);
        } else {
            i18nmsg = localStrings.getString("enterprise.deployment.client.action_completed_with_warning", this.warningMessages);
            this.finalDeploymentStatus.setStageStatus(1);
        }
        this.finalDeploymentStatus.setStageStatusMessage(i18nmsg);
        this.deployActionCompleted = true;
        this.fireProgressEvent(StateType.COMPLETED, i18nmsg, aTarget);
    }

    protected void setupForAbnormalExit(String errorMsg, SunTarget aTarget) {
        String i18nmsg = localStrings.getString("enterprise.deployment.client.action_failed", errorMsg);
        this.finalDeploymentStatus.setStageStatus(0);
        this.finalDeploymentStatus.setStageStatusMessage(i18nmsg);
        this.deployActionCompleted = true;
        this.fireProgressEvent(StateType.FAILED, i18nmsg, aTarget);
    }

    protected boolean checkStatusAndAddStage(SunTarget aTarget, RollBackAction rollback, String action, ConnectionSource dasConnection, DeploymentStatus currentStatus) {
        String statusMsg = this.getDeploymentStatusMessage(currentStatus);
        this.finalDeploymentStatus.addSubStage(currentStatus);
        if (statusMsg == null) {
            this.fireProgressEvent(StateType.RUNNING, localStrings.getString("enterprise.deployment.client.action_completed", action), aTarget);
            return true;
        }
        if (rollback != null) {
            DeploymentStatus tmp = new DeploymentStatus();
            if (!rollback.rollback(dasConnection, tmp)) {
                this.fireProgressEvent(StateType.RUNNING, localStrings.getString("enterprise.deployment.client.action_failed", "Rollback failed"), aTarget);
                tmp.setStageStatus(0);
                tmp.setStageStatusMessage(localStrings.getString("enterprise.deployment.client.action_failed", "Rollback failed"));
            } else {
                this.fireProgressEvent(StateType.RUNNING, localStrings.getString("enterprise.deployment.client.action_completed", "Rollback"), aTarget);
                tmp.setStageStatus(2);
                tmp.setStageStatusMessage(localStrings.getString("enterprise.deployment.client.action_completed", "Rollback"));
            }
            this.finalDeploymentStatus.addSubStage(tmp);
        }
        this.setupForAbnormalExit(action + " failed; " + statusMsg, aTarget);
        return false;
    }
}

