/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.system;

import com.sun.enterprise.Switch;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.AdminObjectResource;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.JmsHost;
import com.sun.enterprise.config.serverbeans.JmsService;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.connectors.ActiveInboundResourceAdapter;
import com.sun.enterprise.connectors.ConnectorAdminServiceUtils;
import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.ConnectorRuntimeException;
import com.sun.enterprise.connectors.inflow.MdbContainerProps;
import com.sun.enterprise.connectors.system.MQAddressList;
import com.sun.enterprise.connectors.system.MQAdministrator;
import com.sun.enterprise.connectors.util.JmsRaUtil;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.runtime.BeanPoolDescriptor;
import com.sun.enterprise.jms.JmsProviderLifecycle;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;

public class ActiveJmsResourceAdapter
extends ActiveInboundResourceAdapter {
    static Logger logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    private final String SETTER = "setProperty";
    private static final String SEPARATOR = "#";
    private final String CONNECTION_URL = "ConnectionURL";
    private final String RECONNECTENABLED = "ReconnectEnabled";
    private final String RECONNECTINTERVAL = "ReconnectInterval";
    private final String RECONNECTATTEMPTS = "ReconnectAttempts";
    private static final String GROUPNAME = "GroupName";
    private static final String CLUSTERCONTAINER = "InClusteredContainer";
    private final String CONTAINER = "InAppClientContainer";
    private static String DESTINATION = "Destination";
    private static String DESTINATION_TYPE = "DestinationType";
    private static String SUBSCRIPTION_NAME = "SubscriptionName";
    private static String CLIENT_ID = "ClientID";
    private static String PHYSICAL_DESTINATION = "Name";
    private static String MAXPOOLSIZE = "EndpointPoolMaxSize";
    private static String MINPOOLSIZE = "EndpointPoolSteadySize";
    private static String RESIZECOUNT = "EndpointPoolResizeCount";
    private static String RESIZETIMEOUT = "EndpointPoolResizeTimeout";
    private static String REDELIVERYCOUNT = "EndpointExceptionRedeliveryAttempts";
    private static String ADDRESSLIST = "AddressList";
    private static String ADRLIST_BEHAVIOUR = "AddressListBehavior";
    private static String ADRLIST_ITERATIONS = "AddressListIterations";
    private static final String MDBIDENTIFIER = "MdbName";
    private static final String MCFADDRESSLIST = "MessageServiceAddressList";
    private StringManager sm = StringManager.getManager(ActiveJmsResourceAdapter.class);
    MQAddressList urlList = null;
    static /* synthetic */ Class class$java$lang$String;

    public ActiveJmsResourceAdapter(ResourceAdapter ra, ConnectorDescriptor desc, String moduleName, ClassLoader jcl) throws ConnectorRuntimeException {
        super(ra, desc, moduleName, jcl);
    }

    protected void loadRAConfiguration() throws ConnectorRuntimeException {
        if (ConnectorRuntime.getRuntime().getEnviron() == 1) {
            try {
                JmsProviderLifecycle.checkProviderStartup();
            }
            catch (Exception e) {
                ConnectorRuntimeException cre = new ConnectorRuntimeException(e.getMessage());
                throw (ConnectorRuntimeException)cre.initCause(e);
            }
            this.setMdbContainerProperties();
            this.setJmsServiceProperties(null);
            this.setClusterRABeanProperties();
        } else {
            this.setAppClientRABeanProperties();
        }
        super.loadRAConfiguration();
    }

    private void setClusterRABeanProperties() throws ConnectorRuntimeException {
        ConnectorDescriptor cd = super.getDescriptor();
        try {
            if (this.isClustered()) {
                String val = this.getGroupName();
                EnvironmentProperty envProp = new EnvironmentProperty(GROUPNAME, val, "Group Name", "java.lang.String");
                this.setProperty(cd, envProp);
                EnvironmentProperty envProp1 = new EnvironmentProperty(CLUSTERCONTAINER, "true", "Cluster flag", "java.lang.Boolean");
                this.setProperty(cd, envProp1);
                logger.fine("CLUSTERED instance - setting groupname as" + val);
            } else {
                logger.fine("Instance not Clustered and hence not setting groupname");
            }
        }
        catch (ConfigException e) {
            ConnectorRuntimeException crex = new ConnectorRuntimeException(e.getMessage());
            throw (ConnectorRuntimeException)crex.initCause(e);
        }
    }

    private void setAppClientRABeanProperties() throws ConnectorRuntimeException {
        ConnectorDescriptor cd = super.getDescriptor();
        EnvironmentProperty envProp = new EnvironmentProperty(GROUPNAME, "", "Group Name", "java.lang.String");
        cd.removeConfigProperty(envProp);
        EnvironmentProperty envProp1 = new EnvironmentProperty(CLUSTERCONTAINER, "false", "Cluster flag", "java.lang.Boolean");
        this.setProperty(cd, envProp1);
    }

    private boolean isClustered() throws ConfigException {
        try {
            ConfigContext ctxt = ApplicationServer.getServerContext().getConfigContext();
            return ServerHelper.isServerClustered(ctxt, ApplicationServer.getServerContext().getInstanceName());
        }
        catch (ConfigException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private String getGroupName() throws ConfigException {
        return this.getDomainName() + SEPARATOR + this.getClusterName();
    }

    private String getClusterName() throws ConfigException {
        return ClusterHelper.getClusterForInstance(ApplicationServer.getServerContext().getConfigContext(), ApplicationServer.getServerContext().getInstanceName()).getName();
    }

    private String getDomainName() throws ConfigException {
        ConfigContext ctxt = ApplicationServer.getServerContext().getConfigContext();
        return "";
    }

    public void reloadRA(JmsService js) throws ConnectorRuntimeException {
        this.setMdbContainerProperties();
        this.setJmsServiceProperties(js);
        super.loadRAConfiguration();
        this.rebindDescriptor();
    }

    public void addJmsHost(JmsHost host) throws ConnectorRuntimeException {
        this.urlList.addMQUrl(host);
        this.setAddressList();
    }

    public void deleteJmsHost(JmsHost host) throws ConnectorRuntimeException {
        this.urlList.removeMQUrl(host);
        this.setAddressList();
    }

    public void updateJmsHost(JmsHost host) throws ConnectorRuntimeException {
        this.urlList.updateMQUrl(host);
        this.setAddressList();
    }

    private void setMdbContainerProperties() throws ConnectorRuntimeException {
        JmsRaUtil raUtil = new JmsRaUtil(null);
        ConnectorDescriptor cd = super.getDescriptor();
        raUtil.setMdbContainerProperties();
        String val = "" + MdbContainerProps.getReconnectEnabled();
        EnvironmentProperty envProp2 = new EnvironmentProperty("ReconnectEnabled", val, val, "java.lang.Boolean");
        this.setProperty(cd, envProp2);
        val = "" + MdbContainerProps.getReconnectDelay() * 1000;
        EnvironmentProperty envProp3 = new EnvironmentProperty("ReconnectInterval", val, val, "java.lang.Integer");
        this.setProperty(cd, envProp3);
        val = "" + MdbContainerProps.getReconnectMaxRetries();
        EnvironmentProperty envProp4 = new EnvironmentProperty("ReconnectAttempts", val, val, "java.lang.Integer");
        this.setProperty(cd, envProp4);
    }

    private void setAddressList() throws ConnectorRuntimeException {
        ConnectorDescriptor cd = super.getDescriptor();
        String val = this.urlList.toString();
        if (val != null) {
            EnvironmentProperty envProp1 = new EnvironmentProperty("ConnectionURL", val, val, "java.lang.String");
            this.setProperty(cd, envProp1);
        }
        super.loadRAConfiguration();
    }

    private void setJmsServiceProperties(JmsService service) throws ConnectorRuntimeException {
        JmsRaUtil jmsraUtil = new JmsRaUtil(service);
        String val = jmsraUtil.getUrl();
        this.urlList = jmsraUtil.getUrlList();
        ConnectorDescriptor cd = super.getDescriptor();
        logger.info("JMS Service Connection URL is :" + val);
        if (val != null) {
            EnvironmentProperty envProp1 = new EnvironmentProperty("ConnectionURL", val, val, "java.lang.String");
            this.setProperty(cd, envProp1);
        }
        val = "" + jmsraUtil.getReconnectEnabled();
        EnvironmentProperty envProp2 = new EnvironmentProperty("ReconnectEnabled", val, val, "java.lang.Boolean");
        this.setProperty(cd, envProp2);
        if (jmsraUtil.getReconnectInterval() != null) {
            int newval = new Integer(jmsraUtil.getReconnectInterval()) * 1000;
            val = "" + newval;
            EnvironmentProperty envProp3 = new EnvironmentProperty("ReconnectInterval", val, val, "java.lang.Integer");
            this.setProperty(cd, envProp3);
        }
        val = "" + jmsraUtil.getReconnectAttempts();
        EnvironmentProperty envProp4 = new EnvironmentProperty("ReconnectAttempts", val, val, "java.lang.Integer");
        this.setProperty(cd, envProp4);
        val = "" + jmsraUtil.getAddressListBehaviour();
        EnvironmentProperty envProp5 = new EnvironmentProperty(ADRLIST_BEHAVIOUR, val, val, "java.lang.String");
        this.setProperty(cd, envProp5);
        val = "" + jmsraUtil.getAddressListIterations();
        EnvironmentProperty envProp6 = new EnvironmentProperty(ADRLIST_ITERATIONS, val, val, "java.lang.Integer");
        this.setProperty(cd, envProp6);
    }

    private void setProperty(ConnectorDescriptor cd, EnvironmentProperty envProp) {
        cd.removeConfigProperty(envProp);
        cd.addConfigProperty(envProp);
    }

    private void rebindDescriptor() throws ConnectorRuntimeException {
        try {
            String descriptorJNDIName = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForDescriptor(super.getModuleName());
            Switch.getSwitch().getNamingManager().publishObject(descriptorJNDIName, (Object)super.getDescriptor(), true);
        }
        catch (NamingException ne) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException(ne.getMessage());
            throw (ConnectorRuntimeException)cre.initCause(ne);
        }
    }

    public ManagedConnectionFactory createManagedConnectionFactory(ConnectorConnectionPool cpr, ClassLoader loader) {
        ManagedConnectionFactory mcf = super.createManagedConnectionFactory(cpr, loader);
        if (mcf != null) {
            Set s = cpr.getConnectorDescriptorInfo().getMCFConfigProperties();
            Iterator it = s.iterator();
            while (it.hasNext()) {
                EnvironmentProperty prop = (EnvironmentProperty)it.next();
                String propName = prop.getName();
                propName.substring(1);
                if (!propName.startsWith("imq") || prop.getValue() == "") continue;
                try {
                    Method meth = mcf.getClass().getMethod("setProperty", class$java$lang$String == null ? ActiveJmsResourceAdapter.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? ActiveJmsResourceAdapter.class$("java.lang.String") : class$java$lang$String);
                    meth.invoke((Object)mcf, prop.getName(), prop.getValueObject());
                }
                catch (NoSuchMethodException ex) {
                    logger.log(Level.WARNING, "no.such.method", new Object[]{"setProperty", mcf.getClass().getName()});
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "error.execute.method", new Object[]{"setProperty", mcf.getClass().getName()});
                }
            }
        }
        return mcf;
    }

    public void updateMDBRuntimeInfo(EjbMessageBeanDescriptor descriptor_, BeanPoolDescriptor poolDescriptor) throws ConnectorRuntimeException {
        String jndiName = descriptor_.getJndiName();
        if (jndiName == null) {
            logger.log(Level.SEVERE, "Missing Destination JNDI Name");
            String msg = this.sm.getString("ajra.error_in_dd");
            throw new RuntimeException(msg);
        }
        String resourceAdapterMid = ConnectorRuntime.DEFAULT_JMS_ADAPTER;
        descriptor_.setResourceAdapterMid(resourceAdapterMid);
        String destName = this.getPhysicalDestinationFromConfiguration(jndiName);
        descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(DESTINATION, destName, null));
        if (descriptor_.getDestinationType() != null && !"".equals(descriptor_.getDestinationType())) {
            descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(DESTINATION_TYPE, descriptor_.getDestinationType(), null));
        }
        descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(SUBSCRIPTION_NAME, descriptor_.getDurableSubscriptionName(), null));
        String mdbCF = null;
        try {
            mdbCF = descriptor_.getIASEjbExtraDescriptors().getMdbConnectionFactory().getJndiName();
        }
        catch (NullPointerException ne) {
            // empty catch block
        }
        if (mdbCF != null && mdbCF != "") {
            this.setValuesFromConfiguration(mdbCF, descriptor_);
        }
        descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(MAXPOOLSIZE, "" + poolDescriptor.getMaxPoolSize(), "", "java.lang.Integer"));
        descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(MINPOOLSIZE, "" + poolDescriptor.getSteadyPoolSize(), "", "java.lang.Integer"));
        descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(RESIZECOUNT, "" + poolDescriptor.getPoolResizeQuantity(), "", "java.lang.Integer"));
        descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(RESIZETIMEOUT, "" + poolDescriptor.getPoolIdleTimeoutInSeconds(), "", "java.lang.Integer"));
        descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(REDELIVERYCOUNT, "" + MdbContainerProps.getMaxRuntimeExceptions(), "", "java.lang.Integer"));
        try {
            boolean clustered = this.isClustered();
            logger.fine("Are we in a Clustered contained ? " + clustered);
            if (clustered) {
                this.setClusterActivationSpecProperties(descriptor_);
                logger.fine("Creating physical destination " + destName);
                logger.fine("Destination is Queue? " + descriptor_.hasQueueDest());
                if (descriptor_.hasQueueDest()) {
                    this.autoCreatePhysicalDest(destName, true);
                } else {
                    this.autoCreatePhysicalDest(destName, false);
                }
            }
        }
        catch (ConfigException e) {
            ConnectorRuntimeException crex = new ConnectorRuntimeException(e.getMessage());
            throw (ConnectorRuntimeException)crex.initCause(e);
        }
    }

    void autoCreatePhysicalDest(String destName, boolean isQueue) throws ConnectorRuntimeException {
        MQAdministrator mqAdmin = new MQAdministrator();
        mqAdmin.createPhysicalDestination(destName, isQueue);
    }

    private void setClusterActivationSpecProperties(EjbMessageBeanDescriptor descriptor_) throws ConfigException {
        descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(MDBIDENTIFIER, "" + this.getMDBIdentifier(descriptor_), "MDB Identifier", "java.lang.String"));
        logger.fine("CLUSTERED instance - setting MDB identifier as" + this.getMDBIdentifier(descriptor_));
    }

    private String getMDBIdentifier(EjbMessageBeanDescriptor descriptor_) throws ConfigException {
        return this.getDomainName() + SEPARATOR + this.getClusterName() + SEPARATOR + descriptor_.getUniqueId();
    }

    private String getPhysicalDestinationFromConfiguration(String logicalDest) throws ConnectorRuntimeException {
        ElementProperty ep = null;
        try {
            ServerContext sc = ApplicationServer.getServerContext();
            ConfigContext ctx = sc.getConfigContext();
            Resources rbeans = ServerBeansFactory.getDomainBean(ctx).getResources();
            AdminObjectResource res = rbeans.getAdminObjectResourceByJndiName(logicalDest);
            if (res == null) {
                String msg = this.sm.getString("ajra.err_getting_dest", logicalDest);
                throw new ConnectorRuntimeException(msg);
            }
            ep = res.getElementPropertyByName(PHYSICAL_DESTINATION);
        }
        catch (ConfigException ce) {
            String msg = this.sm.getString("ajra.err_getting_dest", logicalDest);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(msg);
            cre.initCause(ce);
            throw cre;
        }
        if (ep == null) {
            String msg = this.sm.getString("ajra.cannot_find_phy_dest", ep);
            throw new ConnectorRuntimeException(msg);
        }
        return ep.getValue();
    }

    private void setValuesFromConfiguration(String cfName, EjbMessageBeanDescriptor descriptor_) throws ConnectorRuntimeException {
        ElementProperty[] ep = null;
        try {
            ServerContext sc = ApplicationServer.getServerContext();
            ConfigContext ctx = sc.getConfigContext();
            Resources rbeans = ServerBeansFactory.getDomainBean(ctx).getResources();
            ConnectorResource res = rbeans.getConnectorResourceByJndiName(cfName);
            if (res == null) {
                String msg = this.sm.getString("ajra.mdb_cf_not_created", cfName);
                throw new ConnectorRuntimeException(msg);
            }
            com.sun.enterprise.config.serverbeans.ConnectorConnectionPool ccp = rbeans.getConnectorConnectionPoolByName(res.getPoolName());
            ep = ccp.getElementProperty();
        }
        catch (ConfigException ce) {
            String msg = this.sm.getString("ajra.mdb_cf_not_created", cfName);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(msg);
            ce.initCause(ce);
            throw cre;
        }
        if (ep == null) {
            String msg = this.sm.getString("ajra.cannot_find_phy_dest");
            throw new ConnectorRuntimeException(msg);
        }
        for (int i = 0; i < ep.length; ++i) {
            String val;
            ElementProperty prop = ep[i];
            String name = prop.getName();
            if (name.equals(MCFADDRESSLIST)) {
                name = ADDRESSLIST;
            }
            if ((val = prop.getValue()) == null || val.equals("")) continue;
            descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(name, val, null));
        }
    }
}

