/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors;

import com.sun.enterprise.connectors.ConnectorDescriptorInfo;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.repository.J2EEResource;
import com.sun.enterprise.repository.J2EEResourceBase;
import java.io.Serializable;
import java.util.Iterator;

public class ConnectorConnectionPool
extends J2EEResourceBase
implements Serializable {
    protected ConnectorDescriptorInfo connectorDescriptorInfo_;
    protected String steadyPoolSize_;
    protected String maxPoolSize_;
    protected String maxWaitTimeInMillis_;
    protected String poolResizeQuantity_;
    protected String idleTimeoutInSeconds_;
    protected boolean failAllConnections_;
    protected boolean matchConnections_ = true;
    protected int transactionSupport_;

    public ConnectorConnectionPool(String name) {
        super(name);
    }

    protected J2EEResource doClone(String name) {
        ConnectorConnectionPool clone = new ConnectorConnectionPool(name);
        ConnectorDescriptorInfo cdi = this.connectorDescriptorInfo_.doClone();
        clone.setSteadyPoolSize(this.getSteadyPoolSize());
        clone.setMaxPoolSize(this.getMaxPoolSize());
        clone.setMaxWaitTimeInMillis(this.getMaxWaitTimeInMillis());
        clone.setPoolResizeQuantity(this.getPoolResizeQuantity());
        clone.setIdleTimeoutInSeconds(this.getIdleTimeoutInSeconds());
        clone.setFailAllConnections(this.isFailAllConnections());
        clone.setMatchConnections(this.matchConnections());
        clone.setTransactionSupport(this.getTransactionSupport());
        clone.setConnectorDescriptorInfo(cdi);
        return clone;
    }

    public ConnectorDescriptorInfo getConnectorDescriptorInfo() {
        return this.connectorDescriptorInfo_;
    }

    public void setConnectorDescriptorInfo(ConnectorDescriptorInfo connectorDescriptorInfo) {
        this.connectorDescriptorInfo_ = connectorDescriptorInfo;
    }

    public int getType() {
        return 8;
    }

    public String getSteadyPoolSize() {
        return this.steadyPoolSize_;
    }

    public void setSteadyPoolSize(String steadyPoolSize) {
        this.steadyPoolSize_ = steadyPoolSize;
    }

    public String getMaxPoolSize() {
        return this.maxPoolSize_;
    }

    public void setMaxPoolSize(String maxPoolSize) {
        this.maxPoolSize_ = maxPoolSize;
    }

    public String getMaxWaitTimeInMillis() {
        return this.maxWaitTimeInMillis_;
    }

    public void setMaxWaitTimeInMillis(String maxWaitTimeInMillis) {
        this.maxWaitTimeInMillis_ = maxWaitTimeInMillis;
    }

    public String getPoolResizeQuantity() {
        return this.poolResizeQuantity_;
    }

    public void setPoolResizeQuantity(String poolResizeQuantity) {
        this.poolResizeQuantity_ = poolResizeQuantity;
    }

    public String getIdleTimeoutInSeconds() {
        return this.idleTimeoutInSeconds_;
    }

    public void setIdleTimeoutInSeconds(String idleTimeoutInSeconds) {
        this.idleTimeoutInSeconds_ = idleTimeoutInSeconds;
    }

    public boolean isFailAllConnections() {
        return this.failAllConnections_;
    }

    public void setFailAllConnections(boolean failAllConnections) {
        this.failAllConnections_ = failAllConnections;
    }

    public boolean matchConnections() {
        return this.matchConnections_;
    }

    public void setMatchConnections(boolean matchConnections) {
        this.matchConnections_ = matchConnections;
    }

    public int getTransactionSupport() {
        return this.transactionSupport_;
    }

    public void setTransactionSupport(int transactionSupport) {
        this.transactionSupport_ = transactionSupport;
    }

    public String toString() {
        String returnVal = null;
        StringBuffer sb = new StringBuffer("ConnectorConnectionPool :: ");
        try {
            sb.append(this.getName());
            sb.append("\nsteady size: ");
            sb.append(this.getSteadyPoolSize());
            sb.append("\nmax pool size: ");
            sb.append(this.getMaxPoolSize());
            sb.append("\nmax wait time: ");
            sb.append(this.getMaxWaitTimeInMillis());
            sb.append("\npool resize qty: ");
            sb.append(this.getPoolResizeQuantity());
            sb.append("\nIdle timeout: ");
            sb.append(this.getIdleTimeoutInSeconds());
            sb.append("\nfailAllConnections: ");
            sb.append(this.isFailAllConnections());
            sb.append("\nTransaction Support Level: ");
            sb.append(this.transactionSupport_);
            sb.append("ConnectorDescriptorInfo ->\n");
            sb.append("\nrarName: ");
            sb.append(this.connectorDescriptorInfo_.getRarName());
            sb.append("\nresource adapter class: ");
            sb.append(this.connectorDescriptorInfo_.getResourceAdapterClassName());
            sb.append("\nconnection def name: ");
            sb.append(this.connectorDescriptorInfo_.getConnectionDefinitionName());
            sb.append("\nMCF Config properties->");
            Iterator iter = this.connectorDescriptorInfo_.getMCFConfigProperties().iterator();
            while (iter.hasNext()) {
                EnvironmentProperty ep = (EnvironmentProperty)iter.next();
                sb.append(ep.getName());
                sb.append(":");
                sb.append(ep.getValue());
                sb.append("\n");
            }
            returnVal = sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnVal;
    }
}

