/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors;

import com.sun.enterprise.connectors.ActiveInboundResourceAdapter;
import com.sun.enterprise.connectors.ActiveResourceAdapter;
import com.sun.enterprise.connectors.ConnectorAdminService;
import com.sun.enterprise.connectors.ConnectorRuntimeException;
import com.sun.enterprise.connectors.ConnectorServiceImpl;
import com.sun.enterprise.server.ResourcesUtil;
import java.util.Properties;
import java.util.logging.Level;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class ConnectorAdminObjectAdminServiceImpl
extends ConnectorServiceImpl
implements ConnectorAdminService {
    public void addAdminObject(String appName, String connectorName, String jndiName, String adminObjectType, Properties props) throws ConnectorRuntimeException {
        ActiveResourceAdapter ar = _registry.getActiveResourceAdapter(connectorName);
        if (ar == null) {
            this.ifSystemRarLoad(connectorName);
            ar = _registry.getActiveResourceAdapter(connectorName);
        }
        if (!(ar instanceof ActiveInboundResourceAdapter)) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException("This adapter is not 1.5 compliant");
            _logger.log(Level.SEVERE, "rardeployment.non_1.5_compliant_rar", jndiName);
            throw cre;
        }
        ActiveInboundResourceAdapter air = (ActiveInboundResourceAdapter)ar;
        air.addAdminObject(appName, connectorName, jndiName, adminObjectType, props);
    }

    public void deleteAdminObject(String jndiName) throws ConnectorRuntimeException {
        try {
            InitialContext ic = new InitialContext();
            ic.unbind(jndiName);
        }
        catch (NamingException ne) {
            ResourcesUtil resutil = ResourcesUtil.getInstance();
            if (resutil.adminObjectBelongsToSystemRar(jndiName)) {
                return;
            }
            ConnectorRuntimeException cre = new ConnectorRuntimeException("Failed to delete admin object from jndi");
            cre.initCause(ne);
            _logger.log(Level.FINE, "rardeployment.admin_object_delete_failure", jndiName);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
    }
}

