/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.StaleWriteConfigException;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.Serializable;
import java.util.Vector;
import org.netbeans.modules.schema2beans.BeanComparator;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.GenBeans;

public class Servers
extends ConfigBean
implements Serializable {
    static Vector comparators = new Vector();
    public static final String SERVER = "Server";

    public Servers() {
        this(Common.USE_DEFAULT_VALUES);
    }

    public Servers(int options) {
        super(comparators, new GenBeans.Version(1, 0, 8));
        this.createProperty("server", SERVER, 66096, Server.class);
        this.createAttribute(SERVER, "name", "Name", 257, null, null);
        this.createAttribute(SERVER, "config-ref", "ConfigRef", 513, null, null);
        this.createAttribute(SERVER, "node-agent-ref", "NodeAgentRef", 513, null, null);
        this.initialize(options);
    }

    void initialize(int options) {
    }

    public void setServer(int index, Server value) {
        this.setValue(SERVER, index, value);
    }

    public Server getServer(int index) {
        return (Server)this.getValue(SERVER, index);
    }

    public void setServer(Server[] value) {
        this.setValue(SERVER, value);
    }

    public Server[] getServer() {
        return (Server[])this.getValues(SERVER);
    }

    public int sizeServer() {
        return this.size(SERVER);
    }

    public int addServer(Server value) throws ConfigException {
        return this.addServer(value, true);
    }

    public int addServer(Server value, boolean overwrite) throws ConfigException {
        Server old = this.getServerByName(value.getName());
        if (old != null) {
            throw new ConfigException(StringManager.getManager(Servers.class).getString("cannotAddDuplicate", SERVER));
        }
        return this.addValue(SERVER, value, overwrite);
    }

    public int removeServer(Server value) {
        return this.removeValue(SERVER, value);
    }

    public int removeServer(Server value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(SERVER, value, overwrite);
    }

    public Server getServerByName(String id) {
        Server[] o;
        if (null != id) {
            id = id.trim();
        }
        if ((o = this.getServer()) == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            if (!o[i].getAttributeValue(Common.convertName((String)ServerTags.NAME)).equals(id)) continue;
            return o[i];
        }
        return null;
    }

    protected String getRelativeXPath() {
        String ret = null;
        ret = "servers";
        return null != ret ? ret.trim() : null;
    }

    public boolean verify() {
        return true;
    }

    public static void addComparator(BeanComparator c) {
        comparators.add(c);
    }

    public static void removeComparator(BeanComparator c) {
        comparators.remove(c);
    }

    public static String getDefaultAttributeValue(String attr) {
        if (attr == null) {
            return null;
        }
        attr = attr.trim();
        return null;
    }

    public void dump(StringBuffer str, String indent) {
        str.append(indent);
        str.append("Server[" + this.sizeServer() + "]");
        for (int i = 0; i < this.sizeServer(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            Server n = this.getServer(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(SERVER, i, str, indent);
        }
    }

    public String dumpBeanNode() {
        StringBuffer str = new StringBuffer();
        str.append("Servers\n");
        this.dump(str, "\n  ");
        return str.toString().trim();
    }
}

