/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.ReferenceHelperBase;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.util.i18n.StringManager;

public class ResourceHelper
extends ReferenceHelperBase {
    protected static final StringManager _strMgr = StringManager.getManager(ResourceHelper.class);
    private static ResourceHelper _theInstance;

    protected Server[] getReferencingServers(ConfigContext configContext, String name) throws ConfigException {
        return ServerHelper.getServersReferencingResource(configContext, name);
    }

    protected Cluster[] getReferencingClusters(ConfigContext configContext, String name) throws ConfigException {
        return ClusterHelper.getClustersReferencingResource(configContext, name);
    }

    private static synchronized ResourceHelper getInstance() {
        if (_theInstance == null) {
            _theInstance = new ResourceHelper();
        }
        return _theInstance;
    }

    public static boolean isResourceReferenced(ConfigContext configContext, String resourceName) throws ConfigException {
        return ResourceHelper.getInstance().isReferenced(configContext, resourceName);
    }

    public static boolean isResourceReferencedByServerOnly(ConfigContext configContext, String resourceName, String serverName) throws ConfigException {
        return ResourceHelper.getInstance().isReferencedByServerOnly(configContext, resourceName, serverName);
    }

    public static boolean isResourceReferencedByClusterOnly(ConfigContext configContext, String resourceName, String clusterName) throws ConfigException {
        return ResourceHelper.getInstance().isReferencedByClusterOnly(configContext, resourceName, clusterName);
    }

    public static String getResourceReferenceesAsString(ConfigContext configContext, String resourceName) throws ConfigException {
        return ResourceHelper.getInstance().getReferenceesAsString(configContext, resourceName);
    }

    public static boolean isJdbcPoolReferenced(ConfigContext ctx, String poolName, String serverName) throws ConfigException {
        if (ctx == null || poolName == null || serverName == null) {
            return false;
        }
        Resources rBean = ServerBeansFactory.getDomainBean(ctx).getResources();
        JdbcResource[] jdbcBeans = rBean.getJdbcResource();
        if (jdbcBeans == null) {
            return false;
        }
        for (int i = 0; i < jdbcBeans.length; ++i) {
            String pool;
            if (!ServerHelper.serverReferencesResource(ctx, serverName, jdbcBeans[i].getJndiName()) || (pool = jdbcBeans[i].getPoolName()) == null || !pool.equals(poolName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isConnectorPoolReferenced(ConfigContext ctx, String poolName, String serverName) throws ConfigException {
        if (ctx == null || poolName == null || serverName == null) {
            return false;
        }
        Resources rBean = ServerBeansFactory.getDomainBean(ctx).getResources();
        ConnectorResource[] conBeans = rBean.getConnectorResource();
        if (conBeans == null) {
            return false;
        }
        for (int i = 0; i < conBeans.length; ++i) {
            String pool;
            if (!ServerHelper.serverReferencesResource(ctx, serverName, conBeans[i].getJndiName()) || (pool = conBeans[i].getPoolName()) == null || !pool.equals(poolName)) continue;
            return true;
        }
        return false;
    }

    public static String getResourceType(ConfigContext ctx, String id) throws ConfigException {
        Resources root = ((Domain)ctx.getRootConfigBean()).getResources();
        ConfigBean res = root.getJdbcResourceByJndiName(id);
        if (res != null) {
            return "JdbcResource";
        }
        res = root.getMailResourceByJndiName(id);
        if (res != null) {
            return "MailResource";
        }
        res = root.getCustomResourceByJndiName(id);
        if (res != null) {
            return "CustomResource";
        }
        res = root.getExternalJndiResourceByJndiName(id);
        if (res != null) {
            return "ExternalJndiResource";
        }
        res = root.getPersistenceManagerFactoryResourceByJndiName(id);
        if (res != null) {
            return "PersistenceManagerFactoryResource";
        }
        res = root.getAdminObjectResourceByJndiName(id);
        if (res != null) {
            return "AdminObjectResource";
        }
        res = root.getConnectorResourceByJndiName(id);
        if (res != null) {
            return "ConnectorResource";
        }
        res = root.getJdbcConnectionPoolByName(id);
        if (res != null) {
            return "JdbcConnectionPool";
        }
        res = root.getConnectorConnectionPoolByName(id);
        if (res != null) {
            return "ConnectorConnectionPool";
        }
        res = root.getResourceAdapterConfigByResourceAdapterName(id);
        if (res != null) {
            return "ResourceAdapterConfig";
        }
        return null;
    }

    public static boolean isSystemResource(ConfigContext ctx, String resourceName) throws ConfigException {
        ConfigBean bean = ResourceHelper.findResource(ctx, resourceName);
        if (bean == null) {
            throw new ConfigException(_strMgr.getString("noSuchResource", resourceName));
        }
        String objectType = null;
        try {
            objectType = bean.getAttributeValue(ServerTags.OBJECT_TYPE);
        }
        catch (Exception ex) {
            return false;
        }
        return objectType.equals("system-all") || objectType.equals("system-admin") || objectType.equals("system-instance");
    }

    public static ConfigBean findResource(ConfigContext ctx, String id) throws ConfigException {
        Resources root = ((Domain)ctx.getRootConfigBean()).getResources();
        return ResourceHelper.findResource(root, id);
    }

    public static ConfigBean findResource(Resources root, String id) throws ConfigException {
        ConfigBean res = root.getJdbcResourceByJndiName(id);
        if (res != null) {
            return res;
        }
        res = root.getMailResourceByJndiName(id);
        if (res != null) {
            return res;
        }
        res = root.getCustomResourceByJndiName(id);
        if (res != null) {
            return res;
        }
        res = root.getExternalJndiResourceByJndiName(id);
        if (res != null) {
            return res;
        }
        res = root.getPersistenceManagerFactoryResourceByJndiName(id);
        if (res != null) {
            return res;
        }
        res = root.getAdminObjectResourceByJndiName(id);
        if (res != null) {
            return res;
        }
        res = root.getConnectorResourceByJndiName(id);
        if (res != null) {
            return res;
        }
        res = root.getJdbcConnectionPoolByName(id);
        if (res != null) {
            return res;
        }
        res = root.getConnectorConnectionPoolByName(id);
        if (res != null) {
            return res;
        }
        res = root.getResourceAdapterConfigByResourceAdapterName(id);
        if (res != null) {
            return res;
        }
        return null;
    }
}

