/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.StaleWriteConfigException;
import com.sun.enterprise.config.serverbeans.ClusterRef;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.Serializable;
import java.util.Vector;
import org.netbeans.modules.schema2beans.BeanComparator;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.GenBeans;

public class LbConfig
extends ConfigBean
implements Serializable {
    static Vector comparators = new Vector();
    public static final String CLUSTER_REF = "ClusterRef";
    public static final String SERVER_REF = "ServerRef";
    public static final String ELEMENT_PROPERTY = "ElementProperty";

    public LbConfig() {
        this(Common.USE_DEFAULT_VALUES);
    }

    public LbConfig(int options) {
        super(comparators, new GenBeans.Version(1, 0, 8));
        this.createProperty("cluster-ref", CLUSTER_REF, 66098, ClusterRef.class);
        this.createAttribute(CLUSTER_REF, "ref", "Ref", 257, null, null);
        this.createProperty("server-ref", SERVER_REF, 66098, ServerRef.class);
        this.createAttribute(SERVER_REF, "ref", "Ref", 257, null, null);
        this.createAttribute(SERVER_REF, "disable-timeout-in-minutes", "DisableTimeoutInMinutes", 1, null, "30");
        this.createAttribute(SERVER_REF, "lb-enabled", "LbEnabled", 1, null, "false");
        this.createAttribute(SERVER_REF, "enabled", "Enabled", 1, null, "true");
        this.createProperty("property", ELEMENT_PROPERTY, 66096, ElementProperty.class);
        this.createAttribute(ELEMENT_PROPERTY, "name", "Name", 257, null, null);
        this.createAttribute(ELEMENT_PROPERTY, "value", "Value", 257, null, null);
        this.initialize(options);
    }

    void initialize(int options) {
    }

    public void setClusterRef(int index, ClusterRef value) {
        this.setValue(CLUSTER_REF, index, value);
    }

    public ClusterRef getClusterRef(int index) {
        return (ClusterRef)this.getValue(CLUSTER_REF, index);
    }

    public void setClusterRef(ClusterRef[] value) {
        this.setValue(CLUSTER_REF, value);
    }

    public ClusterRef[] getClusterRef() {
        return (ClusterRef[])this.getValues(CLUSTER_REF);
    }

    public int sizeClusterRef() {
        return this.size(CLUSTER_REF);
    }

    public int addClusterRef(ClusterRef value) throws ConfigException {
        return this.addClusterRef(value, true);
    }

    public int addClusterRef(ClusterRef value, boolean overwrite) throws ConfigException {
        ClusterRef old = this.getClusterRefByRef(value.getRef());
        if (old != null) {
            throw new ConfigException(StringManager.getManager(LbConfig.class).getString("cannotAddDuplicate", CLUSTER_REF));
        }
        return this.addValue(CLUSTER_REF, value, overwrite);
    }

    public int removeClusterRef(ClusterRef value) {
        return this.removeValue(CLUSTER_REF, value);
    }

    public int removeClusterRef(ClusterRef value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(CLUSTER_REF, value, overwrite);
    }

    public ClusterRef getClusterRefByRef(String id) {
        ClusterRef[] o;
        if (null != id) {
            id = id.trim();
        }
        if ((o = this.getClusterRef()) == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            if (!o[i].getAttributeValue(Common.convertName((String)ServerTags.REF)).equals(id)) continue;
            return o[i];
        }
        return null;
    }

    public void setServerRef(int index, ServerRef value) {
        this.setValue(SERVER_REF, index, value);
    }

    public ServerRef getServerRef(int index) {
        return (ServerRef)this.getValue(SERVER_REF, index);
    }

    public void setServerRef(ServerRef[] value) {
        this.setValue(SERVER_REF, value);
    }

    public ServerRef[] getServerRef() {
        return (ServerRef[])this.getValues(SERVER_REF);
    }

    public int sizeServerRef() {
        return this.size(SERVER_REF);
    }

    public int addServerRef(ServerRef value) throws ConfigException {
        return this.addServerRef(value, true);
    }

    public int addServerRef(ServerRef value, boolean overwrite) throws ConfigException {
        ServerRef old = this.getServerRefByRef(value.getRef());
        if (old != null) {
            throw new ConfigException(StringManager.getManager(LbConfig.class).getString("cannotAddDuplicate", SERVER_REF));
        }
        return this.addValue(SERVER_REF, value, overwrite);
    }

    public int removeServerRef(ServerRef value) {
        return this.removeValue(SERVER_REF, value);
    }

    public int removeServerRef(ServerRef value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(SERVER_REF, value, overwrite);
    }

    public ServerRef getServerRefByRef(String id) {
        ServerRef[] o;
        if (null != id) {
            id = id.trim();
        }
        if ((o = this.getServerRef()) == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            if (!o[i].getAttributeValue(Common.convertName((String)ServerTags.REF)).equals(id)) continue;
            return o[i];
        }
        return null;
    }

    public void setElementProperty(int index, ElementProperty value) {
        this.setValue(ELEMENT_PROPERTY, index, value);
    }

    public ElementProperty getElementProperty(int index) {
        return (ElementProperty)this.getValue(ELEMENT_PROPERTY, index);
    }

    public void setElementProperty(ElementProperty[] value) {
        this.setValue(ELEMENT_PROPERTY, value);
    }

    public ElementProperty[] getElementProperty() {
        return (ElementProperty[])this.getValues(ELEMENT_PROPERTY);
    }

    public int sizeElementProperty() {
        return this.size(ELEMENT_PROPERTY);
    }

    public int addElementProperty(ElementProperty value) throws ConfigException {
        return this.addElementProperty(value, true);
    }

    public int addElementProperty(ElementProperty value, boolean overwrite) throws ConfigException {
        ElementProperty old = this.getElementPropertyByName(value.getName());
        if (old != null) {
            throw new ConfigException(StringManager.getManager(LbConfig.class).getString("cannotAddDuplicate", ELEMENT_PROPERTY));
        }
        return this.addValue(ELEMENT_PROPERTY, value, overwrite);
    }

    public int removeElementProperty(ElementProperty value) {
        return this.removeValue(ELEMENT_PROPERTY, value);
    }

    public int removeElementProperty(ElementProperty value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(ELEMENT_PROPERTY, value, overwrite);
    }

    public ElementProperty getElementPropertyByName(String id) {
        ElementProperty[] o;
        if (null != id) {
            id = id.trim();
        }
        if ((o = this.getElementProperty()) == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            if (!o[i].getAttributeValue(Common.convertName((String)ServerTags.NAME)).equals(id)) continue;
            return o[i];
        }
        return null;
    }

    public String getName() {
        return this.getAttributeValue(ServerTags.NAME);
    }

    public void setName(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.NAME, v, overwrite);
    }

    public void setName(String v) {
        this.setAttributeValue(ServerTags.NAME, v);
    }

    public String getResponseTimeoutInSeconds() {
        return this.getAttributeValue(ServerTags.RESPONSE_TIMEOUT_IN_SECONDS);
    }

    public void setResponseTimeoutInSeconds(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.RESPONSE_TIMEOUT_IN_SECONDS, v, overwrite);
    }

    public void setResponseTimeoutInSeconds(String v) {
        this.setAttributeValue(ServerTags.RESPONSE_TIMEOUT_IN_SECONDS, v);
    }

    public boolean isHttpsRouting() {
        return LbConfig.toBoolean(this.getAttributeValue(ServerTags.HTTPS_ROUTING));
    }

    public void setHttpsRouting(boolean v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.HTTPS_ROUTING, "" + v, overwrite);
    }

    public void setHttpsRouting(boolean v) {
        this.setAttributeValue(ServerTags.HTTPS_ROUTING, "" + v);
    }

    public String getReloadPollIntervalInSeconds() {
        return this.getAttributeValue(ServerTags.RELOAD_POLL_INTERVAL_IN_SECONDS);
    }

    public void setReloadPollIntervalInSeconds(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.RELOAD_POLL_INTERVAL_IN_SECONDS, v, overwrite);
    }

    public void setReloadPollIntervalInSeconds(String v) {
        this.setAttributeValue(ServerTags.RELOAD_POLL_INTERVAL_IN_SECONDS, v);
    }

    public boolean isMonitoringEnabled() {
        return LbConfig.toBoolean(this.getAttributeValue(ServerTags.MONITORING_ENABLED));
    }

    public void setMonitoringEnabled(boolean v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.MONITORING_ENABLED, "" + v, overwrite);
    }

    public void setMonitoringEnabled(boolean v) {
        this.setAttributeValue(ServerTags.MONITORING_ENABLED, "" + v);
    }

    public boolean isRouteCookieEnabled() {
        return LbConfig.toBoolean(this.getAttributeValue(ServerTags.ROUTE_COOKIE_ENABLED));
    }

    public void setRouteCookieEnabled(boolean v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.ROUTE_COOKIE_ENABLED, "" + v, overwrite);
    }

    public void setRouteCookieEnabled(boolean v) {
        this.setAttributeValue(ServerTags.ROUTE_COOKIE_ENABLED, "" + v);
    }

    protected String getRelativeXPath() {
        String ret = null;
        ret = "lb-config" + (this.canHaveSiblings() ? "[@name='" + this.getAttributeValue("name") + "']" : "");
        return null != ret ? ret.trim() : null;
    }

    public boolean verify() {
        return true;
    }

    public static void addComparator(BeanComparator c) {
        comparators.add(c);
    }

    public static void removeComparator(BeanComparator c) {
        comparators.remove(c);
    }

    public static String getDefaultAttributeValue(String attr) {
        if (attr == null) {
            return null;
        }
        if ((attr = attr.trim()).equals(ServerTags.RESPONSE_TIMEOUT_IN_SECONDS)) {
            return "60".trim();
        }
        if (attr.equals(ServerTags.HTTPS_ROUTING)) {
            return "false".trim();
        }
        if (attr.equals(ServerTags.RELOAD_POLL_INTERVAL_IN_SECONDS)) {
            return "60".trim();
        }
        if (attr.equals(ServerTags.MONITORING_ENABLED)) {
            return "false".trim();
        }
        if (attr.equals(ServerTags.ROUTE_COOKIE_ENABLED)) {
            return "true".trim();
        }
        return null;
    }

    public static String getDefaultResponseTimeoutInSeconds() {
        return "60".trim();
    }

    public static String getDefaultHttpsRouting() {
        return "false".trim();
    }

    public static String getDefaultReloadPollIntervalInSeconds() {
        return "60".trim();
    }

    public static String getDefaultMonitoringEnabled() {
        return "false".trim();
    }

    public static String getDefaultRouteCookieEnabled() {
        return "true".trim();
    }

    public void dump(StringBuffer str, String indent) {
        ConfigBean n;
        int i;
        str.append(indent);
        str.append("ClusterRef[" + this.sizeClusterRef() + "]");
        for (i = 0; i < this.sizeClusterRef(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            n = this.getClusterRef(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(CLUSTER_REF, i, str, indent);
        }
        str.append(indent);
        str.append("ServerRef[" + this.sizeServerRef() + "]");
        for (i = 0; i < this.sizeServerRef(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            n = this.getServerRef(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(SERVER_REF, i, str, indent);
        }
        str.append(indent);
        str.append("ElementProperty[" + this.sizeElementProperty() + "]");
        for (i = 0; i < this.sizeElementProperty(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            n = this.getElementProperty(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(ELEMENT_PROPERTY, i, str, indent);
        }
    }

    public String dumpBeanNode() {
        StringBuffer str = new StringBuffer();
        str.append("LbConfig\n");
        this.dump(str, "\n  ");
        return str.toString().trim();
    }
}

