/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.StaleWriteConfigException;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.Ssl;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.Serializable;
import java.util.Vector;
import org.netbeans.modules.schema2beans.BeanComparator;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.GenBeans;

public class IiopListener
extends ConfigBean
implements Serializable {
    static Vector comparators = new Vector();
    public static final String SSL = "Ssl";
    public static final String ELEMENT_PROPERTY = "ElementProperty";

    public IiopListener() {
        this(Common.USE_DEFAULT_VALUES);
    }

    public IiopListener(int options) {
        super(comparators, new GenBeans.Version(1, 0, 8));
        this.createProperty("ssl", SSL, 66064, Ssl.class);
        this.createAttribute(SSL, "cert-nickname", "CertNickname", 257, null, null);
        this.createAttribute(SSL, "ssl2-enabled", "Ssl2Enabled", 1, null, "false");
        this.createAttribute(SSL, "ssl2-ciphers", "Ssl2Ciphers", 513, null, null);
        this.createAttribute(SSL, "ssl3-enabled", "Ssl3Enabled", 1, null, "true");
        this.createAttribute(SSL, "ssl3-tls-ciphers", "Ssl3TlsCiphers", 513, null, null);
        this.createAttribute(SSL, "tls-enabled", "TlsEnabled", 1, null, "true");
        this.createAttribute(SSL, "tls-rollback-enabled", "TlsRollbackEnabled", 1, null, "true");
        this.createAttribute(SSL, "client-auth-enabled", "ClientAuthEnabled", 1, null, "false");
        this.createProperty("property", ELEMENT_PROPERTY, 66096, ElementProperty.class);
        this.createAttribute(ELEMENT_PROPERTY, "name", "Name", 257, null, null);
        this.createAttribute(ELEMENT_PROPERTY, "value", "Value", 257, null, null);
        this.initialize(options);
    }

    void initialize(int options) {
    }

    public void setSsl(Ssl value) {
        this.setValue(SSL, value);
    }

    public Ssl getSsl() {
        return (Ssl)this.getValue(SSL);
    }

    public void setElementProperty(int index, ElementProperty value) {
        this.setValue(ELEMENT_PROPERTY, index, value);
    }

    public ElementProperty getElementProperty(int index) {
        return (ElementProperty)this.getValue(ELEMENT_PROPERTY, index);
    }

    public void setElementProperty(ElementProperty[] value) {
        this.setValue(ELEMENT_PROPERTY, value);
    }

    public ElementProperty[] getElementProperty() {
        return (ElementProperty[])this.getValues(ELEMENT_PROPERTY);
    }

    public int sizeElementProperty() {
        return this.size(ELEMENT_PROPERTY);
    }

    public int addElementProperty(ElementProperty value) throws ConfigException {
        return this.addElementProperty(value, true);
    }

    public int addElementProperty(ElementProperty value, boolean overwrite) throws ConfigException {
        ElementProperty old = this.getElementPropertyByName(value.getName());
        if (old != null) {
            throw new ConfigException(StringManager.getManager(IiopListener.class).getString("cannotAddDuplicate", ELEMENT_PROPERTY));
        }
        return this.addValue(ELEMENT_PROPERTY, value, overwrite);
    }

    public int removeElementProperty(ElementProperty value) {
        return this.removeValue(ELEMENT_PROPERTY, value);
    }

    public int removeElementProperty(ElementProperty value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(ELEMENT_PROPERTY, value, overwrite);
    }

    public ElementProperty getElementPropertyByName(String id) {
        ElementProperty[] o;
        if (null != id) {
            id = id.trim();
        }
        if ((o = this.getElementProperty()) == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            if (!o[i].getAttributeValue(Common.convertName((String)ServerTags.NAME)).equals(id)) continue;
            return o[i];
        }
        return null;
    }

    public String getId() {
        return this.getAttributeValue(ServerTags.ID);
    }

    public void setId(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.ID, v, overwrite);
    }

    public void setId(String v) {
        this.setAttributeValue(ServerTags.ID, v);
    }

    public String getAddress() {
        return this.getAttributeValue(ServerTags.ADDRESS);
    }

    public void setAddress(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.ADDRESS, v, overwrite);
    }

    public void setAddress(String v) {
        this.setAttributeValue(ServerTags.ADDRESS, v);
    }

    public String getPort() {
        return this.getAttributeValue(ServerTags.PORT);
    }

    public void setPort(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.PORT, v, overwrite);
    }

    public void setPort(String v) {
        this.setAttributeValue(ServerTags.PORT, v);
    }

    public boolean isSecurityEnabled() {
        return IiopListener.toBoolean(this.getAttributeValue(ServerTags.SECURITY_ENABLED));
    }

    public void setSecurityEnabled(boolean v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.SECURITY_ENABLED, "" + v, overwrite);
    }

    public void setSecurityEnabled(boolean v) {
        this.setAttributeValue(ServerTags.SECURITY_ENABLED, "" + v);
    }

    public boolean isEnabled() {
        return IiopListener.toBoolean(this.getAttributeValue(ServerTags.ENABLED));
    }

    public void setEnabled(boolean v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.ENABLED, "" + v, overwrite);
    }

    public void setEnabled(boolean v) {
        this.setAttributeValue(ServerTags.ENABLED, "" + v);
    }

    protected String getRelativeXPath() {
        String ret = null;
        ret = "iiop-listener" + (this.canHaveSiblings() ? "[@id='" + this.getAttributeValue("id") + "']" : "");
        return null != ret ? ret.trim() : null;
    }

    public boolean verify() {
        return true;
    }

    public static void addComparator(BeanComparator c) {
        comparators.add(c);
    }

    public static void removeComparator(BeanComparator c) {
        comparators.remove(c);
    }

    public static String getDefaultAttributeValue(String attr) {
        if (attr == null) {
            return null;
        }
        if ((attr = attr.trim()).equals(ServerTags.PORT)) {
            return "1072".trim();
        }
        if (attr.equals(ServerTags.SECURITY_ENABLED)) {
            return "false".trim();
        }
        if (attr.equals(ServerTags.ENABLED)) {
            return "true".trim();
        }
        return null;
    }

    public static String getDefaultPort() {
        return "1072".trim();
    }

    public static String getDefaultSecurityEnabled() {
        return "false".trim();
    }

    public static String getDefaultEnabled() {
        return "true".trim();
    }

    public void dump(StringBuffer str, String indent) {
        str.append(indent);
        str.append(SSL);
        ConfigBean n = this.getSsl();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(SSL, 0, str, indent);
        str.append(indent);
        str.append("ElementProperty[" + this.sizeElementProperty() + "]");
        for (int i = 0; i < this.sizeElementProperty(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            n = this.getElementProperty(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(ELEMENT_PROPERTY, i, str, indent);
        }
    }

    public String dumpBeanNode() {
        StringBuffer str = new StringBuffer();
        str.append("IiopListener\n");
        this.dump(str, "\n  ");
        return str.toString().trim();
    }
}

