/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.pluggable;

import com.sun.enterprise.config.ConfigRuntimeException;
import com.sun.enterprise.config.impl.ConfigEnvironmentImpl;
import com.sun.enterprise.config.impl.DefaultConfigBeanInterceptor;
import com.sun.enterprise.config.pluggable.ConfigEnvironment;
import com.sun.enterprise.config.util.LocalStringsHelper;
import com.sun.enterprise.config.util.LoggerHelper;

public class EnvironmentFactory {
    static final String ENVIRONMENT_FACTORY_CLASS = "com.sun.enterprise.config.config_environment_factory_class";
    private static EnvironmentFactory _ENV = null;

    public static synchronized EnvironmentFactory getEnvironmentFactory() {
        if (_ENV == null) {
            _ENV = EnvironmentFactory.createEnvironmentFactory();
        }
        return _ENV;
    }

    private static EnvironmentFactory createEnvironmentFactory() {
        Class factoryClass;
        String factoryClassName = System.getProperty(ENVIRONMENT_FACTORY_CLASS);
        try {
            factoryClass = factoryClassName != null && !"".equals(factoryClassName) ? Class.forName(factoryClassName) : EnvironmentFactory.class;
        }
        catch (Exception e) {
            throw new ConfigRuntimeException("error_loading_environment_factory_class", LocalStringsHelper.getString("error_loading_environment_factory_class"), e);
        }
        LoggerHelper.fine("com.sun.enterprise.config.pluggable.EnvironmentFactory.getEnvironmentFactory():Factory Class is " + factoryClass);
        EnvironmentFactory result = null;
        try {
            result = (EnvironmentFactory)factoryClass.newInstance();
        }
        catch (Exception e) {
            throw new ConfigRuntimeException("error_creating_environment_factory", LocalStringsHelper.getString("error_creating_environment_factory"), e);
        }
        return result;
    }

    public ConfigEnvironment getConfigEnvironment() {
        ConfigEnvironmentImpl ce = new ConfigEnvironmentImpl();
        ce.setConfigBeanInterceptor(new DefaultConfigBeanInterceptor());
        return ce;
    }
}

