/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.verifier.tests;

import com.sun.enterprise.admin.verifier.Result;
import com.sun.enterprise.admin.verifier.ServerCheck;
import com.sun.enterprise.admin.verifier.ServerXmlTest;
import com.sun.enterprise.admin.verifier.tests.StaticTest;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.logging.Logger;

public class WebModuleTest
extends ServerXmlTest
implements ServerCheck {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");

    public Result check(ConfigContext context) {
        Result result = super.getInitializedResult();
        return result;
    }

    public Result check(ConfigContextEvent ccce) {
        Object value = ccce.getObject();
        Result result = new Result();
        String beanName = ccce.getBeanName();
        if (beanName != null) {
            String name = ccce.getName();
            return this.testSave(name, (String)value);
        }
        WebModule web = (WebModule)value;
        String id = web.getName();
        if (!StaticTest.checkObjectName(id, result)) {
            result.failed("Web Module Name Invalid ");
            return result;
        }
        result.passed("Valid Object Name");
        String location = web.getLocation();
        File f = new File(location);
        try {
            if (f.exists()) {
                result.passed("Test Passed ****");
            } else {
                result.failed("Web Module location directory is not valid");
            }
        }
        catch (SecurityException e) {
            result.failed("Security Manager Exists, not possible to access Web Module location");
        }
        return result;
    }

    public Result testSave(String name, String value) {
        Result result = new Result();
        result.passed("Passed **");
        if (name.equals(ServerTags.LOCATION)) {
            File f = new File(value);
            try {
                if (f.exists()) {
                    result.passed("Test Passed ****");
                } else {
                    result.failed("Web Module location directory is not valid");
                }
            }
            catch (SecurityException e) {
                result.failed("Security Manager Exists, not possible to access Web Module location");
            }
            return result;
        }
        return result;
    }
}

