/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.admin.util.Assert;
import com.sun.enterprise.admin.util.Debug;
import com.sun.enterprise.admin.util.IStringSource;

public class MessageFormatter
implements IStringSource {
    private IStringSource mSource = null;

    public MessageFormatter(IStringSource source) {
        this.setSource(source);
    }

    public void setSource(IStringSource source) {
        this.mSource = source;
    }

    public IStringSource getSource() {
        Assert.assertit(this.mSource != null, "mSource");
        return this.mSource;
    }

    public String getString(String lookupKey) {
        return this.mSource.getString(lookupKey);
    }

    public static String format(String base, Object[] toInsert) {
        if (toInsert == null || toInsert.length <= 0) {
            return null;
        }
        String ret = base;
        for (int i = 0; i < toInsert.length; ++i) {
            String replace;
            String token = MessageFormatter.makeToken(i + 1);
            if ((ret = MessageFormatter.replaceToken(ret, token, replace = toInsert[i].toString())) != null && ret.length() > 0) continue;
            return null;
        }
        return ret;
    }

    public static String format(String base, Object o1) {
        return MessageFormatter.format(base, new Object[]{o1});
    }

    public static String format(String base, Object o1, Object o2) {
        return MessageFormatter.format(base, new Object[]{o1, o2});
    }

    public static String format(String base, Object o1, Object o2, Object o3) {
        return MessageFormatter.format(base, new Object[]{o1, o2, o3});
    }

    public String getAndFormat(String key, Object o1) {
        return this.getAndFormat(key, new Object[]{o1});
    }

    public String getAndFormat(String key, Object o1, Object o2) {
        return this.getAndFormat(key, new Object[]{o1, o2});
    }

    public String getAndFormat(String key, Object o1, Object o2, Object o3) {
        return this.getAndFormat(key, new Object[]{o1, o2, o3});
    }

    public String getAndFormat(String key, Object[] toInsert) {
        return MessageFormatter.format(this.getString(key), toInsert);
    }

    private static String makeToken(int num) {
        return "{" + num + "}";
    }

    private static String replaceToken(String s, String token, String replace) {
        if (s == null || s.length() <= 0 || token == null || token.length() <= 0) {
            return s;
        }
        int index = s.indexOf(token);
        if (index < 0) {
            return s;
        }
        int tokenLength = token.length();
        String ret = s.substring(0, index);
        ret = ret + replace;
        ret = ret + s.substring(index + tokenLength);
        return ret;
    }

    public static void main(String[] notUsed) {
        String test2A = "hello {1}, How are {2}?";
        String test2AResult = MessageFormatter.format(test2A, "Carbon-based lifeform", "you");
        Debug.println("INPUT:  " + test2A + "\nOUTPUT:  " + test2AResult);
    }
}

