/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermodel.tester;

import com.sun.enterprise.admin.servermodel.AppServerInstance;
import com.sun.enterprise.admin.servermodel.ServerInstanceManager;
import com.sun.enterprise.admin.servermodel.beans.SecurityServiceComponentBean;
import com.sun.enterprise.admin.servermodel.beans.ServerComponent;
import com.sun.enterprise.admin.servermodel.tester.SOMTester;
import com.sun.enterprise.admin.servermodel.util.ServerModelIterator;
import java.util.HashMap;
import java.util.Iterator;

public class SecurityServiceTester
extends SOMTester {
    static final String USAGE_STRING = "Usage : SecurityServiceTester <instance-name>";

    public SecurityServiceTester() {
        super("security service tester");
    }

    public static String getUsageString() {
        return USAGE_STRING;
    }

    public int execute(String[] params) throws Exception {
        if (params.length != 1) {
            this.getWriter().println(SecurityServiceTester.getUsageString());
            return -1;
        }
        ServerInstanceManager sim = this.getServerInstanceManager("surya10.red.iplanet.com", 8888, "admin", "password");
        AppServerInstance si = sim.getServerInstance(params[0]);
        SecurityServiceComponentBean component = si.getSecurityService();
        this.printAttributes(component);
        this.authRealmTest(component);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        new SecurityServiceTester().execute(args);
    }

    private void printAttributes(ServerComponent component) throws Exception {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        Object value = component.getAttribute("defaultRealm");
        attributes.put("defaultRealm", value);
        value = component.getAttribute("defaultPrincipal");
        attributes.put("defaultPrincipal", value);
        value = component.getAttribute("defaultPrincipalPassword");
        attributes.put("defaultPrincipalPassword", value);
        value = component.getAttribute("anonymousRole");
        attributes.put("anonymousRole", value);
        value = component.getAttribute("auditEnabled");
        attributes.put("auditEnabled", value);
        value = component.getAttribute("logLevel");
        attributes.put("logLevel", value);
        this.getWriter().println(attributes);
    }

    private void authRealmTest(SecurityServiceComponentBean component) throws Exception {
        ServerModelIterator authRealms = component.getAuthRealms();
        this.printAuthRealms(authRealms);
        component.createAuthRealm("testRealm", "a.b.c");
        authRealms = component.getAuthRealms();
        this.printAuthRealms(authRealms);
        component.deleteAuthRealm("testRealm");
        authRealms = component.getAuthRealms();
        this.printAuthRealms(authRealms);
    }

    private void printAuthRealms(Iterator authRealms) throws Exception {
        while (authRealms.hasNext()) {
            this.getWriter().println("AuthRealm : " + authRealms.next());
        }
    }
}

