/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermodel.tester;

import com.sun.enterprise.admin.servermodel.beans.ServerComponent;
import com.sun.enterprise.admin.servermodel.tester.CreateACLTester;
import com.sun.enterprise.admin.servermodel.tester.CreateHttpConnectionGroupTester;
import com.sun.enterprise.admin.servermodel.tester.CreateHttpListenerTester;
import com.sun.enterprise.admin.servermodel.tester.CreateMimeTester;
import com.sun.enterprise.admin.servermodel.tester.CreateVirtualServerTester;
import com.sun.enterprise.admin.servermodel.tester.DeleteACLTester;
import com.sun.enterprise.admin.servermodel.tester.DeleteMimeTester;
import com.sun.enterprise.admin.servermodel.tester.ListACLsTester;
import com.sun.enterprise.admin.servermodel.tester.ListHttpConnectionGroupsTester;
import com.sun.enterprise.admin.servermodel.tester.ListHttpListenersTester;
import com.sun.enterprise.admin.servermodel.tester.ListMimesTester;
import com.sun.enterprise.admin.servermodel.tester.ListVirtualServersTester;
import com.sun.enterprise.admin.servermodel.tester.SOMTester;
import java.util.HashMap;

public class HttpServiceTester
extends SOMTester {
    static final String USAGE_STRING = "Usage : HttpServiceTester <instance-name>";

    public HttpServiceTester() {
        super("http service tester");
    }

    public static String getUsageString() {
        return USAGE_STRING;
    }

    public int execute(String[] params) throws Exception {
        if (params.length != 1) {
            this.getWriter().println(HttpServiceTester.getUsageString());
            return -1;
        }
        String instanceName = params[0];
        new CreateHttpListenerTester().execute(new String[]{instanceName, "listenerZ", "localhost:7777"});
        new ListHttpListenersTester().execute(new String[]{instanceName});
        new CreateHttpConnectionGroupTester().execute(new String[]{instanceName, "listenerX", "groupZ,localhost,vsX,serverX"});
        new ListHttpConnectionGroupsTester().execute(new String[]{instanceName, "listenerX"});
        new CreateMimeTester().execute(new String[]{instanceName, "mimeX", "mimeFileX"});
        new ListMimesTester().execute(new String[]{instanceName});
        new DeleteMimeTester().execute(new String[]{instanceName, "mimeX"});
        new ListMimesTester().execute(new String[]{instanceName});
        new CreateACLTester().execute(new String[]{instanceName, "aclX", "aclFileX"});
        new ListACLsTester().execute(new String[]{instanceName});
        new DeleteACLTester().execute(new String[]{instanceName, "aclX"});
        new ListACLsTester().execute(new String[]{instanceName});
        new CreateVirtualServerTester().execute(new String[]{instanceName, "defauleclass", "virtualServerX", "host1, host2", "mimeX"});
        new ListVirtualServersTester().execute(new String[]{instanceName, "defauleclass"});
        return 0;
    }

    public static void main(String[] args) throws Exception {
        new HttpServiceTester().execute(args);
    }

    private void testGetAttributes(ServerComponent component, String[] attributes) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>(attributes.length);
        for (int i = 0; i < attributes.length; ++i) {
            Object value = component.getAttribute(attributes[i]);
            map.put(attributes[i], value);
        }
        this.getWriter().println(map);
    }

    private void testSetAttributes(ServerComponent component, String[] attributes, Object[] values) throws Exception {
        for (int i = 0; i < attributes.length; ++i) {
            this.getWriter().println(attributes[i] + "OldValue= " + values[i]);
            component.setAttribute(attributes[i], values[i]);
            Object newValue = component.getAttribute(attributes[i]);
            this.getWriter().println("New Value= " + newValue);
        }
    }
}

