/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermodel.tester;

import com.sun.enterprise.admin.servermodel.AppServerInstance;
import com.sun.enterprise.admin.servermodel.ServerInstanceManager;
import com.sun.enterprise.admin.servermodel.beans.HttpServiceComponentBean;
import com.sun.enterprise.admin.servermodel.beans.ServerComponent;
import com.sun.enterprise.admin.servermodel.beans.VirtualServer;
import com.sun.enterprise.admin.servermodel.beans.VirtualServerClass;
import com.sun.enterprise.admin.servermodel.tester.SOMTester;
import java.util.HashMap;
import java.util.Map;

public class CreateVirtualServerHttpQosTester
extends SOMTester {
    static final String USAGE_STRING = "Usage : CreateVirtualServerHttpQosTester <instance-name> <virtual-server-class-id> <virtual-server-id> <bandwidthLimit> <enforceBandWidthLimit> <connectionLimit> <enforceConnectionLimit>";

    public CreateVirtualServerHttpQosTester() {
        super("Http QOS");
    }

    public static String getUsageString() {
        return USAGE_STRING;
    }

    public int execute(String[] params) throws Exception {
        if (params.length != 7) {
            this.getWriter().println(CreateVirtualServerHttpQosTester.getUsageString());
            return -1;
        }
        AppServerInstance instance = this.getServerInstance(params[0]);
        HttpServiceComponentBean httpService = instance.getHttpService();
        VirtualServerClass vsClass = httpService.getVirtualServerClass(params[1]);
        VirtualServer vs = vsClass.getVirtualServer(params[2]);
        if (!vs.isHttpQosCreated()) {
            vs.createHttpQos();
        } else {
            this.getWriter().println("HTTP QOS already exists for this component");
            vs.removeHttpQos();
            vs.createHttpQos();
        }
        this.setHttpQosAttributes(vs, Integer.valueOf(params[3]), Boolean.valueOf(params[4]), Integer.valueOf(params[5]), Boolean.valueOf(params[6]));
        Map attributes = this.getVirtualServerAttributes(vs);
        this.getWriter().println("Attributes = " + attributes);
        return 0;
    }

    private AppServerInstance getServerInstance(String name) throws Exception {
        ServerInstanceManager sim = this.getServerInstanceManager("surya10.red.iplanet.com", 8888, "admin", "password");
        AppServerInstance si = sim.getServerInstance(name);
        return si;
    }

    private void setHttpQosAttributes(ServerComponent virtualServer, Integer bandWidthLimit, Boolean enforceBandWidthLimit, Integer connectionLimit, Boolean enforceConnectionLimit) throws Exception {
        virtualServer.setAttribute("bandwidthLimit", bandWidthLimit);
        virtualServer.setAttribute("enforceBandwidthLimit", enforceBandWidthLimit);
        virtualServer.setAttribute("connectionLimit", connectionLimit);
        virtualServer.setAttribute("enforceConnectionLimit", enforceConnectionLimit);
    }

    private Map getVirtualServerAttributes(ServerComponent virtualServer) throws Exception {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        Object value = virtualServer.getAttribute("bandwidthLimit");
        attributes.put("bandwidthLimit", value);
        value = virtualServer.getAttribute("enforceBandwidthLimit");
        attributes.put("enforceBandwidthLimit", value);
        value = virtualServer.getAttribute("connectionLimit");
        attributes.put("connectionLimit", value);
        value = virtualServer.getAttribute("enforceConnectionLimit");
        attributes.put("enforceConnectionLimit", value);
        return attributes;
    }

    public static void main(String[] args) throws Exception {
        new CreateVirtualServerHttpQosTester().execute(args);
    }
}

