/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermodel.beans;

import com.sun.enterprise.admin.common.ObjectNames;
import com.sun.enterprise.admin.common.exception.AFException;
import com.sun.enterprise.admin.servermodel.beans.ServerComponent;
import com.sun.enterprise.admin.servermodel.beans.VirtualServer;
import com.sun.enterprise.admin.servermodel.controllers.Controller;
import com.sun.enterprise.admin.servermodel.controllers.VirtualServerClassController;
import com.sun.enterprise.admin.servermodel.util.ServerModelIterator;
import com.sun.enterprise.admin.util.ArgChecker;
import com.sun.enterprise.admin.util.Assert;
import com.sun.enterprise.admin.util.Debug;
import com.sun.enterprise.admin.util.ExceptionUtil;
import com.sun.enterprise.admin.util.StringValidator;
import java.io.Serializable;
import javax.management.ObjectName;

public class VirtualServerClass
extends ServerComponent
implements Serializable {
    private transient VirtualServerClassController controller = new VirtualServerClassController(this);

    public VirtualServerClass(String identifier, String displayName) {
        super(identifier, displayName);
    }

    public Controller getController() {
        return this.controller;
    }

    public void createVirtualServer(String id, String hosts, String mime) throws AFException {
        this.createVirtualServer(id, hosts, mime, null);
    }

    public void createVirtualServer(String id, String hosts, String mime, String defaultWebModule) throws AFException {
        this.controller.createVirtualServer(id, hosts, mime, defaultWebModule);
    }

    public void removeVirtualServer(String id) throws AFException {
        this.controller.removeVirtualServer(id);
    }

    public ServerModelIterator getVirtualServers() throws AFException {
        return this.controller.getVirtualServers();
    }

    public VirtualServer getVirtualServer(String virtualServerId) throws AFException {
        ArgChecker.checkValid(virtualServerId, "virtualServerId", StringValidator.getInstance());
        String instanceName = this.getInstanceName();
        String classId = this.getClassId();
        ObjectName mbeanName = ObjectNames.getVirtualServerObjectName(instanceName, classId, virtualServerId);
        Assert.assertit(mbeanName != null, "null value returned");
        Debug.println("VirtualServerClass.getVirtualServer: mbean = " + mbeanName);
        VirtualServer component = new VirtualServer(mbeanName.toString(), virtualServerId);
        component.setContextHolder(this.getContextHolder());
        return component;
    }

    public boolean isHttpQosCreated() throws AFException {
        return this.controller.isHttpQosCreated();
    }

    public void createHttpQos() throws AFException {
        this.controller.createHttpQos();
    }

    public void removeHttpQos() throws AFException {
        this.controller.removeHttpQos();
    }

    public String getInstanceName() {
        String instanceName = null;
        try {
            String identifier = this.getIdentifier();
            ObjectName mbeanName = new ObjectName(identifier);
            instanceName = mbeanName.getKeyProperty("instance-name");
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
            ExceptionUtil.ignoreException(e);
        }
        return instanceName;
    }

    public String getClassId() {
        String classId = null;
        try {
            String identifier = this.getIdentifier();
            ObjectName mbeanName = new ObjectName(identifier);
            classId = mbeanName.getKeyProperty("name");
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
            ExceptionUtil.ignoreException(e);
        }
        return classId;
    }
}

