/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.servlet;

import com.sun.enterprise.admin.servermodel.ServerInstanceManager;
import com.sun.enterprise.admin.servermodel.ServerInstanceManagerFactory;
import com.sun.enterprise.admin.util.Logger;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PingServlet
extends HttpServlet {
    private static StringManager localStrings = StringManager.getManager(PingServlet.class);

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        if (!this.isEnabled()) {
            String msg = localStrings.getString("admin.server.core.servlet.servlet_ping_not_allowed");
            throw new ServletException(msg);
        }
        out.println(this.servletPing());
        out.close();
    }

    private boolean isEnabled() {
        boolean isEnabled = true;
        try {
            ServerInstanceManager sim = ServerInstanceManagerFactory.getFactory().getServerInstanceManager();
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger.log("Cannot get the status of the ping servlet");
        }
        return isEnabled;
    }

    public String servletPing() throws ServletException {
        if (!this.isEnabled()) {
            String msg = localStrings.getString("admin.server.core.servlet.servlet_disabled");
            throw new ServletException(msg);
        }
        String pingResultStr = "Nothing";
        try {
            ServerInstanceManager sim = ServerInstanceManagerFactory.getFactory().getServerInstanceManager();
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger.log("Cannot ping the Admin server");
        }
        String title = "Ping Servlet";
        StringBuffer strBuf = new StringBuffer("<HTML><HEAD><TITLE>");
        strBuf.append(title);
        strBuf.append("</TITLE></HEAD><BODY>");
        strBuf.append("<H1>" + title + "</H1>");
        strBuf.append("<P>" + pingResultStr);
        strBuf.append("</BODY></HTML>");
        return strBuf.toString();
    }
}

