/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.mbean.config.naming;

import com.sun.enterprise.admin.AdminContext;
import com.sun.enterprise.admin.common.MalformedNameException;
import com.sun.enterprise.admin.common.exception.MBeanConfigException;
import com.sun.enterprise.admin.server.core.mbean.config.ConfigMBeanBase;
import com.sun.enterprise.admin.server.core.mbean.config.naming.ConfigMBeansNaming;
import com.sun.enterprise.admin.server.core.mbean.config.naming.MBeanNamingDescriptor;
import com.sun.enterprise.util.i18n.StringManager;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ConfigMBeanNamingInfo {
    private AdminContext m_AdminContext;
    String[] m_ids = null;
    MBeanNamingDescriptor m_descr = null;
    private static StringManager localStrings = StringManager.getManager(ConfigMBeanNamingInfo.class);

    public ConfigMBeanNamingInfo(String type, String[] params) throws MBeanConfigException {
        this(type, params, true);
    }

    public ConfigMBeanNamingInfo(String type, String[] params, boolean bTestParamSize) throws MBeanConfigException {
        this.m_descr = ConfigMBeansNaming.findNamingDescriptorByType(type);
        if (this.m_descr == null) {
            String msg = localStrings.getString("admin.server.core.mbean.config.naming.mbeannamingdescriptor_not_found_for_type", type);
            throw new MBeanConfigException(msg);
        }
        if (bTestParamSize) {
            int parmSize;
            int n = parmSize = params == null ? 0 : params.length;
            if (this.m_descr.getParmListSize() != parmSize) {
                String msg = localStrings.getString("admin.server.core.mbean.config.naming.wrong_parameters_array_size", type);
                throw new MBeanConfigException(msg);
            }
        }
        this.m_ids = params;
    }

    public ConfigMBeanNamingInfo(String dottedName) throws MBeanConfigException, MalformedNameException {
        this.m_descr = ConfigMBeansNaming.findNamingDescriptor(dottedName);
        if (this.m_descr == null) {
            String msg = localStrings.getString("admin.server.core.mbean.config.naming.mbeannamingdescriptor_not_found_for_dotted_name", dottedName);
            throw new MBeanConfigException(msg);
        }
        this.m_ids = this.m_descr.extractParmList(dottedName);
    }

    public ConfigMBeanNamingInfo(ObjectName objectName) throws MBeanConfigException {
        this.m_descr = ConfigMBeansNaming.findNamingDescriptor(objectName);
        if (this.m_descr == null) {
            String msg = localStrings.getString("admin.server.core.mbean.config.naming.mbeannamingdescriptor_not_found_for_object_name", objectName);
            throw new MBeanConfigException(msg);
        }
        this.m_ids = this.m_descr.extractParmList(objectName);
    }

    public void setAdminContext(AdminContext adminContext) {
        this.m_AdminContext = adminContext;
    }

    public ObjectName getObjectName() throws MalformedObjectNameException {
        return this.m_descr.createObjectName(this.m_ids);
    }

    public String[] getLocationParams() {
        return this.m_ids;
    }

    public String getXPath() {
        return this.m_descr.createXPath(this.m_ids);
    }

    public int getMode() {
        return this.m_descr.getMode();
    }

    public boolean isModeConfig() {
        int mode = this.m_descr.getMode();
        return (mode & 1) != 0;
    }

    public boolean isModeMonitorable() {
        int mode = this.m_descr.getMode();
        return (mode & 2) != 0;
    }

    public ConfigMBeanBase constructConfigMBean() throws MBeanConfigException {
        ConfigMBeanBase configMBean;
        String className = "com.sun.enterprise.admin.server.core.mbean.config." + this.m_descr.getMBeanClassName();
        try {
            Class<?> cl = Class.forName(className);
            configMBean = (ConfigMBeanBase)cl.newInstance();
        }
        catch (Exception e) {
            String msg = localStrings.getString("admin.server.core.mbean.config.naming.mbeannamingdescriptor_couldnot_create_mbean_class", className);
            throw new MBeanConfigException(msg);
        }
        configMBean.setAdminContext(this.m_AdminContext);
        configMBean.initialize(this);
        return configMBean;
    }

    public String getServerInstanceName() throws MBeanConfigException {
        if (this.m_ids == null || this.m_ids.length == 0) {
            String msg = localStrings.getString("admin.server.core.mbean.config.naming.wrong_parameters_array_size", this.m_descr.getType());
            throw new MBeanConfigException(msg);
        }
        return this.m_ids[0];
    }
}

