/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.mbean.config;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.admin.AdminContext;
import com.sun.enterprise.admin.common.ByteChunk;
import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.common.ObjectNameHelper;
import com.sun.enterprise.admin.common.ObjectNames;
import com.sun.enterprise.admin.common.ServerInstanceStatus;
import com.sun.enterprise.admin.common.domains.registry.DomainEntry;
import com.sun.enterprise.admin.common.domains.registry.DomainRegistry;
import com.sun.enterprise.admin.common.exception.ControlException;
import com.sun.enterprise.admin.common.exception.InstanceAlreadyExistsException;
import com.sun.enterprise.admin.common.exception.NoSuchInstanceException;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.admin.server.core.channel.AdminChannel;
import com.sun.enterprise.admin.server.core.channel.RMIClient;
import com.sun.enterprise.admin.server.core.mbean.config.AdminBase;
import com.sun.enterprise.admin.server.core.mbean.config.ShutdownThread;
import com.sun.enterprise.admin.server.core.mbean.meta.MBeanEasyConfig;
import com.sun.enterprise.admin.util.ArgChecker;
import com.sun.enterprise.admin.util.HostAndPort;
import com.sun.enterprise.admin.util.StringValidator;
import com.sun.enterprise.config.ConfigBeansFactory;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigFactory;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.config.serverbeans.JmsService;
import com.sun.enterprise.config.serverbeans.ServerXPathHelper;
import com.sun.enterprise.instance.InstanceDefinition;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.instance.ServerManager;
import com.sun.enterprise.jms.IASJmsUtil;
import com.sun.enterprise.util.RelativePathResolver;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.messaging.jmq.jmsspi.JMSAdmin;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class ServerController
extends AdminBase {
    private Hashtable mStreamTable = new Hashtable();
    private static final Logger sLogger;
    private static StringManager localStrings;
    private AdminContext mAdminContext;
    static String[] mAttrs;
    static String[] mOpers;
    private Lock lock;
    private DownloadInfo downloadInfo;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ServerController() {
    }

    public ServerController(AdminContext adminContext) {
        this();
        this.mAdminContext = adminContext;
    }

    public void createServerInstance(String instanceName, HostAndPort hostPort, String runAsUser, boolean autoStart) throws InstanceAlreadyExistsException, ControlException {
        if (this.isBadInstanceName(instanceName)) {
            String msg = localStrings.getString("admin.server.core.mbean.bad_instance_name", instanceName);
            throw new ControlException(msg);
        }
        ObjectName siObjectName = ObjectNames.getServerInstanceObjectName(instanceName);
        MBeanServer mbs = MBeanServerFactory.getMBeanServer();
        if (!mbs.isRegistered(siObjectName)) {
            try {
                InstanceDefinition instance = new InstanceDefinition(instanceName, hostPort.getPort());
                if (runAsUser != null) {
                    instance.setUser(runAsUser);
                }
                ServerManager.instance().createServerInstance(instance);
                sLogger.log(Level.INFO, "mbean.created_instance", instanceName);
            }
            catch (Exception e) {
                sLogger.log(Level.WARNING, "mbean.create_instance_failed", e);
                throw new ControlException(e.getMessage());
            }
        } else {
            String msg = localStrings.getString("admin.server.core.mbean.config.instance_already_exists", instanceName);
            throw new InstanceAlreadyExistsException(msg);
        }
    }

    public void createServerInstance(HostAndPort hAndp, String instanceName, String mailHost, String user, String docRoot, int jmsPort, String jmsUser, String jmsPasswd, boolean autoStart) throws InstanceAlreadyExistsException, ControlException {
        if (this.isBadInstanceName(instanceName)) {
            String msg = localStrings.getString("admin.server.core.mbean.bad_instance_name");
            throw new ControlException(msg);
        }
        ArgChecker.checkValid(hAndp, "hostport");
        ArgChecker.checkValid(instanceName, "instanceName", StringValidator.getInstance());
        ObjectName siObjectName = ObjectNames.getServerInstanceObjectName(instanceName);
        MBeanServer mbs = MBeanServerFactory.getMBeanServer();
        if (!mbs.isRegistered(siObjectName)) {
            try {
                InstanceDefinition instance = new InstanceDefinition(hAndp.getHost(), hAndp.getPort(), instanceName, mailHost, user, docRoot, jmsPort, jmsUser, jmsPasswd);
                ServerManager.instance().createServerInstance(instance);
                sLogger.log(Level.INFO, "mbean.created_instance", instanceName);
            }
            catch (Exception e) {
                sLogger.log(Level.WARNING, "mbean.create_instance_failed", e);
                throw new ControlException(e.getMessage());
            }
        } else {
            throw new InstanceAlreadyExistsException(instanceName);
        }
    }

    public void deleteServerInstance(String instanceName) throws NoSuchInstanceException, ControlException {
        if (instanceName == null) {
            String msg = localStrings.getString("admin.server.core.mbean.config.null_name");
            throw new IllegalArgumentException(msg);
        }
        ServerManager sm = ServerManager.instance();
        if (!sm.instanceExists(instanceName)) {
            String msg = localStrings.getString("admin.server.core.mbean.config.instance_does_not_exist", instanceName);
            throw new ControlException(msg);
        }
        boolean alive = false;
        RMIClient serverInstancePinger = AdminChannel.getRMIClient(instanceName);
        alive = serverInstancePinger.isAlive();
        if (alive) {
            String msg = localStrings.getString("admin.server.core.mbean.config.delete_alive_instance", instanceName);
            throw new ControlException(msg);
        }
        try {
            MBeanServer mbs = MBeanServerFactory.getMBeanServer();
            ObjectName[] objectNames = ObjectNameHelper.getInstanceRelatedMBeans(mbs, instanceName);
            for (int i = 0; i < objectNames.length; ++i) {
                try {
                    mbs.unregisterMBean(objectNames[i]);
                    continue;
                }
                catch (Exception e) {
                    sLogger.log(Level.CONFIG, "delete_unregistration_failed", objectNames[i]);
                }
            }
            InstanceEnvironment instanceEnvironment = new InstanceEnvironment(instanceName);
            String fileUrl = instanceEnvironment.getConfigFilePath();
            ConfigFactory.removeConfigContext(fileUrl);
            String instanceRoot = instanceEnvironment.getInstancesRoot();
            this.deleteJMSProviderInstance(instanceRoot, instanceName);
            sm.deleteServerInstance(instanceName);
            sLogger.log(Level.INFO, "mbean.del_instance_ok", instanceName);
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.del_instance_failed", e);
            throw new ControlException(e.getMessage());
        }
    }

    private void deleteJMSProviderInstance(String instancesRoot, String instanceName) {
        try {
            ConfigContext configContext;
            if (this.mAdminContext != null) {
                configContext = this.mAdminContext.getAdminConfigContext();
            } else {
                InstanceEnvironment instanceEnvironment = new InstanceEnvironment(instanceName);
                String fileUrl = instanceEnvironment.getConfigFilePath();
                configContext = ConfigFactory.createConfigContext(fileUrl);
            }
            JmsService jmsService = (JmsService)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_JMS_SERVICE);
            if (jmsService != null && jmsService.isEnabled()) {
                String mqInstanceDir;
                JMSAdmin jmsAdmin = null;
                String java_home = null;
                String domainName = null;
                String mqInstanceName = null;
                String mqBin = null;
                String[] argArray = new String[4];
                JavaConfig javaConfig = (JavaConfig)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_JAVACONFIG);
                java_home = javaConfig.getJavaHome();
                mqBin = System.getProperty("com.sun.aas.imqBin");
                domainName = ServerManager.instance().getDomainName();
                jmsAdmin = IASJmsUtil.getJMSAdminFactory().getJMSAdmin();
                mqInstanceName = IASJmsUtil.getBrokerInstanceName(domainName, instanceName, jmsService);
                argArray[0] = "-javahome";
                argArray[1] = java_home;
                argArray[2] = "-varhome";
                argArray[3] = mqInstanceDir = instancesRoot + File.separator + IASJmsUtil.MQ_DIR_NAME;
                jmsAdmin.deleteProviderInstance(mqBin, argArray, mqInstanceName);
            }
        }
        catch (Exception e) {
            sLogger.log(Level.FINE, "mbean.del_jms_instance_failed", e);
        }
    }

    public void shutdown() {
        sLogger.log(Level.INFO, "mbean.shutdown_started");
        String adminId = AdminService.getAdminService().getInstanceName();
        new Thread(new ShutdownThread(adminId)).start();
    }

    public void shutdownAndExit() {
    }

    public void restart() throws ControlException {
    }

    public String getVersion() throws ControlException {
        return Version.getVersion();
    }

    public String getFullVersion() throws ControlException {
        return Version.getFullVersion();
    }

    public String uploadToServer(ByteChunk byteChunk) throws ControlException {
        if (byteChunk == null) {
            throw new IllegalArgumentException();
        }
        String fileName = byteChunk.getChunkedFileName();
        String localPath = AdminService.getAdminService().getTempDirPath();
        String targetDirName = byteChunk.getTargetDir();
        if (targetDirName != null) {
            File targetDir = new File(localPath, targetDirName);
            if (!targetDir.exists()) {
                targetDir.mkdir();
            }
            localPath = FileUtils.safeGetCanonicalPath(targetDir);
        }
        File uploadFile = new File(localPath, fileName);
        localPath = FileUtils.safeGetCanonicalPath(uploadFile);
        if (byteChunk.isFirst()) {
            if (uploadFile.exists()) {
                sLogger.log(Level.INFO, "mbean.temp_upload_file_exists", localPath);
                boolean couldDelete = uploadFile.delete();
                if (couldDelete) {
                    sLogger.log(Level.FINE, "mbean.delete_temp_file_ok", localPath);
                } else {
                    sLogger.log(Level.INFO, "mbean.delete_temp_file_failed", localPath);
                }
            }
            OutputStream outStream = this.createOutputStream(localPath);
            this.mStreamTable.put(localPath, outStream);
            sLogger.log(Level.INFO, "mbean.begin_upload", localPath);
        }
        this.saveFile(localPath, byteChunk);
        return localPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveFile(String filePath, ByteChunk aChunk) throws ControlException {
        OutputStream sOut = null;
        try {
            try {
                sOut = (OutputStream)this.mStreamTable.get(filePath);
                byte[] bytes = aChunk.getBytes();
                sOut.write(bytes);
            }
            catch (Exception e) {
                throw new ControlException(e.getMessage());
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (!aChunk.isLast()) throw throwable;
                sOut.close();
                this.mStreamTable.remove(filePath);
                sLogger.log(Level.INFO, "mbean.upload_done", filePath);
                throw throwable;
            }
            catch (Exception fe) {
                throw new ControlException(fe.getMessage());
            }
        }
        try {}
        catch (Exception fe) {
            throw new ControlException(fe.getMessage());
        }
        if (!aChunk.isLast()) return;
        sOut.close();
        this.mStreamTable.remove(filePath);
        sLogger.log(Level.INFO, "mbean.upload_done", filePath);
    }

    private OutputStream createOutputStream(String filePath) throws ControlException {
        FileOutputStream fOut = null;
        try {
            fOut = new FileOutputStream(filePath);
        }
        catch (Exception e) {
            try {
                if (fOut != null) {
                    ((OutputStream)fOut).close();
                }
            }
            catch (Exception ce) {
                sLogger.log(Level.WARNING, "mbean.upload_failed", filePath);
            }
            throw new ControlException(e.getMessage());
        }
        return fOut;
    }

    public String[] listServerInstances() {
        ServerManager sm = ServerManager.instance();
        boolean countAdmin = false;
        String[] instanceNames = sm.getInstanceNames(countAdmin);
        return instanceNames;
    }

    public MBeanInfo getMBeanInfo() {
        try {
            return new MBeanEasyConfig(this.getClass(), mAttrs, mOpers, null).getMBeanInfo();
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.mbeaninfo_failed", e);
            return null;
        }
    }

    public Object prepareDownload(String filePath) throws ControlException {
        sLogger.log(Level.CONFIG, "mbean.prep_download", filePath);
        filePath = RelativePathResolver.resolvePath(filePath);
        File downloadFile = new File(filePath);
        if (!downloadFile.exists()) {
            String msg = localStrings.getString("admin.server.core.mbean.config.file_doesnot_exist", filePath);
            throw new ControlException(msg);
        }
        try {
            if (this.lock == null) {
                this.lock = new Lock();
            }
            this.lock.attempt(1000L);
        }
        catch (Exception ie) {
            String msg = localStrings.getString("admin.server.core.mbean.config.could_not_acquire_lock", ie.toString());
            throw new ControlException(msg);
        }
        if (this.downloadInfo == null) {
            this.downloadInfo = new DownloadInfo();
        }
        this.downloadInfo.downloadFile = downloadFile;
        long size = this.downloadInfo.downloadFile.length();
        this.downloadInfo.numChunks = Math.round(size / 0xA00000L);
        if ((long)(this.downloadInfo.numChunks * 0xA00000) < size) {
            this.downloadInfo.numChunks += 1;
        }
        this.downloadInfo.isPrepared = true;
        return null;
    }

    /*
     * Loose catch block
     */
    public ByteChunk downloadFile(int chunkIndex) throws ControlException {
        ByteChunk byteChunk;
        block21: {
            RandomAccessFile raf;
            block20: {
                sLogger.log(Level.FINE, "mbean.begin_download");
                if (this.downloadInfo == null) {
                    String msg = localStrings.getString("admin.server.core.mbean.config.call_preparedownload_first");
                    throw new ControlException(msg);
                }
                if (!this.downloadInfo.isPrepared) {
                    String msg = localStrings.getString("admin.server.core.mbean.config.call_preparedownload_first");
                    throw new ControlException(msg);
                }
                if (chunkIndex >= this.downloadInfo.numChunks || chunkIndex < 0) {
                    String msg = localStrings.getString("admin.server.core.mbean.config.invalid_chunk_index");
                    throw new ControlException(msg);
                }
                raf = null;
                byteChunk = null;
                raf = new RandomAccessFile(this.downloadInfo.downloadFile, "r");
                byte[] bytes = new byte[0xA00000];
                raf.seek(this.downloadInfo.numBytesRead);
                int actualBytesRead = raf.read(bytes, 0, 0xA00000);
                if (actualBytesRead < bytes.length) {
                    byte[] newBytes = new byte[actualBytesRead];
                    for (int i = 0; i < newBytes.length; ++i) {
                        newBytes[i] = bytes[i];
                    }
                    bytes = newBytes;
                }
                this.downloadInfo.numBytesRead += actualBytesRead;
                boolean isFirstChunk = chunkIndex == 0;
                boolean isLastChunk = chunkIndex == this.downloadInfo.numChunks - 1;
                sLogger.log(Level.FINEST, "chunkIndex = " + chunkIndex + " isFirstChunk = " + isFirstChunk + " isLastChunk = " + isLastChunk);
                byteChunk = new ByteChunk(bytes, this.downloadInfo.downloadFile.getAbsolutePath(), isFirstChunk, isLastChunk);
                Object var9_14 = null;
                if (raf == null) break block20;
                try {
                    raf.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            if (byteChunk != null && byteChunk.isLast()) {
                try {
                    this.downloadInfo.reset();
                    this.lock.release();
                }
                catch (Exception e) {
                    sLogger.log(Level.FINEST, "lock could not be released");
                }
            }
            break block21;
            {
                catch (Exception ioe) {
                    sLogger.log(Level.FINE, "mbean.download_failed", ioe);
                    this.downloadInfo.reset();
                    try {
                        this.lock.release();
                    }
                    catch (Exception e) {
                        sLogger.log(Level.FINEST, "lock could not be released");
                    }
                    throw new ControlException(ioe.toString());
                }
            }
            catch (Throwable throwable) {
                Object var9_15 = null;
                if (raf != null) {
                    try {
                        raf.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                if (byteChunk != null && byteChunk.isLast()) {
                    try {
                        this.downloadInfo.reset();
                        this.lock.release();
                    }
                    catch (Exception e) {
                        sLogger.log(Level.FINEST, "lock could not be released");
                    }
                }
                throw throwable;
            }
        }
        return byteChunk;
    }

    private boolean isBadInstanceName(String instanceName) {
        return false;
    }

    public void stopDomain(boolean stopAdmin) throws ControlException {
        String domainName = ServerManager.instance().getDomainName();
        if (stopAdmin) {
            sLogger.log(Level.INFO, "domain.stop_domain_admin", domainName);
        } else {
            sLogger.log(Level.INFO, "domain.stop_domain_noadmin", domainName);
        }
        this.stopAllInstances(false);
        if (stopAdmin) {
            this.shutdown();
        }
    }

    public DomainEntry[] listDomains() throws ControlException {
        DomainEntry[] domains = null;
        try {
            DomainRegistry domainRegistry = DomainRegistry.newInstance();
            int size = domainRegistry.size();
            domains = new DomainEntry[size];
            Iterator innerIter = domainRegistry.iterator();
            int i = 0;
            while (innerIter.hasNext()) {
                domains[i++] = (DomainEntry)innerIter.next();
            }
            if (!$assertionsDisabled && size != i) {
                throw new AssertionError();
            }
        }
        catch (Exception e) {
            throw new ControlException(e.getMessage());
        }
        return domains;
    }

    private void stopAllInstances(boolean atOnce) {
        String[] instanceIds = this.getRunningInstanceNames();
        if (!atOnce) {
            for (int i = 0; i < instanceIds.length; ++i) {
                sLogger.log(Level.INFO, "mbean.stop_instance", instanceIds[i]);
                this.stopInstance(instanceIds[i]);
            }
        } else {
            throw new UnsupportedOperationException("not impl yet");
        }
    }

    public String[] getRunningInstanceNames() {
        String[] allInstances = ServerManager.instance().getInstanceNames(false);
        Vector<String> runningInstances = new Vector<String>();
        String[] runners = null;
        int num = 0;
        for (int i = 0; i < allInstances.length; ++i) {
            if (this.isInstanceAlive(allInstances[i])) {
                runningInstances.add(allInstances[i]);
                ++num;
                sLogger.log(Level.FINE, "mbean.instance_up", allInstances[i]);
                continue;
            }
            sLogger.log(Level.FINE, "mbean.instance_down", allInstances[i]);
        }
        if (num > 0) {
            runners = new String[num];
            runners = runningInstances.toArray(runners);
        } else {
            runners = new String[]{};
        }
        return runners;
    }

    private void stopInstance(String instanceId) {
        ObjectName objName = ObjectNames.getServerInstanceObjectName(instanceId);
        String kStopMethodName = "stop";
        Object[] params = new Integer[]{new Integer(600)};
        String[] sign = new String[]{"int"};
        try {
            this.invokeMBean(objName, "stop", params, sign);
        }
        catch (Exception e) {
            sLogger.log(Level.CONFIG, "failure in invoking MBean", e);
        }
    }

    private boolean isInstanceAlive(String instanceId) {
        ObjectName objName = ObjectNames.getServerInstanceObjectName(instanceId);
        String kStatusMethodName = "getStatus";
        try {
            ServerInstanceStatus status = (ServerInstanceStatus)this.invokeMBean(objName, "getStatus", null, null);
            return status.isRunning();
        }
        catch (Exception e) {
            sLogger.log(Level.CONFIG, "failure in invoking MBean", e);
            return false;
        }
    }

    private Object invokeMBean(ObjectName objName, String operationName, Object[] params, String[] signature) throws Exception {
        MBeanServer mbs = MBeanServerFactory.getMBeanServer();
        return mbs.invoke(objName, operationName, params, signature);
    }

    public String getLicenseInfo() {
        String licenseInfo = localStrings.getString("admin.server.core.mbean.license_info");
        return licenseInfo;
    }

    protected Class getImplementingClass() {
        return this.getClass();
    }

    protected Object getImplementingMBean() {
        return this;
    }

    static {
        $assertionsDisabled = !ServerController.class.desiredAssertionStatus();
        sLogger = Logger.getLogger("javax.enterprise.system.tools.admin");
        localStrings = StringManager.getManager(ServerController.class);
        mAttrs = new String[0];
        mOpers = new String[]{"createServerInstance(String instanceName, com.sun.enterprise.admin.util.HostAndPort hostPort, String runAsUser, boolean autoStart), ACTION", "deleteServerInstance(String instanceName), ACTION", "shutdown(), ACTION", "shutdownAndExit(), ACTION", "restart(), ACTION", "getVersion(), ACTION_INFO", "getFullVersion(), ACTION_INFO", "uploadToServer(com.sun.enterprise.admin.common.ByteChunk byteChunk), ACTION_INFO", "listServerInstances(), INFO", "prepareDownload(String filePath), ACTION", "downloadFile(int chunkIndex), ACTION", "stopDomain(boolean stopAdmin), ACTION", "getRunningInstanceNames(), ACTION", "listDomains(), INFO"};
    }

    private static final class DownloadInfo {
        private File downloadFile;
        private int numChunks;
        private long numBytesRead;
        private boolean isPrepared;

        private DownloadInfo() {
            this.reset();
        }

        private synchronized void reset() {
            this.downloadFile = null;
            this.numChunks = 0;
            this.numBytesRead = 0L;
            this.isPrepared = false;
        }
    }

    private final class Lock {
        private boolean inUse = false;

        private Lock() {
        }

        private synchronized void acquire() throws InterruptedException, IllegalAccessException {
            while (this.inUse) {
                this.wait();
            }
            this.inUse = true;
        }

        private synchronized void release() throws IllegalAccessException {
            this.inUse = false;
            this.notify();
        }

        private synchronized void attempt(long milliseconds) throws InterruptedException, IllegalAccessException {
            if (this.inUse) {
                this.wait(milliseconds);
                if (this.inUse) {
                    String msg = localStrings.getString("admin.server.core.mbean.config.another_thread_holding_lock");
                    throw new IllegalAccessException(msg);
                }
            }
            this.inUse = true;
        }
    }
}

