/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.mbean.config;

import com.sun.enterprise.admin.common.constant.ConfigAttributeName;
import com.sun.enterprise.admin.common.exception.MBeanConfigException;
import com.sun.enterprise.admin.server.core.mbean.config.ConfigMBeanBase;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.ServerXPathHelper;
import com.sun.enterprise.util.i18n.StringManager;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanException;

public class ManagedSecurityService
extends ConfigMBeanBase
implements ConfigAttributeName.SecurityService {
    private static final String[][] MAPLIST = new String[][]{{"defaultRealm", "@" + ServerTags.DEFAULT_REALM}, {"defaultPrincipal", "@" + ServerTags.DEFAULT_PRINCIPAL}, {"defaultPrincipalPassword", "@" + ServerTags.DEFAULT_PRINCIPAL_PASSWORD}, {"anonymousRole", "@" + ServerTags.ANONYMOUS_ROLE}, {"auditEnabled", "@" + ServerTags.AUDIT_ENABLED}};
    private static final String[] ATTRIBUTES = new String[]{"defaultRealm, String,       RW", "defaultPrincipal, String,       RW", "defaultPrincipalPassword, String,       RW", "anonymousRole, String,       RW", "auditEnabled, boolean,      RW"};
    private static final String[] OPERATIONS = new String[]{"createAuthRealm(String name, String classname), ACTION", "deleteAuthRealm(String id), ACTION", "listAuthRealms(), INFO"};
    private static StringManager localStrings = StringManager.getManager(ManagedSecurityService.class);

    public ManagedSecurityService() throws MBeanConfigException {
        this.setDescriptions(MAPLIST, ATTRIBUTES, OPERATIONS);
    }

    public ManagedSecurityService(String instanceName) throws MBeanConfigException {
        this();
        this.initialize("securityservice", new String[]{instanceName});
    }

    public void createAuthRealm(String name, String classname) throws ConfigException {
        AuthRealm authRealm = new AuthRealm();
        if (name != null) {
            authRealm.setName(name);
        }
        if (classname != null) {
            authRealm.setClassname(classname);
        }
        SecurityService securityService = (SecurityService)this.getConfigBeanByXPath(ServerXPathHelper.getSecurityServiceXpath());
        securityService.addAuthRealm(authRealm);
        this.getConfigContext().flush();
    }

    public void deleteAuthRealm(String id) throws ConfigException, MBeanException, AttributeNotFoundException {
        SecurityService securityService = (SecurityService)this.getConfigBeanByXPath(ServerXPathHelper.getSecurityServiceXpath());
        AuthRealm authRealm = securityService.getAuthRealmByName(id);
        if (((String)this.getAttribute("defaultRealm")).equals(id)) {
            String msg = localStrings.getString("admin.server.core.mbean.config.default_realm_cannot_delete", id);
            throw new ConfigException(msg);
        }
        if (authRealm != null) {
            securityService.removeAuthRealm(authRealm);
        }
        this.getConfigContext().flush();
    }

    public String[] listAuthRealms() throws ConfigException {
        SecurityService securityService = (SecurityService)this.getConfigBeanByXPath(ServerXPathHelper.getSecurityServiceXpath());
        AuthRealm[] authRealms = securityService.getAuthRealm();
        String[] res = new String[authRealms.length];
        for (int i = 0; i < authRealms.length; ++i) {
            res[i] = authRealms[i].getName();
        }
        return res;
    }
}

