/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core;

import com.sun.appserv.server.ServerLifecycleException;
import com.sun.appserv.server.ServerLifecycleImpl;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.server.ServerContext;

public class AdminServiceLifeCycle
extends ServerLifecycleImpl {
    public static final byte STATUS_NOT_STARTED = 0;
    public static final byte STATUS_SHUTDOWN = 1;
    public static final byte STATUS_INITED = 2;
    public static final byte STATUS_STARTED = 4;
    public static final byte STATUS_READY = 8;
    public static final byte STATUS_TERMINATED = 0;
    private byte serverStatus = 0;

    public void onInitialization(ServerContext sc) throws ServerLifecycleException {
        if ((this.serverStatus & 2) == 2) {
            throw new IllegalStateException("Admin Server already initialized");
        }
        AdminService srv = AdminService.createAdminService(sc);
        srv.init();
        this.serverStatus = (byte)2;
    }

    public void onStartup(ServerContext sc) throws ServerLifecycleException {
        AdminService.getAdminService().start();
        this.serverStatus = (byte)(this.serverStatus | 4);
    }

    public void onReady(ServerContext sc) throws ServerLifecycleException {
        AdminService.getAdminService().ready();
        this.serverStatus = (byte)(this.serverStatus | 8);
    }

    public void onShutdown() throws ServerLifecycleException {
        this.serverStatus = (byte)(this.serverStatus | 1);
        AdminService.getAdminService().stop();
    }

    public void onTermination() throws ServerLifecycleException {
        AdminService.getAdminService().destroy();
        this.serverStatus = 0;
    }
}

