/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.meta.naming;

import com.sun.enterprise.admin.meta.naming.MBeanNamingException;
import com.sun.enterprise.admin.meta.naming.Name;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class MBeanNamingDescriptor {
    String m_type;
    String m_className;
    String m_objectPattern;
    String[] m_dottedPatterns;
    String m_xpathPattern;
    int m_mode;
    int m_parmListSize = 0;
    Object[][] m_dottedTokens = null;
    Object[] m_objectTokens = null;
    Object[] m_xpathTokens = null;

    public MBeanNamingDescriptor(Object[] description) throws MBeanNamingException {
        this((String)description[0], (Integer)description[1], (String)description[2], (String)description[3], (String)description[4], (String)description[5]);
    }

    public MBeanNamingDescriptor(String type, Integer mode, String dottedPatterns, String objectPattern, String xpathPattern, String className) throws MBeanNamingException {
        this.m_type = type;
        this.m_className = className;
        this.m_dottedPatterns = this.splitDottedPatternsString(dottedPatterns);
        this.m_xpathPattern = xpathPattern;
        this.m_objectPattern = objectPattern;
        this.m_mode = mode;
        try {
            if (this.m_dottedPatterns != null) {
                this.m_dottedTokens = new Object[this.m_dottedPatterns.length][];
                for (int i = 0; i < this.m_dottedPatterns.length; ++i) {
                    this.m_dottedTokens[i] = this.getDottedNamePatternTokens(this.m_dottedPatterns[i]);
                }
            }
            this.m_objectTokens = this.getObjectNamePatternTokens(this.m_objectPattern);
            this.m_xpathTokens = MBeanNamingDescriptor.getXPathTokens(this.m_xpathPattern);
            this.m_parmListSize = this.getMaxTokenIndex(this.m_objectTokens) + 1;
            this.checkConsistency();
        }
        catch (Exception e) {
            String msg = "admin.server.core.mbean.config.naming.mbeandescriptor_creation_failure_for_object_pattern" + objectPattern + e.getMessage();
            throw new MBeanNamingException(msg);
        }
    }

    private void checkConsistency() throws MBeanNamingException {
    }

    boolean isDottedPatternMatch(Name name) {
        return this.findDottedPatternTokens(name) != null;
    }

    private Object[] findDottedPatternTokens(Name name) {
        if (this.m_dottedTokens != null) {
            for (int i = 0; i < this.m_dottedTokens.length; ++i) {
                if (!MBeanNamingDescriptor.isDottedPatternMatch(name, this.m_dottedTokens[i], true)) continue;
                return this.m_dottedTokens[i];
            }
        }
        return null;
    }

    public boolean isObjectNamePatternMatch(ObjectName objectName) {
        Hashtable<String, String> ht = objectName.getKeyPropertyList();
        ht.put(":", objectName.getDomain());
        return this.isObjectNamePatternMatch(ht);
    }

    public boolean isObjectNamePatternMatch(Hashtable sample) {
        if (this.m_objectTokens.length != sample.size() * 2) {
            return false;
        }
        for (int i = 0; i < this.m_objectTokens.length; i += 2) {
            String sampleVal = (String)sample.get(this.m_objectTokens[i]);
            if (sampleVal != null && (!(this.m_objectTokens[i + 1] instanceof String) || sampleVal.equals((String)this.m_objectTokens[i + 1]))) continue;
            return false;
        }
        return true;
    }

    String[] extractParmList(String dottedName) throws MalformedObjectNameException {
        if (this.m_dottedTokens == null) {
            return null;
        }
        Name name = new Name(dottedName);
        Object[] tokens = this.findDottedPatternTokens(name);
        if (tokens == null) {
            return null;
        }
        int nTokens = name.getNumParts();
        if (name.getNumParts() != tokens.length) {
            return null;
        }
        String[] parmList = new String[this.m_parmListSize];
        for (int i = 0; i < nTokens; ++i) {
            if (!(tokens[i] instanceof Integer)) continue;
            parmList[((Integer)tokens[i]).intValue()] = name.getNamePart(i).toString();
        }
        return parmList;
    }

    private Object[] getDottedNamePatternTokens(String dottedPattern) throws MalformedObjectNameException {
        ArrayList<String> list = new ArrayList<String>();
        int idx = 0;
        int idx2 = 0;
        if (dottedPattern != null) {
            while (idx < dottedPattern.length() && (idx2 = dottedPattern.indexOf(46, idx)) >= 0) {
                if (idx == idx2) {
                    list.add("");
                } else {
                    list.add(dottedPattern.substring(idx, idx2).trim());
                }
                idx = idx2 + 1;
            }
            if (idx < dottedPattern.length()) {
                list.add(dottedPattern.substring(idx).trim());
            }
            Object[] tokens = list.toArray();
            MBeanNamingDescriptor.replacePlaceholdersToIntegers(tokens);
            return tokens;
        }
        return null;
    }

    public static Object[] getXPathTokens(String xpathPattern) {
        ArrayList<String> list = new ArrayList<String>();
        int idx = 0;
        int idx2 = 0;
        if (xpathPattern != null) {
            while (idx < xpathPattern.length() && (idx2 = xpathPattern.indexOf("'", idx)) >= 0) {
                if (idx != idx2) {
                    list.add(xpathPattern.substring(idx, idx2));
                }
                idx = idx2 + 1;
            }
            if (idx < xpathPattern.length()) {
                list.add(xpathPattern.substring(idx).trim());
            }
            Object[] tokens = list.toArray();
            MBeanNamingDescriptor.replacePlaceholdersToIntegers(tokens);
            return tokens;
        }
        return null;
    }

    private Object[] getObjectNamePatternTokens(String objectPattern) throws MalformedObjectNameException {
        if (objectPattern != null) {
            ObjectName objName = new ObjectName(objectPattern);
            Hashtable<String, String> ht = objName.getKeyPropertyList();
            ht.put(":", objName.getDomain());
            Enumeration<String> enumeration = ht.keys();
            Object[] tokens = new Object[ht.size() * 2];
            int i = 0;
            while (enumeration.hasMoreElements()) {
                String key = enumeration.nextElement();
                tokens[i++] = key;
                tokens[i++] = ht.get(key);
            }
            MBeanNamingDescriptor.replacePlaceholdersToIntegers(tokens);
            return tokens;
        }
        return null;
    }

    public int getParmListSize() {
        return this.m_parmListSize;
    }

    public String[] extractParmList(ObjectName objectName) {
        if (this.m_objectTokens == null) {
            return null;
        }
        Hashtable<String, String> ht = objectName.getKeyPropertyList();
        ht.put(":", objectName.getDomain());
        String[] parmList = new String[this.m_parmListSize];
        for (int i = 0; i < this.m_objectTokens.length; i += 2) {
            if (!(this.m_objectTokens[i + 1] instanceof Integer)) continue;
            parmList[((Integer)this.m_objectTokens[i + 1]).intValue()] = ht.get(this.m_objectTokens[i]);
        }
        return parmList;
    }

    private static void replacePlaceholdersToIntegers(Object[] tokens) {
        for (int i = 0; i < tokens.length; ++i) {
            Integer idx = MBeanNamingDescriptor.getIndexForPlaceholder((String)tokens[i]);
            if (idx == null) continue;
            tokens[i] = idx;
        }
    }

    private static Integer getIndexForPlaceholder(String str) {
        int len = str.length();
        if (len < 3 || str.charAt(0) != '{' || str.charAt(len - 1) != '}') {
            return null;
        }
        try {
            return Integer.valueOf(str.substring(1, len - 1));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private int getMaxTokenIndex(Object[] tokens) {
        int res = -1;
        for (int i = 0; i < tokens.length; ++i) {
            int current;
            if (!(tokens[i] instanceof Integer) || res >= (current = ((Integer)tokens[i]).intValue())) continue;
            res = current;
        }
        return res;
    }

    public String getMBeanClassName() {
        return this.m_className;
    }

    public String getType() {
        return this.m_type;
    }

    public int getMode() {
        return this.m_mode;
    }

    public String[] getDottedPatterns() {
        return this.m_dottedPatterns;
    }

    public Object[][] getDottedTokens() {
        return this.m_dottedTokens;
    }

    public String getXPathPattern() {
        return this.m_xpathPattern;
    }

    public ObjectName createObjectName(Object[] params) throws MalformedObjectNameException {
        return new ObjectName(this.formatPattern(this.m_objectPattern, params));
    }

    public String[] createDottedNames(Object[] params) {
        if (this.m_dottedPatterns == null || this.m_dottedPatterns.length < 1) {
            return null;
        }
        String[] names = new String[this.m_dottedPatterns.length];
        for (int i = 0; i < this.m_dottedPatterns.length; ++i) {
            names[i] = this.formatPattern(this.m_dottedPatterns[i], params);
        }
        return names;
    }

    public String createXPath(Object[] params) {
        return this.formatPattern(this.m_xpathPattern, params);
    }

    private String formatPattern(String pattern, Object[] params) {
        if (pattern == null) {
            return null;
        }
        return MessageFormat.format(pattern, params);
    }

    private String[] splitDottedPatternsString(String names) {
        if (names == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        int idx = 0;
        int idx2 = 0;
        while (idx < names.length() && (idx2 = names.indexOf(124, idx)) >= 0) {
            if (idx2 != idx) {
                list.add(names.substring(idx, idx2));
            }
            idx = idx2 + 1;
        }
        if (idx2 < 0) {
            list.add(names.substring(idx));
        }
        return list.toArray(new String[list.size()]);
    }

    public boolean isXpathTokensMatch(Object[] tokens) {
        if (this.m_xpathTokens == null || tokens == null) {
            return false;
        }
        if (this.m_xpathTokens.length != tokens.length) {
            return false;
        }
        for (int i = 0; i < tokens.length; ++i) {
            if (!(this.m_xpathTokens[i] instanceof String) || this.m_xpathTokens[i].equals(tokens[i])) continue;
            return false;
        }
        return true;
    }

    public String[] extractParmListFromXPath(String xpath) {
        Object[] tokens = MBeanNamingDescriptor.getXPathTokens(xpath);
        if (this.m_xpathTokens == null || tokens == null || this.m_parmListSize <= 0) {
            return null;
        }
        if (this.m_xpathTokens.length != tokens.length) {
            return null;
        }
        String[] parmList = new String[this.m_parmListSize];
        for (int i = 0; i < tokens.length; ++i) {
            if (!(this.m_xpathTokens[i] instanceof Integer)) continue;
            parmList[((Integer)this.m_xpathTokens[i]).intValue()] = (String)tokens[i];
        }
        return parmList;
    }

    public static boolean isDottedPatternMatch(Name name, Object[] tokens, boolean bExactMatch) {
        if (tokens == null) {
            return false;
        }
        int nTokens = name.getNumParts();
        if (bExactMatch ? nTokens != tokens.length : nTokens > tokens.length) {
            return false;
        }
        for (int i = 0; i < nTokens; ++i) {
            if (!(tokens[i] instanceof String) || name.getNamePart(i).toString().equals((String)tokens[i])) continue;
            return false;
        }
        return true;
    }

    public static String XPATH_TO_MASK(String xpath) {
        if (xpath == null || xpath.length() == 0) {
            return xpath;
        }
        char[] chrs = xpath.toCharArray();
        char[] newchrs = new char[chrs.length * 2];
        int j = 0;
        for (int i = 0; i < chrs.length; ++i) {
            newchrs[j++] = chrs[i];
            if (chrs[i] != '\'') continue;
            newchrs[j++] = 39;
        }
        return String.valueOf(newchrs, 0, j);
    }
}

