/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans;

import com.sun.enterprise.admin.AdminContext;
import com.sun.enterprise.admin.MBeanHelper;
import com.sun.enterprise.admin.config.BaseConfigMBean;
import com.sun.enterprise.admin.config.MBeanConfigException;
import com.sun.enterprise.admin.event.EventContext;
import com.sun.enterprise.admin.event.UserMgmtEvent;
import com.sun.enterprise.admin.mbeanapi.IAuthRealmMBean;
import com.sun.enterprise.admin.meta.MBeanRegistryFactory;
import com.sun.enterprise.config.serverbeans.PropertyResolver;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import com.sun.enterprise.security.auth.realm.file.FileRealm;
import com.sun.enterprise.security.util.IASSecurityException;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.management.modelmbean.ModelMBeanInfo;

public class AuthRealmMBean
extends BaseConfigMBean
implements IAuthRealmMBean {
    static final String FILE_NAME_PROPERTY = "file";
    private static final StringManager localStrings = StringManager.getManager(AuthRealmMBean.class);

    public String[] getUserNames() throws MBeanConfigException {
        this.checkFileTypeRealm();
        FileRealm realm = this.getRealmKeyFile();
        try {
            return this.convertEnumerationToStringArray(realm.getUserNames());
        }
        catch (BadRealmException bre) {
            throw new MBeanConfigException(bre.getMessage());
        }
    }

    public String[] getGroupNames() throws MBeanConfigException {
        this.checkFileTypeRealm();
        FileRealm realm = this.getRealmKeyFile();
        try {
            return this.convertEnumerationToStringArray(realm.getGroupNames());
        }
        catch (BadRealmException bre) {
            throw new MBeanConfigException(bre.getMessage());
        }
    }

    public String[] getUserGroupNames(String userName) throws MBeanConfigException {
        if (userName == null) {
            return this.getGroupNames();
        }
        this.checkFileTypeRealm();
        FileRealm realm = this.getRealmKeyFile();
        try {
            return this.convertEnumerationToStringArray(realm.getGroupNames(userName));
        }
        catch (NoSuchUserException nse) {
            throw new MBeanConfigException(nse.getMessage());
        }
    }

    public void addUser(String userName, String password, String[] groupList) throws MBeanConfigException {
        this.checkFileTypeRealm();
        FileRealm realm = this.getRealmKeyFile();
        try {
            realm.addUser(userName, password, groupList);
            this.saveInstanceRealmKeyFile(realm);
        }
        catch (BadRealmException bre) {
            throw new MBeanConfigException(bre.getMessage());
        }
        catch (IASSecurityException ise) {
            throw new MBeanConfigException(ise.getMessage());
        }
        this.EmitUserMgmtEvent(1, userName, groupList);
    }

    public void removeUser(String userName) throws MBeanConfigException {
        this.checkFileTypeRealm();
        FileRealm realm = this.getRealmKeyFile();
        try {
            realm.removeUser(userName);
            this.saveInstanceRealmKeyFile(realm);
        }
        catch (NoSuchUserException nse) {
            throw new MBeanConfigException(nse.getMessage());
        }
        this.EmitUserMgmtEvent(3, userName, null);
    }

    public void updateUser(String userName, String password, String[] groupList) throws MBeanConfigException {
        this.checkFileTypeRealm();
        FileRealm realm = this.getRealmKeyFile();
        try {
            realm.updateUser(userName, userName, password, groupList);
            this.saveInstanceRealmKeyFile(realm);
        }
        catch (BadRealmException bre) {
            throw new MBeanConfigException(bre.getMessage());
        }
        catch (NoSuchUserException nse) {
            throw new MBeanConfigException(nse.getMessage());
        }
        catch (IASSecurityException ise) {
            throw new MBeanConfigException(ise.getMessage());
        }
        this.EmitUserMgmtEvent(2, userName, groupList);
    }

    private String getRealmKeyFileName() {
        return this.getProperty(FILE_NAME_PROPERTY);
    }

    private FileRealm getRealmKeyFile() throws MBeanConfigException {
        try {
            return new FileRealm(this.getRealmKeyFileName());
        }
        catch (Exception e) {
            throw new MBeanConfigException(e.getMessage());
        }
    }

    private void saveInstanceRealmKeyFile(FileRealm realm) throws MBeanConfigException {
        try {
            String filePath = this.getRealmKeyFileName();
            _sLogger.log(Level.INFO, "filerealm.write", filePath);
            realm.writeKeyFile(filePath);
        }
        catch (IOException ioe) {
            _sLogger.log(Level.WARNING, "filerealm.writeerror", ioe);
            throw new MBeanConfigException(ioe.getMessage());
        }
    }

    private String[] convertEnumerationToStringArray(Enumeration enumeration) {
        ArrayList list = new ArrayList();
        while (enumeration.hasMoreElements()) {
            list.add(enumeration.nextElement());
        }
        return list.toArray(new String[list.size()]);
    }

    private void checkFileTypeRealm() throws MBeanConfigException {
        String className = null;
        try {
            className = (String)this.getAttribute(ServerTags.CLASSNAME);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (className == null || !className.equals("com.sun.enterprise.security.auth.realm.file.FileRealm")) {
            String msg = localStrings.getString("authRealmMBean.unsupported_type");
            throw new MBeanConfigException(msg);
        }
    }

    private String getProperty(String name) {
        try {
            String unresolved = (String)this.invoke("getPropertyValue", new Object[]{name}, new String[]{"java.lang.String"});
            String instanceName = MBeanRegistryFactory.getAdminContext().getServerName();
            String resolved = new PropertyResolver(this.getConfigContext(), instanceName).resolve(unresolved);
            return resolved;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void EmitUserMgmtEvent(int action, String user, String[] groups) throws MBeanConfigException {
        try {
            AdminContext adminContext = MBeanRegistryFactory.getAdminContext();
            String instanceName = adminContext.getServerName();
            String name = (String)this.getAttribute(ServerTags.NAME);
            UserMgmtEvent event = new UserMgmtEvent(instanceName, name, action, user, groups);
            String[] location = MBeanHelper.getLocation((ModelMBeanInfo)((Object)this.getMBeanInfo()));
            event.setTargetDestination(location[1]);
            EventContext.addEvent(event);
        }
        catch (Exception e) {
            throw new MBeanConfigException(e.getMessage());
        }
    }
}

