/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.config;

import com.sun.enterprise.admin.BaseAdminMBean;
import com.sun.enterprise.admin.MBeanHelper;
import com.sun.enterprise.admin.config.ConfigMBeanHelper;
import com.sun.enterprise.admin.config.ManagedConfigBean;
import com.sun.enterprise.admin.meta.MBeanMetaHelper;
import com.sun.enterprise.admin.meta.MBeanRegistry;
import com.sun.enterprise.admin.meta.MBeanRegistryFactory;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import java.util.logging.Level;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.ServiceNotFoundException;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;

public class BaseConfigMBean
extends BaseAdminMBean
implements MBeanRegistration {
    public static final boolean OVERWRITE = true;
    private ManagedConfigBean mcb = null;
    protected MBeanRegistry m_registry = MBeanRegistryFactory.getAdminMBeanRegistry();

    public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        ModelMBeanAttributeInfo attrInfo = (ModelMBeanAttributeInfo)MBeanHelper.findMatchingAttributeInfo((MBeanInfo)((Object)this.info), name = MBeanMetaHelper.mapToMBeanAttributeName(name));
        if (attrInfo == null) {
            throw new AttributeNotFoundException(name);
        }
        Object o = null;
        try {
            o = super.getAttribute(name);
        }
        catch (Exception e) {
            o = this.mcb.getAttribute(attrInfo, name);
        }
        return o;
    }

    public AttributeList getAttributes(String[] attributeNames) {
        return this.mcb.getAttributes(attributeNames);
    }

    public void setManagedResource(Object resource, String type) throws InstanceNotFoundException, MBeanException, RuntimeOperationsException {
        if (resource == null) {
            String msg = this._localStrings.getString("admin.server.core.mbean.config.base.managed_resource_is_null", this.mbeanType);
            throw new RuntimeOperationsException(new IllegalArgumentException(msg), msg);
        }
        if ("ConfigBeanReference".equalsIgnoreCase(type)) {
            if (!(resource instanceof ConfigBean)) {
                String msg = this._localStrings.getString("admin.server.core.mbean.config.base.managed_resource_is_not_configbean", this.mbeanType);
                throw new RuntimeOperationsException(new ClassCastException(msg), msg);
            }
            this.mcb = new ManagedConfigBean(this, (ConfigBean)resource, this.m_registry);
        }
    }

    public Object invoke(String name, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        ModelMBeanOperationInfo opInfo = (ModelMBeanOperationInfo)MBeanHelper.findMatchingOperationInfo((MBeanInfo)((Object)this.info), name, signature);
        if (opInfo == null) {
            String msg = this._localStrings.getString("admin.server.core.mbean.config.base.operation_is_not_found", this.mbeanType, name);
            throw new MBeanException(new ServiceNotFoundException(msg), msg);
        }
        Descriptor descr = opInfo.getDescriptor();
        try {
            Object ret = MBeanHelper.invokeOperationInBean(opInfo, this, params);
            if (ret != MBeanHelper.INVOKE_ERROR_SIGNAL_OBJECT) {
                return ret;
            }
            if (this.mcb != null && (ret = this.mcb.invokeOperation(opInfo, params, signature)) != MBeanHelper.INVOKE_ERROR_SIGNAL_OBJECT) {
                return ret;
            }
            return super.invoke(name, params, signature);
        }
        catch (MBeanException mbe) {
            _sLogger.log(Level.FINE, "mbean.baseconfig.invoke_exception", mbe);
            throw mbe;
        }
        catch (Exception e) {
            _sLogger.log(Level.FINE, "mbean.baseconfig.invoke_exception", e);
            String msg = this._localStrings.getString("admin.server.core.mbean.config.base.invoke_error", this.mbeanType, name);
            throw MBeanHelper.extractAndWrapTargetException(e, msg);
        }
    }

    protected ObjectName createChildElementByType(String childElementName, Attribute[] attrs) throws Exception {
        return this.createChildElementByType(childElementName, attrs, true, false);
    }

    protected ObjectName createChildElementByType(String childElementName, Attribute[] attrs, boolean bSkipNullValued) throws Exception {
        return this.createChildElementByType(childElementName, attrs, bSkipNullValued, false);
    }

    protected ObjectName createChildElementByType(String childElementName, Attribute[] attrs, boolean bSkipNullValued, boolean bOnlyOne) throws Exception {
        AttributeList list = new AttributeList();
        for (int i = 0; i < attrs.length; ++i) {
            if (bSkipNullValued && attrs[i].getValue() == null) continue;
            list.add(attrs[i]);
        }
        ConfigBean bean = this.mcb.createChildByType(childElementName, list, bOnlyOne);
        return ConfigMBeanHelper.getChildObjectName(this.m_registry, this.info, bean);
    }

    public AttributeList setAttributes(AttributeList list) {
        try {
            return super.setAttributes(list);
        }
        catch (Exception e) {
            if (this.mcb != null) {
                return this.mcb.setAttributes(list);
            }
            return null;
        }
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        block3: {
            ModelMBeanAttributeInfo attrInfo = (ModelMBeanAttributeInfo)MBeanHelper.findMatchingAttributeInfo((MBeanInfo)((Object)this.info), (attribute = new Attribute(MBeanMetaHelper.mapToMBeanAttributeName(attribute.getName()), attribute.getValue())).getName());
            if (attrInfo == null) {
                throw new AttributeNotFoundException();
            }
            try {
                super.setAttribute(attribute);
            }
            catch (Exception e) {
                if (this.mcb == null) break block3;
                this.mcb.setAttribute(attrInfo, attribute);
            }
        }
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    public boolean destroyConfigElement() throws Exception {
        if (this.mcb == null) {
            return false;
        }
        this.mcb.deleteSelf();
        ObjectName objectName = ConfigMBeanHelper.getOwnObjectName(this.m_registry, this.info);
        if (objectName != null) {
            try {
                MBeanServer server = MBeanServerFactory.findMBeanServer(null).get(0);
                server.unregisterMBean(objectName);
            }
            catch (Throwable t) {
                _sLogger.fine("!!!!!!!!!!!!!! Can not unregister MBean: " + objectName);
            }
            return true;
        }
        return false;
    }

    protected ConfigContext getConfigContext() {
        if (this.mcb != null) {
            return this.mcb.getConfigContext();
        }
        return null;
    }

    protected String getDomainName() throws MBeanException {
        String[] location;
        ModelMBeanInfo info = (ModelMBeanInfo)((Object)this.getMBeanInfo());
        if (info != null && (location = MBeanHelper.getLocation(info)) != null && location.length > 0) {
            return location[0];
        }
        return null;
    }

    protected MBeanServer getMBeanServer() throws MBeanException {
        return MBeanServerFactory.findMBeanServer(null).get(0);
    }

    protected ObjectName getChildObjectName(String childMBeanType, String name) throws MBeanException {
        if (this.m_registry == null) {
            return null;
        }
        String[] parentLocation = MBeanHelper.getLocation((ModelMBeanInfo)((Object)this.getMBeanInfo()));
        if (parentLocation == null || parentLocation.length == 0) {
            return null;
        }
        if (name == null) {
            return this.m_registry.getMbeanObjectName(childMBeanType, parentLocation);
        }
        String[] childLocation = new String[parentLocation.length + 1];
        for (int i = 0; i < parentLocation.length; ++i) {
            childLocation[i] = parentLocation[i];
        }
        childLocation[parentLocation.length] = name;
        return this.m_registry.getMbeanObjectName(childMBeanType, childLocation);
    }

    protected ObjectName getServerObjectName(String server) throws MBeanException {
        return this.m_registry.getMbeanObjectName("server", new String[]{this.getDomainName(), server});
    }

    protected ObjectName[] toServerONArray(String[] ca) throws MBeanException {
        int num = ca.length;
        ObjectName[] result = new ObjectName[num];
        for (int i = 0; i < num; ++i) {
            result[i] = this.getServerObjectName(ca[i]);
        }
        return result;
    }

    protected ObjectName getClusterObjectName(String name) throws MBeanException {
        return this.m_registry.getMbeanObjectName("cluster", new String[]{this.getDomainName(), name});
    }

    protected ObjectName[] toClusterONArray(String[] ca) throws MBeanException {
        int num = ca.length;
        ObjectName[] result = new ObjectName[num];
        for (int i = 0; i < num; ++i) {
            result[i] = this.getClusterObjectName(ca[i]);
        }
        return result;
    }

    protected ObjectName getConfigurationObjectName(String name) throws MBeanException {
        return this.m_registry.getMbeanObjectName("config", new String[]{this.getDomainName(), name});
    }

    protected ObjectName[] toConfigurationONArray(String[] ca) throws MBeanException {
        int num = ca.length;
        ObjectName[] result = new ObjectName[num];
        for (int i = 0; i < num; ++i) {
            result[i] = this.getConfigurationObjectName(ca[i]);
        }
        return result;
    }

    protected ObjectName getNodeAgentObjectName(String name) throws MBeanException {
        return this.m_registry.getMbeanObjectName("node-agent", new String[]{this.getDomainName(), name});
    }

    protected ObjectName[] toNodeAgentONArray(String[] names) throws MBeanException {
        int numNames = names.length;
        ObjectName[] result = new ObjectName[numNames];
        for (int i = 0; i < numNames; ++i) {
            result[i] = this.getNodeAgentObjectName(names[i]);
        }
        return result;
    }
}

