/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.Invocation;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.ContainerFactoryImpl;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.EJBTimerServiceWrapper;
import com.sun.ejb.spi.container.StatefulEJBContext;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import java.lang.reflect.Method;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EnterpriseBean;
import javax.ejb.SessionContext;
import javax.ejb.TimerService;
import javax.transaction.UserTransaction;
import javax.xml.rpc.handler.MessageContext;

public final class SessionContextImpl
extends EJBContextImpl
implements SessionContext,
StatefulEJBContext {
    private Object instanceKey;
    private boolean completedTxStatus;
    private boolean afterCompletionDelayed = false;
    private boolean committing = false;
    private boolean inAfterCompletion = false;
    private boolean isStateless = false;
    private boolean isStateful = false;
    private boolean existsInSessionStore = false;
    private transient int refCount = 0;
    private boolean txCheckpointDelayed;
    private String ejbName;
    private long lastPersistedAt;

    SessionContextImpl(EnterpriseBean ejb, BaseContainer container) {
        super(ejb, container);
        EjbSessionDescriptor sessionDesc = (EjbSessionDescriptor)this.getContainer().getEjbDescriptor();
        this.isStateless = sessionDesc.isStateless();
        this.isStateful = sessionDesc.isStateful();
        this.ejbName = sessionDesc.getName();
    }

    public String toString() {
        return this.ejbName + "; id: " + this.instanceKey;
    }

    public TimerService getTimerService() throws IllegalStateException {
        if (this.isStateful) {
            throw new IllegalStateException("EJBTimer Service is not accessible to Stateful Session ejbs");
        }
        if (this.instanceKey == null) {
            throw new IllegalStateException("Operation not allowed");
        }
        ContainerFactoryImpl cf = (ContainerFactoryImpl)Switch.getSwitch().getContainerFactory();
        EJBTimerService timerService = cf.getEJBTimerService();
        if (timerService == null) {
            throw new EJBException("EJB Timer service not available");
        }
        return new EJBTimerServiceWrapper(timerService, this);
    }

    public UserTransaction getUserTransaction() throws IllegalStateException {
        if (this.state == NOT_INITIALIZED && this.instanceKey == null) {
            throw new IllegalStateException("Operation not allowed");
        }
        return ((BaseContainer)this.getContainer()).getUserTransaction();
    }

    public MessageContext getMessageContext() {
        if (this.isStateless) {
            Switch theSwitch = Switch.getSwitch();
            InvocationManager invManager = theSwitch.getInvocationManager();
            try {
                ComponentInvocation inv = invManager.getCurrentInvocation();
                if (inv != null && this.isWebServiceInvocation(inv)) {
                    return ((Invocation)inv).messageContext;
                }
                throw new IllegalStateException("Attempt to access MessageContext outside of a web service invocation");
            }
            catch (Exception e) {
                IllegalStateException ise = new IllegalStateException();
                ise.initCause(e);
                throw ise;
            }
        }
        throw new IllegalStateException("Attempt to access MessageContext from stateful session ejb");
    }

    protected void checkAccessToCallerSecurity() throws IllegalStateException {
        if (this.isStateless ? this.state == NOT_INITIALIZED || this.inEjbRemove : this.state == NOT_INITIALIZED) {
            throw new IllegalStateException("Operation not allowed");
        }
    }

    public void checkTimerServiceMethodAccess() throws IllegalStateException {
        ComponentInvocation compInv = this.getCurrentComponentInvocation();
        if (this.isStateful && (this.inStatefulSessionEjbCreate(compInv) || this.inActivatePassivate(compInv) || this.inAfterCompletion)) {
            throw new IllegalStateException("EJB Timer methods for stateful session beans cannot be  called in this context");
        }
        if (this.state == NOT_INITIALIZED || this.inEjbRemove) {
            throw new IllegalStateException("EJB Timer method calls cannot be called in this context");
        }
    }

    public Object getInstanceKey() {
        return this.instanceKey;
    }

    public void setInstanceKey(Object instanceKey) {
        this.instanceKey = instanceKey;
    }

    boolean getCompletedTxStatus() {
        return this.completedTxStatus;
    }

    void setCompletedTxStatus(boolean s) {
        this.completedTxStatus = s;
    }

    boolean isAfterCompletionDelayed() {
        return this.afterCompletionDelayed;
    }

    void setAfterCompletionDelayed(boolean s) {
        this.afterCompletionDelayed = s;
    }

    boolean isTxCompleting() {
        return this.committing;
    }

    void setTxCompleting(boolean s) {
        this.committing = s;
    }

    void setInAfterCompletion(boolean flag) {
        this.inAfterCompletion = flag;
    }

    private ComponentInvocation getCurrentComponentInvocation() {
        BaseContainer container = (BaseContainer)this.getContainer();
        return container.invocationManager.getCurrentInvocation();
    }

    private boolean isWebServiceInvocation(ComponentInvocation inv) {
        return inv instanceof Invocation && ((Invocation)inv).isWebService;
    }

    private boolean inStatefulSessionEjbCreate(ComponentInvocation inv) {
        Method currentMethod;
        boolean inEjbCreate = false;
        if (inv instanceof Invocation && (currentMethod = ((Invocation)inv).method) != null && currentMethod.getName().startsWith("create")) {
            Class<?> methodClass;
            inEjbCreate = EJBHome.class.isAssignableFrom(methodClass = currentMethod.getDeclaringClass()) || EJBLocalHome.class.isAssignableFrom(methodClass);
        }
        return inEjbCreate;
    }

    void setTxCheckpointDelayed(boolean val) {
        this.txCheckpointDelayed = val;
    }

    boolean isTxCheckpointDelayed() {
        return this.txCheckpointDelayed;
    }

    long getLastPersistedAt() {
        return this.lastPersistedAt;
    }

    void setLastPersistedAt(long val) {
        this.lastPersistedAt = val;
    }

    public long getLastAccessTime() {
        return this.getLastTimeUsed();
    }

    public boolean canBePassivated() {
        return this.state == 2;
    }

    public SessionContext getSessionContext() {
        return this;
    }

    public boolean existsInStore() {
        return this.existsInSessionStore;
    }

    public void setExistsInStore(boolean val) {
        this.existsInSessionStore = val;
    }

    public final void incrementRefCount() {
        ++this.refCount;
    }

    public final void decrementRefCount() {
        --this.refCount;
    }

    public final int getRefCount() {
        return this.refCount;
    }
}

