/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.ComponentContext;
import com.sun.ejb.Invocation;
import com.sun.ejb.MessageBeanClient;
import com.sun.ejb.MessageBeanClientFactory;
import com.sun.ejb.MessageBeanListener;
import com.sun.ejb.MessageBeanProtocolManager;
import com.sun.ejb.ResourcesExceededException;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EJBLocalRemoteObject;
import com.sun.ejb.containers.EJBObjectImpl;
import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.MessageBeanContextImpl;
import com.sun.ejb.containers.MessageBeanListenerImpl;
import com.sun.ejb.containers.RuntimeTimerState;
import com.sun.ejb.containers.TimerWrapper;
import com.sun.ejb.containers.util.pool.AbstractPool;
import com.sun.ejb.containers.util.pool.NonBlockingPool;
import com.sun.ejb.containers.util.pool.ObjectFactory;
import com.sun.ejb.spi.stats.MessageDrivenBeanStatsProvider;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.PoolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.appverification.factory.AppVerification;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.MdbContainer;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.runtime.BeanPoolDescriptor;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.security.SecurityUtil;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EnterpriseBean;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.ejb.RemoveException;

public final class MessageBeanContainer
extends BaseContainer
implements MessageBeanProtocolManager,
MessageDrivenBeanStatsProvider {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb.mdb");
    private String appEJBName_;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(MessageBeanContainer.class);
    private static final int POOLED = 1;
    private static final int INVOKING = 2;
    private static final int DESTROYED = 3;
    private Method ejbCreateMethod_ = null;
    private MessageBeanClient messageBeanClient_ = null;
    private AbstractPool messageBeanPool_ = null;
    private BeanPoolDescriptor beanPoolDesc_ = null;
    private int maxMessageBeanListeners_;
    private int numMessageBeanListeners_;
    private static final String MESSAGE_BEAN_CLIENT_FACTORY_PROP = "com.sun.enterprise.MessageBeanClientFactory";
    private static final String DEFAULT_MESSAGE_BEAN_CLIENT_FACTORY = "com.sun.enterprise.connectors.inflow.ConnectorMessageBeanClientFactory";
    private static final int DEFAULT_RESIZE_QUANTITY = 1;
    private static final int DEFAULT_STEADY_SIZE = 10;
    private static final int DEFAULT_MAX_POOL_SIZE = 60;
    private static final int DEFAULT_IDLE_TIMEOUT = 600;
    private static final int MIN_IDLE_TIMEOUT = 1;
    private int statMessageCount = 0;

    MessageBeanContainer(EjbDescriptor desc, ClassLoader loader) throws Exception {
        super(desc, loader);
        this.appEJBName_ = desc.getApplication().getRegistrationName() + ":" + desc.getName();
        EjbMessageBeanDescriptor msgBeanDesc = (EjbMessageBeanDescriptor)desc;
        try {
            Class msgDrivenBeanClass;
            Class clazz = msgDrivenBeanClass = MessageDrivenBean.class;
            if (!msgDrivenBeanClass.isAssignableFrom(this.ejbClass)) {
                String errorMsg = localStrings.getLocalString("containers.mdb.notimplements", "Error : Message-driven EJB {0} must implement {1}", new Object[]{desc.getName(), "javax.ejb.MessageDrivenBean"});
                throw new EJBException(errorMsg);
            }
            this.ejbCreateMethod_ = this.ejbClass.getMethod("ejbCreate", null);
            Method[] msgListenerMethods = msgBeanDesc.getMessageListenerInterfaceMethods(loader);
            for (int i = 0; i < msgListenerMethods.length; ++i) {
                Method next = msgListenerMethods[i];
                super.registerTxAttrForMethod(next, MethodDescriptor.EJB_BEAN);
            }
            String factoryClassName = System.getProperty(MESSAGE_BEAN_CLIENT_FACTORY_PROP, DEFAULT_MESSAGE_BEAN_CLIENT_FACTORY);
            Class<?> clientFactoryClass = Class.forName(factoryClassName);
            MessageBeanClientFactory clientFactory = (MessageBeanClientFactory)clientFactoryClass.newInstance();
            _logger.log(Level.FINE, "Using " + factoryClassName + " for message bean client factory in " + this.appEJBName_);
            this.createMessageBeanPool(msgBeanDesc);
            this.maxMessageBeanListeners_ = this.beanPoolDesc_.getMaxPoolSize();
            this.numMessageBeanListeners_ = 0;
            this.messageBeanClient_ = clientFactory.createMessageBeanClient(msgBeanDesc);
            this.messageBeanClient_.setup(this);
            this.registerMonitorableComponents(msgListenerMethods);
        }
        catch (Exception ex) {
            if (this.messageBeanClient_ != null) {
                this.messageBeanClient_.close();
            }
            _logger.log(Level.SEVERE, "containers.mdb.create_container_exception", new Object[]{desc.getName(), ex.toString()});
            _logger.log(Level.SEVERE, ex.getClass().getName(), ex);
            throw ex;
        }
    }

    protected void registerMonitorableComponents(Method[] msgListenerMethods) {
        this.registryMediator.registerProvider(this);
        super.registerMonitorableComponents();
        super.populateMethodMonitorMap(msgListenerMethods);
        _logger.log(Level.FINE, "[Entity Container] registered monitorable");
    }

    private void createMessageBeanPool(EjbMessageBeanDescriptor descriptor) throws ConfigException {
        this.beanPoolDesc_ = descriptor.getIASEjbExtraDescriptors().getBeanPool();
        if (this.beanPoolDesc_ == null) {
            this.beanPoolDesc_ = new BeanPoolDescriptor();
        }
        ServerContext sc = ApplicationServer.getServerContext();
        MdbContainer mdbc = ServerBeansFactory.getConfigBean(sc.getConfigContext()).getMdbContainer();
        int maxPoolSize = this.beanPoolDesc_.getMaxPoolSize();
        if (maxPoolSize < 0) {
            maxPoolSize = MessageBeanContainer.stringToInt(mdbc.getMaxPoolSize(), this.appEJBName_, _logger);
        }
        maxPoolSize = this.validateValue(maxPoolSize, 1, -1, 60, "max-pool-size", this.appEJBName_, _logger);
        this.beanPoolDesc_.setMaxPoolSize(maxPoolSize);
        int value = this.beanPoolDesc_.getSteadyPoolSize();
        if (value < 0) {
            value = MessageBeanContainer.stringToInt(mdbc.getSteadyPoolSize(), this.appEJBName_, _logger);
        }
        value = this.validateValue(value, 0, maxPoolSize, 10, "steady-pool-size", this.appEJBName_, _logger);
        this.beanPoolDesc_.setSteadyPoolSize(value);
        value = this.beanPoolDesc_.getPoolResizeQuantity();
        if (value < 0) {
            value = MessageBeanContainer.stringToInt(mdbc.getPoolResizeQuantity(), this.appEJBName_, _logger);
        }
        value = this.validateValue(value, 1, maxPoolSize, 1, "pool-resize-quantity", this.appEJBName_, _logger);
        this.beanPoolDesc_.setPoolResizeQuantity(value);
        value = this.beanPoolDesc_.getPoolIdleTimeoutInSeconds();
        if (value <= 0) {
            value = MessageBeanContainer.stringToInt(mdbc.getIdleTimeoutInSeconds(), this.appEJBName_, _logger);
        }
        value = this.validateValue(value, 1, -1, 600, "idle-timeout-in-seconds", this.appEJBName_, _logger);
        this.beanPoolDesc_.setPoolIdleTimeoutInSeconds(value);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, this.appEJBName_ + ": Setting message-driven bean pool max-pool-size=" + this.beanPoolDesc_.getMaxPoolSize() + ", steady-pool-size=" + this.beanPoolDesc_.getSteadyPoolSize() + ", pool-resize-quantity=" + this.beanPoolDesc_.getPoolResizeQuantity() + ", idle-timeout-in-seconds=" + this.beanPoolDesc_.getPoolIdleTimeoutInSeconds());
        }
        MessageBeanContextFactory objFactory = new MessageBeanContextFactory();
        this.messageBeanPool_ = new NonBlockingPool(this.appEJBName_, objFactory, this.beanPoolDesc_.getSteadyPoolSize(), this.beanPoolDesc_.getPoolResizeQuantity(), this.beanPoolDesc_.getMaxPoolSize(), this.beanPoolDesc_.getPoolIdleTimeoutInSeconds(), this.loader);
        this.registryMediator.registerProvider(this.messageBeanPool_);
    }

    protected static int stringToInt(String val, String appName, Logger logger) {
        int value = -1;
        try {
            value = Integer.parseInt(val);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "containers.mdb.invalid_value", new Object[]{appName, new Integer(val), e.toString(), new Integer(0)});
            _logger.log(Level.WARNING, "", e);
        }
        return value;
    }

    protected int validateValue(int value, int lowLimit, int highLimit, int deft, String emsg, String appName, Logger logger) {
        if (value < lowLimit) {
            _logger.log(Level.WARNING, "containers.mdb.invalid_value", new Object[]{appName, new Integer(value), emsg, new Integer(lowLimit)});
            value = deft;
        }
        if (highLimit >= 0 && value > highLimit) {
            _logger.log(Level.WARNING, "containers.mdb.invalid_value", new Object[]{appName, new Integer(value), emsg, new Integer(highLimit)});
            value = highLimit;
        }
        return value;
    }

    private boolean containerStartsTx(Method method) {
        int txMode = this.getTxAttr(method, MethodDescriptor.EJB_BEAN);
        return method.equals(this.ejbTimeoutMethod) ? txMode == 5 : txMode == 3;
    }

    public String getMonitorAttributeValues() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("MESSAGEDRIVEN ");
        sbuf.append(this.appEJBName_);
        sbuf.append(this.messageBeanPool_.getAllAttrValues());
        sbuf.append("]");
        return sbuf.toString();
    }

    public boolean userTransactionMethodsAllowed(ComponentInvocation inv) {
        boolean utMethodsAllowed = false;
        if (this.isBeanManagedTran && inv instanceof Invocation) {
            Invocation i = (Invocation)inv;
            EJBContextImpl mdc = (EJBContextImpl)i.context;
            utMethodsAllowed = !mdc.isUnitialized() && !mdc.isInEjbRemove();
        }
        return utMethodsAllowed;
    }

    public void setEJBHome(EJBHome ejbHome) throws Exception {
        throw new Exception("Can't set EJB Home on Message-driven bean");
    }

    public EJBObjectImpl getEJBObjectImpl(byte[] instanceKey) {
        throw new EJBException("No EJBObject for message-driven beans");
    }

    public EJBObjectImpl createEJBObjectImpl() throws CreateException {
        throw new EJBException("No EJBObject for message-driven beans");
    }

    void removeBean(EJBLocalRemoteObject ejbo, Method removeMethod, boolean local) throws RemoveException, EJBException {
        throw new EJBException("not used in message-driven beans");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean callEJBTimeout(RuntimeTimerState timerState, EJBTimerService timerService) throws Exception {
        ResourceHandle nullResourceHandle;
        boolean redeliver;
        block10: {
            redeliver = false;
            nullResourceHandle = null;
            try {
                try {
                    this.beforeMessageDelivery(this.ejbTimeoutMethod, false, nullResourceHandle);
                    Object[] args = new Object[]{new TimerWrapper(timerState.getTimerId(), timerService)};
                    this.deliverMessage(args);
                }
                catch (Throwable t) {
                    redeliver = true;
                    _logger.log(Level.FINE, "ejbTimeout threw Runtime exception", t);
                    Object var7_8 = null;
                    if (!this.isBeanManagedTran && this.transactionManager.getStatus() == 1) {
                        redeliver = true;
                        _logger.log(Level.FINE, "ejbTimeout called setRollbackOnly");
                    }
                    if (!redeliver) {
                        boolean successfulPostEjbTimeout = timerService.postEjbTimeout(timerState.getTimerId());
                        redeliver = !successfulPostEjbTimeout;
                    }
                    boolean successfulAfterMessageDelivery = this.afterMessageDeliveryInternal(nullResourceHandle);
                    if (redeliver) return redeliver;
                    if (successfulAfterMessageDelivery) return redeliver;
                    return true;
                }
                Object var7_7 = null;
                if (this.isBeanManagedTran) break block10;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (!this.isBeanManagedTran && this.transactionManager.getStatus() == 1) {
                    redeliver = true;
                    _logger.log(Level.FINE, "ejbTimeout called setRollbackOnly");
                }
                if (!redeliver) {
                    boolean successfulPostEjbTimeout = timerService.postEjbTimeout(timerState.getTimerId());
                    redeliver = !successfulPostEjbTimeout;
                }
                boolean successfulAfterMessageDelivery = this.afterMessageDeliveryInternal(nullResourceHandle);
                if (redeliver) throw throwable;
                if (successfulAfterMessageDelivery) throw throwable;
                redeliver = true;
                throw throwable;
            }
            if (this.transactionManager.getStatus() == 1) {
                redeliver = true;
                _logger.log(Level.FINE, "ejbTimeout called setRollbackOnly");
            }
        }
        if (!redeliver) {
            boolean successfulPostEjbTimeout = timerService.postEjbTimeout(timerState.getTimerId());
            redeliver = !successfulPostEjbTimeout;
        }
        boolean successfulAfterMessageDelivery = this.afterMessageDeliveryInternal(nullResourceHandle);
        if (redeliver) return redeliver;
        if (successfulAfterMessageDelivery) return redeliver;
        return true;
    }

    void forceDestroyBean(EJBContextImpl sc) {
        if (sc.getState() == 3) {
            return;
        }
        sc.setState(3);
        this.messageBeanPool_.destroyObject(sc);
    }

    public void preInvoke(Invocation inv) {
        throw new EJBException("preInvoke(Invocation) not supported");
    }

    protected ComponentContext _getContext(Invocation inv) {
        MessageBeanContextImpl context = null;
        try {
            context = (MessageBeanContextImpl)this.messageBeanPool_.getObject(null);
            context.setState(2);
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
        return context;
    }

    public void releaseContext(Invocation inv) {
        MessageBeanContextImpl beanContext = (MessageBeanContextImpl)inv.context;
        if (beanContext.getState() == 3) {
            return;
        }
        beanContext.setState(1);
        beanContext.setTransaction(null);
        beanContext.touch();
        this.messageBeanPool_.returnObject(beanContext);
    }

    public void appendStats(StringBuffer sbuf) {
        sbuf.append("\nMessageBeanContainer: ").append("CreateCount=").append(this.statCreateCount).append("; ").append("RemoveCount=").append(this.statRemoveCount).append("; ").append("MsgCount=").append(this.statMessageCount).append("; ");
        sbuf.append("]");
    }

    public void postInvoke(Invocation inv) {
        throw new EJBException("postInvoke(Invocation) not supported in message-driven bean container");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageBeanListener createMessageBeanListener(ResourceHandle resource) throws ResourcesExceededException {
        boolean resourcesExceeded = false;
        MessageBeanContainer messageBeanContainer = this;
        synchronized (messageBeanContainer) {
            if (this.numMessageBeanListeners_ < this.maxMessageBeanListeners_) {
                ++this.numMessageBeanListeners_;
            } else {
                resourcesExceeded = true;
            }
        }
        if (resourcesExceeded) {
            ResourcesExceededException ree = new ResourcesExceededException("Message Bean Resources exceeded for message bean " + this.appEJBName_);
            _logger.log(Level.FINE, "exceeded max of " + this.maxMessageBeanListeners_, ree);
            throw ree;
        }
        return new MessageBeanListenerImpl(this, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyMessageBeanListener(MessageBeanListener listener) {
        MessageBeanContainer messageBeanContainer = this;
        synchronized (messageBeanContainer) {
            --this.numMessageBeanListeners_;
        }
    }

    public boolean isDeliveryTransacted(Method method) {
        return this.containerStartsTx(method);
    }

    public BeanPoolDescriptor getPoolDescriptor() {
        return this.beanPoolDesc_;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MessageBeanContextImpl createMessageDrivenEJB() throws CreateException {
        MessageBeanContextImpl context;
        Invocation inv;
        block7: {
            inv = null;
            context = null;
            ClassLoader originalClassLoader = null;
            boolean methodCalled = false;
            boolean methodCallFailed = false;
            try {
                try {
                    originalClassLoader = this.setContextClassLoader(this.getClassLoader());
                    MessageDrivenBean ejb = (MessageDrivenBean)this.ejbClass.newInstance();
                    context = new MessageBeanContextImpl((EnterpriseBean)ejb, this);
                    inv = new Invocation((EnterpriseBean)ejb, (Object)this);
                    inv.context = context;
                    inv.isMessageDriven = true;
                    this.invocationManager.preInvoke(inv);
                    ejb.setMessageDrivenContext((MessageDrivenContext)context);
                    context.setContextCalled();
                    this.ejbCreateMethod_.invoke((Object)ejb, null);
                    ++this.statCreateCount;
                    context.setState(1);
                }
                catch (Throwable t) {
                    _logger.log(Level.SEVERE, "containers.mdb.ejb_creation_exception", new Object[]{this.appEJBName_, t.toString()});
                    if (t instanceof InvocationTargetException) {
                        _logger.log(Level.SEVERE, t.getClass().getName(), t.getCause());
                    }
                    _logger.log(Level.SEVERE, t.getClass().getName(), t);
                    CreateException ce = new CreateException("Could not create Message-Driven EJB");
                    ce.initCause(t);
                    throw ce;
                }
                Object var9_8 = null;
                if (originalClassLoader == null) break block7;
                this.setContextClassLoader(originalClassLoader);
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (originalClassLoader != null) {
                    this.setContextClassLoader(originalClassLoader);
                }
                if (inv == null) throw throwable;
                this.invocationManager.postInvoke(inv);
                throw throwable;
            }
        }
        if (inv == null) return context;
        this.invocationManager.postInvoke(inv);
        return context;
    }

    private void registerMessageBeanResource(ResourceHandle resourceHandle) throws Exception {
        if (resourceHandle != null) {
            Switch theSwitch = Switch.getSwitch();
            PoolManager poolMgr = theSwitch.getPoolManager();
            poolMgr.registerResource(resourceHandle);
        }
    }

    private void unregisterMessageBeanResource(ResourceHandle resourceHandle) {
        if (resourceHandle != null) {
            Switch theSwitch = Switch.getSwitch();
            PoolManager poolMgr = theSwitch.getPoolManager();
            poolMgr.unregisterResource(resourceHandle, 0x4000000);
        }
    }

    void afterBegin(EJBContextImpl context) {
    }

    void beforeCompletion(EJBContextImpl context) {
    }

    void afterCompletion(EJBContextImpl ctx, int status) {
    }

    public boolean passivateEJB(ComponentContext context) {
        return false;
    }

    public void activateEJB(Object ctx, Object instanceKey) {
    }

    public void doAfterApplicationDeploy() {
        super.setStartedState();
        try {
            this.messageBeanClient_.start();
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "containers.mdb.start_message_delivery_exception", new Object[]{this.appEJBName_, e.toString()});
            _logger.log(Level.SEVERE, e.getClass().getName(), e);
        }
    }

    private void cleanupResources() {
        try {
            this.messageBeanClient_.close();
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "containers.mdb.cleanup_exception", new Object[]{this.appEJBName_, e.toString()});
            _logger.log(Level.SEVERE, e.getClass().getName(), e);
        }
        this.messageBeanPool_.close();
    }

    public void undeploy() {
        super.setUndeployedState();
        _logger.log(Level.FINE, "containers.mdb.undeploy", this.appEJBName_);
        this.cleanupResources();
        super.undeploy();
    }

    public void onShutdown() {
        _logger.log(Level.FINE, "containers.mdb.shutdown_cleanup_start", this.appEJBName_);
        this.setStoppedState();
        this.monitorOn = false;
        this.cleanupResources();
        _logger.log(Level.FINE, "containers.mdb.shutdown_cleanup_end", this.appEJBName_);
    }

    public void beforeMessageDelivery(Method method, boolean txImported, ResourceHandle resourceHandle) {
        if (this.containerState != 0) {
            String errorMsg = localStrings.getLocalString("containers.mdb.invocation_closed", this.appEJBName_ + ": Message-driven bean invocation closed by container", new Object[]{this.appEJBName_});
            throw new EJBException(errorMsg);
        }
        Invocation invocation = new Invocation();
        try {
            MessageBeanContextImpl context = (MessageBeanContextImpl)this.getContext(invocation);
            invocation.originalContextClassLoader = this.setContextClassLoader(this.getClassLoader());
            invocation.isMessageDriven = true;
            invocation.method = method;
            context.setState(2);
            invocation.context = context;
            invocation.instance = context.getEJB();
            invocation.ejb = context.getEJB();
            invocation.container = this;
            boolean startTx = false;
            if (!txImported) {
                startTx = this.containerStartsTx(method);
            }
            invocation.containerStartsTx = startTx;
            this.invocationManager.preInvoke(invocation);
            if (startTx) {
                this.registerMessageBeanResource(resourceHandle);
            }
            this.preInvokeTx(invocation);
        }
        catch (Throwable c) {
            if (this.containerState != 0) {
                _logger.log(Level.SEVERE, "containers.mdb.preinvoke_exception", new Object[]{this.appEJBName_, c.toString()});
                _logger.log(Level.SEVERE, c.getClass().getName(), c);
            }
            invocation.exception = c;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object deliverMessage(Object[] params) throws Throwable {
        Invocation invocation = null;
        boolean methodCalled = false;
        Object result = null;
        invocation = (Invocation)this.invocationManager.getCurrentInvocation();
        if (invocation == null && _logger.isLoggable(Level.FINEST)) {
            if (this.containerState != 0) {
                _logger.log(Level.FINEST, "No invocation in onMessage  (container closing)");
            } else {
                _logger.log(Level.FINEST, "No invocation in onMessage : ");
            }
        }
        if (invocation != null && invocation.exception == null) {
            block13: {
                try {
                    try {
                        methodCalled = true;
                        if (this.ejbMethodStatsManager.isMethodMonitorOn()) {
                            this.ejbMethodStatsManager.preInvoke(invocation.method);
                        }
                        result = SecurityUtil.invoke(invocation.method, invocation, invocation.ejb, params, this, null);
                    }
                    catch (InvocationTargetException ite) {
                        Throwable cause;
                        invocation.exception = cause = ite.getCause();
                        if (!this.isSystemUncheckedException(cause)) throw cause;
                        EJBException ejbEx = new EJBException("message-driven bean method " + invocation.method + " system exception");
                        ejbEx.initCause(cause);
                        cause = ejbEx;
                        throw cause;
                    }
                    catch (Throwable t) {
                        EJBException ejbEx = new EJBException("message-bean container dispatch error");
                        ejbEx.initCause(t);
                        invocation.exception = ejbEx;
                        throw ejbEx;
                    }
                    Object var9_5 = null;
                    if (!methodCalled || !this.ejbMethodStatsManager.isMethodMonitorOn()) break block13;
                    this.ejbMethodStatsManager.postInvoke(invocation.method, invocation.exception);
                }
                catch (Throwable throwable) {
                    Object var9_6 = null;
                    if (methodCalled && this.ejbMethodStatsManager.isMethodMonitorOn()) {
                        this.ejbMethodStatsManager.postInvoke(invocation.method, invocation.exception);
                    }
                    if (!AppVerification.doInstrument()) throw throwable;
                    AppVerification.getInstrumentLogger().doInstrumentForEjb(this.getEjbDescriptor(), invocation.method, invocation.exception);
                    throw throwable;
                }
            }
            if (!AppVerification.doInstrument()) return result;
            AppVerification.getInstrumentLogger().doInstrumentForEjb(this.getEjbDescriptor(), invocation.method, invocation.exception);
            return result;
        }
        if (invocation == null) {
            String errorMsg = localStrings.getLocalString("containers.mdb.invocation_closed", this.appEJBName_ + ": Message-driven bean invocation " + "closed by container", new Object[]{this.appEJBName_});
            throw new EJBException(errorMsg);
        }
        _logger.log(Level.SEVERE, "containers.mdb.invocation_exception", new Object[]{this.appEJBName_, invocation.exception.toString()});
        _logger.log(Level.SEVERE, invocation.exception.getClass().getName(), invocation.exception);
        EJBException ejbEx = new EJBException();
        ejbEx.initCause(invocation.exception);
        throw ejbEx;
    }

    public void afterMessageDelivery(ResourceHandle resourceHandle) {
        this.afterMessageDeliveryInternal(resourceHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean afterMessageDeliveryInternal(ResourceHandle resourceHandle) {
        boolean success = false;
        Invocation invocation = null;
        invocation = (Invocation)this.invocationManager.getCurrentInvocation();
        if (invocation == null) {
            _logger.log(Level.SEVERE, "containers.mdb.no_invocation", new Object[]{this.appEJBName_, ""});
        } else {
            MessageBeanContextImpl beanContext = (MessageBeanContextImpl)invocation.context;
            try {
                if (invocation.containerStartsTx) {
                    this.unregisterMessageBeanResource(resourceHandle);
                }
                this.invocationManager.postInvoke(invocation);
                this.postInvokeTx(invocation);
                success = true;
                ++this.statMessageCount;
            }
            catch (Throwable ce) {
                _logger.log(Level.SEVERE, "containers.mdb.postinvoke_exception", new Object[]{this.appEJBName_, ce.toString()});
                _logger.log(Level.SEVERE, ce.getClass().getName(), ce);
            }
            finally {
                this.releaseContext(invocation);
            }
            this.setContextClassLoader(invocation.originalContextClassLoader);
            if (invocation.exception != null) {
                if (this.isSystemUncheckedException(invocation.exception)) {
                    success = false;
                }
                Level exLogLevel = this.isSystemUncheckedException(invocation.exception) ? Level.INFO : Level.FINE;
                _logger.log(exLogLevel, "containers.mdb.invocation_exception", new Object[]{this.appEJBName_, invocation.exception.toString()});
                _logger.log(exLogLevel, invocation.exception.getClass().getName(), invocation.exception);
            }
        }
        return success;
    }

    private ClassLoader setContextClassLoader(ClassLoader newClassLoader) {
        final ClassLoader classLoaderToSet = newClassLoader;
        final Thread currentThread = Thread.currentThread();
        ClassLoader originalClassLoader = currentThread.getContextClassLoader();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                currentThread.setContextClassLoader(classLoaderToSet);
                return null;
            }
        });
        return originalClassLoader;
    }

    public long getCreateCount() {
        return this.statCreateCount;
    }

    public long getRemoveCount() {
        return this.statRemoveCount;
    }

    public long getMessageCount() {
        return this.statMessageCount;
    }

    private class MessageBeanContextFactory
    implements ObjectFactory {
        private MessageBeanContextFactory() {
        }

        public Object create(Object param) {
            try {
                return MessageBeanContainer.this.createMessageDrivenEJB();
            }
            catch (CreateException ex) {
                throw new EJBException((Exception)((Object)ex));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void destroy(Object obj) {
            MessageBeanContextImpl beanContext = (MessageBeanContextImpl)obj;
            MessageDrivenBean ejb = (MessageDrivenBean)beanContext.getEJB();
            if (beanContext.getState() != 3) {
                block7: {
                    Invocation inv = null;
                    try {
                        try {
                            inv = new Invocation((EnterpriseBean)ejb, (Object)MessageBeanContainer.this);
                            inv.context = beanContext;
                            inv.isMessageDriven = true;
                            MessageBeanContainer.this.invocationManager.preInvoke(inv);
                            beanContext.setInEjbRemove(true);
                            ejb.ejbRemove();
                            ++MessageBeanContainer.this.statRemoveCount;
                        }
                        catch (Throwable t) {
                            _logger.log(Level.SEVERE, "containers.mdb_preinvoke_exception_indestroy", new Object[]{MessageBeanContainer.this.appEJBName_, t.toString()});
                            _logger.log(Level.SEVERE, t.getClass().getName(), t);
                            Object var7_6 = null;
                            if (inv != null) {
                                MessageBeanContainer.this.invocationManager.postInvoke(inv);
                            }
                            break block7;
                        }
                        Object var7_5 = null;
                        if (inv == null) break block7;
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        if (inv != null) {
                            MessageBeanContainer.this.invocationManager.postInvoke(inv);
                        }
                        throw throwable;
                    }
                    MessageBeanContainer.this.invocationManager.postInvoke(inv);
                }
                beanContext.setState(3);
            }
            MessageBeanContainer.this.transactionManager.ejbDestroyed(beanContext);
            beanContext.setTransaction(null);
        }
    }
}

