/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.Invocation;
import com.sun.ejb.InvocationInfo;
import com.sun.ejb.containers.EJBObjectImpl;
import com.sun.ejb.containers.InvocationHandlerUtil;
import com.sun.ejb.containers.util.MethodMap;
import com.sun.enterprise.security.SecurityUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBObject;

public final class EJBObjectInvocationHandler
extends EJBObjectImpl
implements InvocationHandler {
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EJBObjectInvocationHandler.class);
    private EJBObject proxy_;
    private MethodMap invocationInfoMap_;

    public EJBObjectInvocationHandler(MethodMap invocationInfoMap) throws Exception {
        this.invocationInfoMap_ = invocationInfoMap;
    }

    public void setProxy(EJBObject proxy) {
        this.proxy_ = proxy;
    }

    public EJBObject getEJBObject() {
        return this.proxy_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> methodClass = method.getDeclaringClass();
        if (methodClass == Object.class) {
            return InvocationHandlerUtil.invokeJavaObjectMethod(this, method, args);
        }
        InvocationInfo invInfo = (InvocationInfo)this.invocationInfoMap_.get(method, args != null ? args.length : 0);
        if (invInfo == null) {
            throw new RemoteException("Unknown Remote interface method :" + method);
        }
        if (methodClass == EJBObject.class || invInfo.ejbIntfOverride) {
            return this.invokeEJBObjectMethod(method.getName(), args);
        }
        if (invInfo.targetMethod1 == null) {
            Object[] params = new Object[]{invInfo.ejbName, "Remote", invInfo.method.toString()};
            String errorMsg = localStrings.getLocalString("ejb.bean_class_method_not_found", "", params);
            logger.log(Level.SEVERE, "ejb.bean_class_method_not_found", params);
            throw new RemoteException(errorMsg);
        }
        Object returnValue = null;
        Invocation inv = new Invocation();
        inv.isLocal = false;
        inv.isHome = false;
        inv.ejbObject = this;
        inv.method = method;
        inv.transactionAttribute = invInfo.txAttr;
        inv.securityPermissions = invInfo.securityPermissions;
        inv.invocationInfo = invInfo;
        try {
            this.container.preInvoke(inv);
            returnValue = SecurityUtil.invoke(invInfo.targetMethod1, inv, inv.ejb, args, this.container, null);
        }
        catch (InvocationTargetException ite) {
            inv.exception = ite.getCause();
        }
        catch (Throwable t) {
            inv.exception = t;
        }
        finally {
            this.container.postInvoke(inv);
        }
        if (inv.exception != null) {
            InvocationHandlerUtil.throwRemoteException(inv.exception, method.getExceptionTypes());
        }
        return returnValue;
    }

    private Object invokeEJBObjectMethod(String methodName, Object[] args) throws Exception {
        Object returnValue = null;
        if (methodName.equals("getEJBHome")) {
            returnValue = super.getEJBHome();
        } else if (methodName.equals("getHandle")) {
            returnValue = super.getHandle();
        } else if (methodName.equals("getPrimaryKey")) {
            returnValue = super.getPrimaryKey();
        } else if (methodName.equals("isIdentical")) {
            EJBObject other = (EJBObject)args[0];
            returnValue = new Boolean(super.isIdentical(other));
        } else if (methodName.equals("remove")) {
            super.remove();
        } else {
            throw new RemoteException("unknown EJBObject method = " + methodName);
        }
        return returnValue;
    }
}

