/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.org.apache.bcel.classfile;

import com.sun.corba.ee.org.apache.bcel.classfile.Constant;
import com.sun.corba.ee.org.apache.bcel.classfile.ConstantObject;
import com.sun.corba.ee.org.apache.bcel.classfile.ConstantPool;
import com.sun.corba.ee.org.apache.bcel.classfile.ConstantUtf8;
import com.sun.corba.ee.org.apache.bcel.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantClass
extends Constant
implements ConstantObject {
    private int name_index;

    public ConstantClass(ConstantClass constantClass) {
        this(constantClass.getNameIndex());
    }

    ConstantClass(DataInputStream dataInputStream) throws IOException {
        this(dataInputStream.readUnsignedShort());
    }

    public ConstantClass(int n) {
        super((byte)7);
        this.name_index = n;
    }

    public void accept(Visitor visitor) {
        visitor.visitConstantClass(this);
    }

    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.tag);
        dataOutputStream.writeShort(this.name_index);
    }

    public final int getNameIndex() {
        return this.name_index;
    }

    public final void setNameIndex(int n) {
        this.name_index = n;
    }

    public Object getConstantValue(ConstantPool constantPool) {
        Constant constant = constantPool.getConstant(this.name_index, (byte)1);
        return ((ConstantUtf8)constant).getBytes();
    }

    public String getBytes(ConstantPool constantPool) {
        return (String)this.getConstantValue(constantPool);
    }

    public final String toString() {
        return super.toString() + "(name_index = " + this.name_index + ")";
    }
}

