/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.encoding.CDRInputObject;
import com.sun.corba.ee.impl.encoding.CDROutputObject;
import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.oa.poa.Policies;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.transport.EventHandlerBase;
import com.sun.corba.ee.impl.transport.SocketOrChannelConnectionImpl;
import com.sun.corba.ee.impl.transport.SocketOrChannelContactInfoImpl;
import com.sun.corba.ee.pept.broker.Broker;
import com.sun.corba.ee.pept.encoding.InputObject;
import com.sun.corba.ee.pept.encoding.OutputObject;
import com.sun.corba.ee.pept.protocol.MessageMediator;
import com.sun.corba.ee.pept.transport.Acceptor;
import com.sun.corba.ee.pept.transport.Connection;
import com.sun.corba.ee.pept.transport.EventHandler;
import com.sun.corba.ee.pept.transport.InboundConnectionCache;
import com.sun.corba.ee.pept.transport.Selector;
import com.sun.corba.ee.spi.extension.RequestPartitioningPolicy;
import com.sun.corba.ee.spi.ior.IORTemplate;
import com.sun.corba.ee.spi.ior.TaggedProfileTemplate;
import com.sun.corba.ee.spi.ior.iiop.AlternateIIOPAddressComponent;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.ior.iiop.IIOPAddress;
import com.sun.corba.ee.spi.ior.iiop.IIOPFactories;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.ee.spi.legacy.connection.LegacyServerSocketEndPointInfo;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orbutil.threadpool.Work;
import com.sun.corba.ee.spi.protocol.CorbaMessageMediator;
import com.sun.corba.ee.spi.transport.CorbaAcceptor;
import com.sun.corba.ee.spi.transport.CorbaConnection;
import com.sun.corba.ee.spi.transport.SocketInfo;
import com.sun.corba.ee.spi.transport.SocketOrChannelAcceptor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;

public class SocketOrChannelAcceptorImpl
extends EventHandlerBase
implements CorbaAcceptor,
SocketOrChannelAcceptor,
Work,
SocketInfo,
LegacyServerSocketEndPointInfo {
    protected ServerSocketChannel serverSocketChannel;
    protected ServerSocket serverSocket;
    protected int port;
    protected long enqueueTime;
    protected boolean initialized;
    protected ORBUtilSystemException wrapper;
    protected InboundConnectionCache connectionCache;
    protected String type = "";
    protected String name = "";
    protected String hostname;
    protected int locatorPort;

    public SocketOrChannelAcceptorImpl(ORB oRB) {
        this.orb = oRB;
        this.wrapper = ORBUtilSystemException.get(oRB, "rpc.transport");
        this.setWork(this);
        this.initialized = false;
        this.hostname = oRB.getORBData().getORBServerHost();
        this.name = "NO_NAME";
        this.locatorPort = -1;
    }

    public SocketOrChannelAcceptorImpl(ORB oRB, int n) {
        this(oRB);
        this.port = n;
    }

    public SocketOrChannelAcceptorImpl(ORB oRB, int n, String string, String string2) {
        this(oRB, n);
        this.name = string;
        this.type = string2;
    }

    public boolean initialize() {
        if (this.initialized) {
            return false;
        }
        if (this.orb.transportDebugFlag) {
            this.dprint(".initialize: " + this);
        }
        InetSocketAddress inetSocketAddress = null;
        String string = "all interfaces";
        try {
            if (this.orb.getORBData().getListenOnAllInterfaces()) {
                inetSocketAddress = new InetSocketAddress(this.port);
            } else {
                string = this.orb.getORBData().getORBServerHost();
                inetSocketAddress = new InetSocketAddress(string, this.port);
            }
            this.serverSocket = this.orb.getORBData().getSocketFactory().createServerSocket(this.type, inetSocketAddress);
            this.internalInitialize();
            if (this.orb.getORBData().showInfoMessages()) {
                this.wrapper.infoCreateListenerSucceeded(string, Integer.toString(this.port));
            }
        }
        catch (Throwable throwable) {
            throw this.wrapper.createListenerFailed(throwable, (Object)string, (Object)Integer.toString(this.port));
        }
        this.initialized = true;
        return true;
    }

    protected void internalInitialize() throws Exception {
        this.port = this.serverSocket.getLocalPort();
        this.orb.getCorbaTransportManager().getInboundConnectionCache(this);
        this.serverSocketChannel = this.serverSocket.getChannel();
        if (this.serverSocketChannel != null) {
            this.setUseSelectThreadToWait(this.orb.getORBData().acceptorSocketUseSelectThreadToWait());
            this.serverSocketChannel.configureBlocking(!this.orb.getORBData().acceptorSocketUseSelectThreadToWait());
        } else {
            this.setUseSelectThreadToWait(false);
        }
        this.setUseWorkerThreadForEvent(this.orb.getORBData().acceptorSocketUseWorkerThreadForEvent());
    }

    public boolean initialized() {
        return this.initialized;
    }

    public String getConnectionCacheType() {
        return this.getClass().toString();
    }

    public void setConnectionCache(InboundConnectionCache inboundConnectionCache) {
        this.connectionCache = inboundConnectionCache;
    }

    public InboundConnectionCache getConnectionCache() {
        return this.connectionCache;
    }

    public boolean shouldRegisterAcceptEvent() {
        return true;
    }

    public void accept() {
        try {
            SocketChannel socketChannel = null;
            Socket socket = null;
            if (this.serverSocketChannel == null) {
                socket = this.serverSocket.accept();
            } else {
                socketChannel = this.serverSocketChannel.accept();
                socket = socketChannel.socket();
            }
            this.orb.getORBData().getSocketFactory().setAcceptedSocketOptions(this, this.serverSocket, socket);
            if (this.orb.transportDebugFlag) {
                this.dprint(".accept: " + (this.serverSocketChannel == null ? this.serverSocket.toString() : this.serverSocketChannel.toString()));
            }
            SocketOrChannelConnectionImpl socketOrChannelConnectionImpl = new SocketOrChannelConnectionImpl(this.orb, this, socket);
            if (this.orb.transportDebugFlag) {
                this.dprint(".accept: new: " + socketOrChannelConnectionImpl);
            }
            this.getConnectionCache().put(this, socketOrChannelConnectionImpl);
            if (socketOrChannelConnectionImpl.shouldRegisterServerReadEvent()) {
                Selector selector = this.orb.getTransportManager().getSelector(0);
                selector.registerForEvent(socketOrChannelConnectionImpl.getEventHandler());
            }
            this.getConnectionCache().reclaim();
        }
        catch (IOException iOException) {
            this.wrapper.ioexceptionInAccept(iOException);
            this.orb.getTransportManager().getSelector(0).unregisterForEvent(this);
            this.orb.getTransportManager().getSelector(0).registerForEvent(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this.orb.transportDebugFlag) {
                this.dprint(".close->:");
            }
            Selector selector = this.orb.getTransportManager().getSelector(0);
            selector.unregisterForEvent(this);
            if (this.serverSocketChannel != null) {
                this.serverSocketChannel.close();
            }
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException iOException) {
            if (this.orb.transportDebugFlag) {
                this.dprint(".close:", iOException);
            }
        }
        finally {
            if (this.orb.transportDebugFlag) {
                this.dprint(".close<-:");
            }
        }
    }

    public EventHandler getEventHandler() {
        return this;
    }

    public String getObjectAdapterId() {
        return null;
    }

    public String getObjectAdapterManagerId() {
        return null;
    }

    public void addToIORTemplate(IORTemplate iORTemplate, Policies policies, String string) {
        Iterator iterator = iORTemplate.iteratorById(0);
        String string2 = this.orb.getORBData().getORBServerHost();
        if (iterator.hasNext()) {
            IIOPAddress iIOPAddress = IIOPFactories.makeIIOPAddress(this.orb, string2, this.port);
            AlternateIIOPAddressComponent alternateIIOPAddressComponent = IIOPFactories.makeAlternateIIOPAddressComponent(iIOPAddress);
            while (iterator.hasNext()) {
                TaggedProfileTemplate taggedProfileTemplate = (TaggedProfileTemplate)iterator.next();
                taggedProfileTemplate.add(alternateIIOPAddressComponent);
            }
        } else {
            GIOPVersion gIOPVersion = this.orb.getORBData().getGIOPVersion();
            int n = policies.forceZeroPort() ? 0 : (policies.isTransient() ? this.port : this.orb.getLegacyServerSocketManager().legacyGetPersistentServerPort("IIOP_CLEAR_TEXT"));
            IIOPAddress iIOPAddress = IIOPFactories.makeIIOPAddress(this.orb, string2, n);
            IIOPProfileTemplate iIOPProfileTemplate = IIOPFactories.makeIIOPProfileTemplate(this.orb, gIOPVersion, iIOPAddress);
            if (gIOPVersion.supportsIORIIOPProfileComponents()) {
                iIOPProfileTemplate.add(IIOPFactories.makeCodeSetsComponent(this.orb));
                iIOPProfileTemplate.add(IIOPFactories.makeMaxStreamFormatVersionComponent());
                RequestPartitioningPolicy requestPartitioningPolicy = (RequestPartitioningPolicy)policies.get_effective_policy(0x53550003);
                if (requestPartitioningPolicy != null) {
                    iIOPProfileTemplate.add(IIOPFactories.makeRequestPartitioningComponent(requestPartitioningPolicy.getValue()));
                }
                if (string != null && string != "") {
                    iIOPProfileTemplate.add(IIOPFactories.makeJavaCodebaseComponent(string));
                }
                if (this.orb.getORBData().isJavaSerializationEnabled()) {
                    iIOPProfileTemplate.add(IIOPFactories.makeJavaSerializationComponent());
                }
            }
            iORTemplate.add(iIOPProfileTemplate);
        }
    }

    public String getMonitoringName() {
        return "AcceptedConnections";
    }

    public SelectableChannel getChannel() {
        return this.serverSocketChannel;
    }

    public int getInterestOps() {
        return 16;
    }

    public Acceptor getAcceptor() {
        return this;
    }

    public Connection getConnection() {
        throw new RuntimeException("Should not happen.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork() {
        block17: {
            try {
                block16: {
                    try {
                        if (this.orb.transportDebugFlag) {
                            this.dprint(".doWork->: " + this);
                        }
                        if (this.selectionKey.isAcceptable()) {
                            AccessController.doPrivileged(new PrivilegedAction(){

                                public Object run() {
                                    SocketOrChannelAcceptorImpl.this.accept();
                                    return null;
                                }
                            });
                            break block16;
                        }
                        if (!this.orb.transportDebugFlag) break block16;
                        this.dprint(".doWork: ! selectionKey.isAcceptable: " + this);
                    }
                    catch (SecurityException securityException) {
                        if (this.orb.transportDebugFlag) {
                            this.dprint(".doWork: ignoring SecurityException: " + securityException + " " + this);
                        }
                        String string = ORBUtility.getClassSecurityInfo(this.getClass());
                        this.wrapper.securityExceptionInAccept(securityException, string);
                        Object var4_2 = null;
                        Selector selector = this.orb.getTransportManager().getSelector(0);
                        selector.registerInterestOps(this);
                        if (this.orb.transportDebugFlag) {
                            this.dprint(".doWork<-:" + this);
                        }
                        break block17;
                    }
                    catch (Exception exception) {
                        if (this.orb.transportDebugFlag) {
                            this.dprint(".doWork: ignoring Exception: " + exception + " " + this);
                        }
                        this.wrapper.exceptionInAccept(exception);
                        Object var4_3 = null;
                        Selector selector = this.orb.getTransportManager().getSelector(0);
                        selector.registerInterestOps(this);
                        if (this.orb.transportDebugFlag) {
                            this.dprint(".doWork<-:" + this);
                        }
                        break block17;
                    }
                    catch (Throwable throwable) {
                        if (this.orb.transportDebugFlag) {
                            this.dprint(".doWork: ignoring Throwable: " + throwable + " " + this);
                        }
                        Object var4_4 = null;
                        Selector selector = this.orb.getTransportManager().getSelector(0);
                        selector.registerInterestOps(this);
                        if (this.orb.transportDebugFlag) {
                            this.dprint(".doWork<-:" + this);
                        }
                    }
                }
                Object var4_1 = null;
                Selector selector = this.orb.getTransportManager().getSelector(0);
                selector.registerInterestOps(this);
                if (this.orb.transportDebugFlag) {
                    this.dprint(".doWork<-:" + this);
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                Selector selector = this.orb.getTransportManager().getSelector(0);
                selector.registerInterestOps(this);
                if (this.orb.transportDebugFlag) {
                    this.dprint(".doWork<-:" + this);
                }
                throw throwable;
            }
        }
    }

    public void setEnqueueTime(long l) {
        this.enqueueTime = l;
    }

    public long getEnqueueTime() {
        return this.enqueueTime;
    }

    public MessageMediator createMessageMediator(Broker broker, Connection connection) {
        SocketOrChannelContactInfoImpl socketOrChannelContactInfoImpl = new SocketOrChannelContactInfoImpl();
        return socketOrChannelContactInfoImpl.createMessageMediator(broker, connection);
    }

    public MessageMediator finishCreatingMessageMediator(Broker broker, Connection connection, MessageMediator messageMediator) {
        SocketOrChannelContactInfoImpl socketOrChannelContactInfoImpl = new SocketOrChannelContactInfoImpl();
        return socketOrChannelContactInfoImpl.finishCreatingMessageMediator(broker, connection, messageMediator);
    }

    public InputObject createInputObject(Broker broker, MessageMediator messageMediator) {
        CorbaMessageMediator corbaMessageMediator = (CorbaMessageMediator)messageMediator;
        return new CDRInputObject((ORB)broker, (CorbaConnection)messageMediator.getConnection(), corbaMessageMediator.getDispatchBuffer(), corbaMessageMediator.getDispatchHeader());
    }

    public OutputObject createOutputObject(Broker broker, MessageMediator messageMediator) {
        CorbaMessageMediator corbaMessageMediator = (CorbaMessageMediator)messageMediator;
        return new CDROutputObject((ORB)broker, corbaMessageMediator, corbaMessageMediator.getReplyHeader(), corbaMessageMediator.getStreamFormatVersion());
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public String toString() {
        String string = this.serverSocketChannel == null ? (this.serverSocket == null ? "(not initialized)" : this.serverSocket.toString()) : this.serverSocketChannel.toString();
        return this.toStringName() + "[" + string + " " + this.type + " " + this.shouldUseSelectThreadToWait() + " " + this.shouldUseWorkerThreadForEvent() + "]";
    }

    protected String toStringName() {
        return "SocketOrChannelAcceptorImpl";
    }

    protected void dprint(String string) {
        ORBUtility.dprint(this.toStringName(), string);
    }

    protected void dprint(String string, Throwable throwable) {
        this.dprint(string);
        throwable.printStackTrace(System.out);
    }

    public String getType() {
        return this.type;
    }

    public String getHostName() {
        return this.hostname;
    }

    public String getHost() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public int getLocatorPort() {
        return this.locatorPort;
    }

    public void setLocatorPort(int n) {
        this.locatorPort = n;
    }

    public String getName() {
        String string = this.name.equals("NO_NAME") ? this.toString() : this.name;
        return string;
    }
}

