/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.encoding.BufferManagerRead;
import com.sun.corba.ee.impl.encoding.CDRInputObject;
import com.sun.corba.ee.impl.encoding.CDRInputStream;
import com.sun.corba.ee.impl.oa.poa.Policies;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.FragmentMessage;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.Message;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.MessageBase;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.Message_1_2;
import com.sun.corba.ee.impl.transport.BufferConnectionImpl;
import com.sun.corba.ee.impl.transport.CorbaInboundConnectionCacheImpl;
import com.sun.corba.ee.impl.transport.CorbaOutboundConnectionCacheImpl;
import com.sun.corba.ee.impl.transport.MessageTraceManagerImpl;
import com.sun.corba.ee.impl.transport.SelectorImpl;
import com.sun.corba.ee.pept.transport.Acceptor;
import com.sun.corba.ee.pept.transport.ByteBufferPool;
import com.sun.corba.ee.pept.transport.ContactInfo;
import com.sun.corba.ee.pept.transport.InboundConnectionCache;
import com.sun.corba.ee.pept.transport.OutboundConnectionCache;
import com.sun.corba.ee.pept.transport.Selector;
import com.sun.corba.ee.spi.ior.IORTemplate;
import com.sun.corba.ee.spi.ior.ObjectAdapterId;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.transport.CorbaAcceptor;
import com.sun.corba.ee.spi.transport.CorbaTransportManager;
import com.sun.corba.ee.spi.transport.MessageData;
import com.sun.corba.ee.spi.transport.MessageTraceManager;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.omg.CORBA.portable.InputStream;

public class CorbaTransportManagerImpl
implements CorbaTransportManager {
    protected ORB orb;
    protected List acceptors;
    protected Map outboundConnectionCaches;
    protected Map inboundConnectionCaches;
    protected Selector selector;
    private ThreadLocal currentMessageTraceManager = new ThreadLocal(){

        public Object initialValue() {
            return new MessageTraceManagerImpl();
        }
    };

    public CorbaTransportManagerImpl(ORB oRB) {
        this.orb = oRB;
        this.acceptors = new ArrayList();
        this.outboundConnectionCaches = new HashMap();
        this.inboundConnectionCaches = new HashMap();
        this.selector = new SelectorImpl(oRB);
    }

    public ByteBufferPool getByteBufferPool(int n) {
        throw new RuntimeException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutboundConnectionCache getOutboundConnectionCache(ContactInfo contactInfo) {
        ContactInfo contactInfo2 = contactInfo;
        synchronized (contactInfo2) {
            if (contactInfo.getConnectionCache() == null) {
                OutboundConnectionCache outboundConnectionCache = null;
                Map map = this.outboundConnectionCaches;
                synchronized (map) {
                    outboundConnectionCache = (OutboundConnectionCache)this.outboundConnectionCaches.get(contactInfo.getConnectionCacheType());
                    if (outboundConnectionCache == null) {
                        outboundConnectionCache = new CorbaOutboundConnectionCacheImpl(this.orb, contactInfo);
                        this.outboundConnectionCaches.put(contactInfo.getConnectionCacheType(), outboundConnectionCache);
                    }
                }
                contactInfo.setConnectionCache(outboundConnectionCache);
            }
            return contactInfo.getConnectionCache();
        }
    }

    public Collection getOutboundConnectionCaches() {
        return this.outboundConnectionCaches.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InboundConnectionCache getInboundConnectionCache(Acceptor acceptor) {
        Acceptor acceptor2 = acceptor;
        synchronized (acceptor2) {
            if (acceptor.getConnectionCache() == null) {
                InboundConnectionCache inboundConnectionCache = null;
                Map map = this.inboundConnectionCaches;
                synchronized (map) {
                    inboundConnectionCache = (InboundConnectionCache)this.inboundConnectionCaches.get(acceptor.getConnectionCacheType());
                    if (inboundConnectionCache == null) {
                        inboundConnectionCache = new CorbaInboundConnectionCacheImpl(this.orb, acceptor);
                        this.inboundConnectionCaches.put(acceptor.getConnectionCacheType(), inboundConnectionCache);
                    }
                }
                acceptor.setConnectionCache(inboundConnectionCache);
            }
            return acceptor.getConnectionCache();
        }
    }

    public Collection getInboundConnectionCaches() {
        return this.inboundConnectionCaches.values();
    }

    public Selector getSelector(int n) {
        return this.selector;
    }

    public synchronized void registerAcceptor(Acceptor acceptor) {
        if (this.orb.transportDebugFlag) {
            this.dprint(".registerAcceptor->: " + acceptor);
        }
        this.acceptors.add(acceptor);
        if (this.orb.transportDebugFlag) {
            this.dprint(".registerAcceptor<-: " + acceptor);
        }
    }

    public Collection getAcceptors() {
        return this.getAcceptors(null, null);
    }

    public synchronized void unregisterAcceptor(Acceptor acceptor) {
        this.acceptors.remove(acceptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this.orb.transportDebugFlag) {
                this.dprint(".close->");
            }
            this.getSelector(0).close();
        }
        finally {
            if (this.orb.transportDebugFlag) {
                this.dprint(".close<-");
            }
        }
    }

    public Collection getAcceptors(String string, ObjectAdapterId objectAdapterId) {
        Iterator iterator = this.acceptors.iterator();
        while (iterator.hasNext()) {
            Acceptor acceptor = (Acceptor)iterator.next();
            if (!acceptor.initialize() || !acceptor.shouldRegisterAcceptEvent()) continue;
            this.orb.getTransportManager().getSelector(0).registerForEvent(acceptor.getEventHandler());
        }
        return this.acceptors;
    }

    public void addToIORTemplate(IORTemplate iORTemplate, Policies policies, String string, String string2, ObjectAdapterId objectAdapterId) {
        Iterator iterator = this.getAcceptors(string2, objectAdapterId).iterator();
        while (iterator.hasNext()) {
            CorbaAcceptor corbaAcceptor = (CorbaAcceptor)iterator.next();
            corbaAcceptor.addToIORTemplate(iORTemplate, policies, string);
        }
    }

    public Message getMessage(byte[] byArray) {
        BufferConnectionImpl bufferConnectionImpl = new BufferConnectionImpl(this.orb);
        ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length);
        byteBuffer.put(byArray);
        byteBuffer.position(0);
        try {
            bufferConnectionImpl.write(byteBuffer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        MessageBase messageBase = MessageBase.readGIOPMessage(this.orb, bufferConnectionImpl);
        if (messageBase.getGIOPVersion().equals(GIOPVersion.V1_2)) {
            ((Message_1_2)messageBase).unmarshalRequestID(messageBase.getByteBuffer());
        }
        return messageBase;
    }

    public MessageData getMessageData(byte[][] byArray) {
        Object object;
        BufferConnectionImpl bufferConnectionImpl = new BufferConnectionImpl(this.orb);
        for (int i = 0; i < byArray.length; ++i) {
            byte[] byArray2 = byArray[i];
            object = ByteBuffer.allocate(byArray2.length);
            ((ByteBuffer)object).put(byArray2);
            ((ByteBuffer)object).position(0);
            try {
                bufferConnectionImpl.write((ByteBuffer)object);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        final Message[] messageArray = new Message[byArray.length];
        boolean bl = false;
        object = null;
        MessageBase messageBase = null;
        CDRInputObject cDRInputObject = null;
        BufferManagerRead bufferManagerRead = null;
        for (int i = 0; i < byArray.length; ++i) {
            messageBase = MessageBase.readGIOPMessage(this.orb, bufferConnectionImpl);
            messageArray[i] = messageBase;
            if (messageBase.getGIOPVersion().equals(GIOPVersion.V1_2)) {
                ((Message_1_2)messageBase).unmarshalRequestID(messageBase.getByteBuffer());
            }
            if (i == 0) {
                object = messageBase;
                cDRInputObject = new CDRInputObject(this.orb, bufferConnectionImpl, messageBase.getByteBuffer(), messageBase);
                bufferManagerRead = cDRInputObject.getBufferManager();
                cDRInputObject.performORBVersionSpecificInit();
                continue;
            }
            bufferManagerRead.processFragment(messageBase.getByteBuffer(), (FragmentMessage)((Object)messageBase));
        }
        object.read((InputStream)cDRInputObject);
        final CDRInputObject cDRInputObject2 = cDRInputObject;
        return new MessageData(){

            public Message[] getMessages() {
                return messageArray;
            }

            public CDRInputStream getStream() {
                return cDRInputObject2;
            }
        };
    }

    public MessageTraceManager getMessageTraceManager() {
        return (MessageTraceManager)this.currentMessageTraceManager.get();
    }

    protected void dprint(String string) {
        ORBUtility.dprint("CorbaTransportManagerImpl", string);
    }
}

