/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.protocol.NotLocalLocalCRDImpl;
import com.sun.corba.ee.impl.transport.CorbaContactInfoListIteratorImpl;
import com.sun.corba.ee.impl.transport.SharedCDRContactInfoImpl;
import com.sun.corba.ee.impl.transport.SocketOrChannelContactInfoImpl;
import com.sun.corba.ee.pept.transport.ContactInfo;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfile;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.protocol.LocalClientRequestDispatcher;
import com.sun.corba.ee.spi.protocol.LocalClientRequestDispatcherFactory;
import com.sun.corba.ee.spi.transport.CorbaContactInfoList;
import com.sun.corba.ee.spi.transport.SocketInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CorbaContactInfoListImpl
implements CorbaContactInfoList {
    protected ORB orb;
    protected LocalClientRequestDispatcher LocalClientRequestDispatcher;
    protected IOR targetIOR;
    protected IOR effectiveTargetIOR;
    protected List effectiveTargetIORContactInfoList;
    protected boolean isCachedHashValue = false;
    protected int cachedHashValue;
    protected ContactInfo primaryContactInfo;

    public CorbaContactInfoListImpl(ORB oRB) {
        this.orb = oRB;
    }

    public CorbaContactInfoListImpl(ORB oRB, IOR iOR) {
        this(oRB);
        this.setTargetIOR(iOR);
    }

    public synchronized Iterator iterator() {
        this.createContactInfoList();
        return new CorbaContactInfoListIteratorImpl(this.orb, this, this.primaryContactInfo, this.effectiveTargetIORContactInfoList);
    }

    public synchronized void setTargetIOR(IOR iOR) {
        this.targetIOR = iOR;
        this.setEffectiveTargetIOR(iOR);
        this.isCachedHashValue = false;
    }

    public synchronized IOR getTargetIOR() {
        return this.targetIOR;
    }

    public synchronized void setEffectiveTargetIOR(IOR iOR) {
        this.effectiveTargetIOR = iOR;
        this.effectiveTargetIORContactInfoList = null;
        if (this.primaryContactInfo != null && this.orb.getORBData().getIIOPPrimaryToContactInfo() != null) {
            this.orb.getORBData().getIIOPPrimaryToContactInfo().reset(this.primaryContactInfo);
        }
        this.primaryContactInfo = null;
        this.setLocalSubcontract();
    }

    public synchronized IOR getEffectiveTargetIOR() {
        return this.effectiveTargetIOR;
    }

    public synchronized LocalClientRequestDispatcher getLocalClientRequestDispatcher() {
        return this.LocalClientRequestDispatcher;
    }

    public synchronized int hashCode() {
        if (!this.isCachedHashValue) {
            this.cachedHashValue = this.targetIOR.stringify().hashCode();
            this.isCachedHashValue = true;
        }
        return this.cachedHashValue;
    }

    protected void createContactInfoList() {
        IIOPProfile iIOPProfile = this.effectiveTargetIOR.getProfile();
        if (this.effectiveTargetIORContactInfoList == null) {
            this.effectiveTargetIORContactInfoList = new ArrayList();
            String string = ((IIOPProfileTemplate)iIOPProfile.getTaggedProfileTemplate()).getPrimaryAddress().getHost().toLowerCase();
            int n = ((IIOPProfileTemplate)iIOPProfile.getTaggedProfileTemplate()).getPrimaryAddress().getPort();
            this.primaryContactInfo = this.createContactInfo("IIOP_CLEAR_TEXT", string, n);
            if (iIOPProfile.isLocal()) {
                SharedCDRContactInfoImpl sharedCDRContactInfoImpl = new SharedCDRContactInfoImpl(this.orb, this, this.effectiveTargetIOR, this.orb.getORBData().getGIOPAddressDisposition());
                this.effectiveTargetIORContactInfoList.add(sharedCDRContactInfoImpl);
            } else {
                this.addRemoteContactInfos(this.effectiveTargetIOR, this.effectiveTargetIORContactInfoList);
            }
            if (this.orb.transportDebugFlag) {
                this.dprint(".createContactInfoList: first time for: " + iIOPProfile + " list: " + this.effectiveTargetIORContactInfoList);
            }
        } else if (!iIOPProfile.isLocal()) {
            this.addRemoteContactInfos(this.effectiveTargetIOR, this.effectiveTargetIORContactInfoList);
        } else if (this.orb.transportDebugFlag) {
            this.dprint(".createContactInfoList: subsequent for: " + iIOPProfile + " colocated so no change");
        }
    }

    protected void addRemoteContactInfos(IOR iOR, List list) {
        List list2 = this.orb.getORBData().getIORToSocketInfo().getSocketInfo(iOR, list);
        if (list2 == list) {
            if (this.orb.transportDebugFlag) {
                this.dprint(".addRemoteContactInfos: no change: " + list2);
            }
            return;
        }
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            SocketInfo socketInfo = (SocketInfo)iterator.next();
            String string = socketInfo.getType();
            String string2 = socketInfo.getHost().toLowerCase();
            int n = socketInfo.getPort();
            ContactInfo contactInfo = this.createContactInfo(string, string2, n);
            list.add(contactInfo);
        }
    }

    protected ContactInfo createContactInfo(String string, String string2, int n) {
        return new SocketOrChannelContactInfoImpl(this.orb, this, this.effectiveTargetIOR, this.orb.getORBData().getGIOPAddressDisposition(), string, string2, n);
    }

    protected void setLocalSubcontract() {
        if (!this.effectiveTargetIOR.getProfile().isLocal()) {
            this.LocalClientRequestDispatcher = new NotLocalLocalCRDImpl();
            return;
        }
        int n = this.effectiveTargetIOR.getProfile().getObjectKeyTemplate().getSubcontractId();
        LocalClientRequestDispatcherFactory localClientRequestDispatcherFactory = this.orb.getRequestDispatcherRegistry().getLocalClientRequestDispatcherFactory(n);
        this.LocalClientRequestDispatcher = localClientRequestDispatcherFactory.create(n, this.effectiveTargetIOR);
    }

    protected void dprint(String string) {
        ORBUtility.dprint("CorbaContactInfoListImpl", string);
    }
}

