/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orbutil.concurrent;

import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.orbutil.concurrent.ReentrantMutex;
import com.sun.corba.ee.impl.orbutil.concurrent.Sync;

public class CondVar {
    protected boolean debug_;
    protected final Sync mutex_;
    protected final ReentrantMutex remutex_;

    private int releaseMutex() {
        int n = 1;
        if (this.remutex_ != null) {
            n = this.remutex_.releaseAll();
        } else {
            this.mutex_.release();
        }
        return n;
    }

    private void acquireMutex(int n) throws InterruptedException {
        if (this.remutex_ != null) {
            this.remutex_.acquireAll(n);
        } else {
            this.mutex_.acquire();
        }
    }

    public CondVar(Sync sync, boolean bl) {
        this.debug_ = bl;
        this.mutex_ = sync;
        this.remutex_ = sync instanceof ReentrantMutex ? (ReentrantMutex)sync : null;
    }

    public CondVar(Sync sync) {
        this(sync, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await() throws InterruptedException {
        boolean bl;
        int n = 0;
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        try {
            if (this.debug_) {
                ORBUtility.dprintTrace(this, "await enter");
            }
            CondVar condVar = this;
            synchronized (condVar) {
                n = this.releaseMutex();
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    this.notify();
                    throw interruptedException;
                }
            }
            Object var6_5 = null;
            bl = false;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            boolean bl2 = false;
            while (true) {
                try {
                    this.acquireMutex(n);
                }
                catch (InterruptedException interruptedException) {
                    bl2 = true;
                    continue;
                }
                break;
            }
            if (bl2) {
                Thread.currentThread().interrupt();
            }
            if (this.debug_) {
                ORBUtility.dprintTrace(this, "await exit");
            }
            throw throwable;
        }
        while (true) {
            try {
                this.acquireMutex(n);
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                continue;
            }
            break;
        }
        if (bl) {
            Thread.currentThread().interrupt();
        }
        if (this.debug_) {
            ORBUtility.dprintTrace(this, "await exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean timedwait(long l) throws InterruptedException {
        boolean bl;
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        boolean bl2 = false;
        int n = 0;
        try {
            if (this.debug_) {
                ORBUtility.dprintTrace(this, "timedwait enter");
            }
            CondVar condVar = this;
            synchronized (condVar) {
                n = this.releaseMutex();
                try {
                    if (l > 0L) {
                        long l2 = System.currentTimeMillis();
                        this.wait(l);
                        bl2 = System.currentTimeMillis() - l2 <= l;
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.notify();
                    throw interruptedException;
                }
            }
            Object var10_8 = null;
            bl = false;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            boolean bl3 = false;
            while (true) {
                try {
                    this.acquireMutex(n);
                }
                catch (InterruptedException interruptedException) {
                    bl3 = true;
                    continue;
                }
                break;
            }
            if (bl3) {
                Thread.currentThread().interrupt();
            }
            if (this.debug_) {
                ORBUtility.dprintTrace(this, "timedwait exit");
            }
            throw throwable;
        }
        while (true) {
            try {
                this.acquireMutex(n);
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                continue;
            }
            break;
        }
        if (bl) {
            Thread.currentThread().interrupt();
        }
        if (this.debug_) {
            ORBUtility.dprintTrace(this, "timedwait exit");
        }
        return bl2;
    }

    public synchronized void signal() {
        this.notify();
    }

    public synchronized void broadcast() {
        this.notifyAll();
    }
}

