/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.oa.poa;

import com.sun.corba.ee.impl.ior.ObjectAdapterIdArray;
import com.sun.corba.ee.impl.ior.POAObjectKeyTemplate;
import com.sun.corba.ee.impl.oa.poa.IdAssignmentPolicyImpl;
import com.sun.corba.ee.impl.oa.poa.IdUniquenessPolicyImpl;
import com.sun.corba.ee.impl.oa.poa.ImplicitActivationPolicyImpl;
import com.sun.corba.ee.impl.oa.poa.LifespanPolicyImpl;
import com.sun.corba.ee.impl.oa.poa.POAFactory;
import com.sun.corba.ee.impl.oa.poa.POAManagerImpl;
import com.sun.corba.ee.impl.oa.poa.POAPolicyMediator;
import com.sun.corba.ee.impl.oa.poa.POAPolicyMediatorFactory;
import com.sun.corba.ee.impl.oa.poa.Policies;
import com.sun.corba.ee.impl.oa.poa.RequestProcessingPolicyImpl;
import com.sun.corba.ee.impl.oa.poa.ServantRetentionPolicyImpl;
import com.sun.corba.ee.impl.oa.poa.ThreadPolicyImpl;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.orbutil.concurrent.CondVar;
import com.sun.corba.ee.impl.orbutil.concurrent.ReentrantMutex;
import com.sun.corba.ee.impl.orbutil.concurrent.Sync;
import com.sun.corba.ee.impl.orbutil.concurrent.SyncUtil;
import com.sun.corba.ee.spi.copyobject.CopierManager;
import com.sun.corba.ee.spi.copyobject.ObjectCopierFactory;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.IORFactories;
import com.sun.corba.ee.spi.ior.IORTemplateList;
import com.sun.corba.ee.spi.ior.ObjectAdapterId;
import com.sun.corba.ee.spi.ior.ObjectId;
import com.sun.corba.ee.spi.ior.TaggedProfile;
import com.sun.corba.ee.spi.oa.OADestroyed;
import com.sun.corba.ee.spi.oa.OAInvocationInfo;
import com.sun.corba.ee.spi.oa.ObjectAdapterBase;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.protocol.ForwardException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.PortableInterceptor.ObjectReferenceFactory;
import org.omg.PortableInterceptor.ObjectReferenceTemplate;
import org.omg.PortableServer.AdapterActivator;
import org.omg.PortableServer.ForwardRequest;
import org.omg.PortableServer.IdAssignmentPolicy;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicy;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.ImplicitActivationPolicy;
import org.omg.PortableServer.ImplicitActivationPolicyValue;
import org.omg.PortableServer.LifespanPolicy;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.AdapterNonExistent;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.POAPackage.NoServant;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongAdapter;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.RequestProcessingPolicy;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantManager;
import org.omg.PortableServer.ServantRetentionPolicy;
import org.omg.PortableServer.ServantRetentionPolicyValue;
import org.omg.PortableServer.ThreadPolicy;
import org.omg.PortableServer.ThreadPolicyValue;

public class POAImpl
extends ObjectAdapterBase
implements POA {
    private boolean debug;
    private static final int STATE_START = 0;
    private static final int STATE_INIT = 1;
    private static final int STATE_INIT_DONE = 2;
    private static final int STATE_RUN = 3;
    private static final int STATE_DESTROYING = 4;
    private static final int STATE_DESTROYED = 5;
    private int state;
    private POAPolicyMediator mediator;
    private int numLevels;
    private ObjectAdapterId poaId;
    private String name;
    private POAManagerImpl manager;
    private int uniquePOAId;
    private POAImpl parent;
    private Map children;
    private AdapterActivator activator;
    private int invocationCount;
    Sync poaMutex;
    private CondVar adapterActivatorCV;
    private CondVar invokeCV;
    private CondVar beingDestroyedCV;
    protected ThreadLocal isDestroying;

    private String stateToString() {
        switch (this.state) {
            case 0: {
                return "START";
            }
            case 1: {
                return "INIT";
            }
            case 2: {
                return "INIT_DONE";
            }
            case 3: {
                return "RUN";
            }
            case 4: {
                return "DESTROYING";
            }
            case 5: {
                return "DESTROYED";
            }
        }
        return "UNKNOWN(" + this.state + ")";
    }

    public String toString() {
        return "POA[" + this.poaId.toString() + ", uniquePOAId=" + this.uniquePOAId + ", state=" + this.stateToString() + ", invocationCount=" + this.invocationCount + "]";
    }

    boolean getDebug() {
        return this.debug;
    }

    static POAFactory getPOAFactory(ORB oRB) {
        return (POAFactory)oRB.getRequestDispatcherRegistry().getObjectAdapterFactory(32);
    }

    static POAImpl makeRootPOA(ORB oRB) {
        POAManagerImpl pOAManagerImpl = new POAManagerImpl(POAImpl.getPOAFactory(oRB), oRB.getPIHandler());
        POAImpl pOAImpl = new POAImpl("RootPOA", null, oRB, 0);
        pOAImpl.initialize(pOAManagerImpl, Policies.rootPOAPolicies);
        return pOAImpl;
    }

    int getPOAId() {
        return this.uniquePOAId;
    }

    void lock() {
        SyncUtil.acquire(this.poaMutex);
        if (this.debug) {
            ORBUtility.dprint(this, "LOCKED poa " + this);
        }
    }

    void unlock() {
        if (this.debug) {
            ORBUtility.dprint(this, "UNLOCKED poa " + this);
        }
        this.poaMutex.release();
    }

    Policies getPolicies() {
        return this.mediator.getPolicies();
    }

    private POAImpl(String string, POAImpl pOAImpl, ORB oRB, int n) {
        super(oRB);
        this.debug = oRB.poaDebugFlag;
        if (this.debug) {
            ORBUtility.dprint(this, "Creating POA with name=" + string + " parent=" + pOAImpl);
        }
        this.state = n;
        this.name = string;
        this.parent = pOAImpl;
        this.children = new HashMap();
        this.activator = null;
        this.uniquePOAId = POAImpl.getPOAFactory(oRB).newPOAId();
        if (pOAImpl == null) {
            this.numLevels = 1;
        } else {
            this.numLevels = pOAImpl.numLevels + 1;
            pOAImpl.children.put(string, this);
        }
        String[] stringArray = new String[this.numLevels];
        POAImpl pOAImpl2 = this;
        int n2 = this.numLevels - 1;
        while (pOAImpl2 != null) {
            stringArray[n2--] = pOAImpl2.name;
            pOAImpl2 = pOAImpl2.parent;
        }
        this.poaId = new ObjectAdapterIdArray(stringArray);
        this.invocationCount = 0;
        this.poaMutex = new ReentrantMutex(oRB.poaConcurrencyDebugFlag);
        this.adapterActivatorCV = new CondVar(this.poaMutex, oRB.poaConcurrencyDebugFlag);
        this.invokeCV = new CondVar(this.poaMutex, oRB.poaConcurrencyDebugFlag);
        this.beingDestroyedCV = new CondVar(this.poaMutex, oRB.poaConcurrencyDebugFlag);
        this.isDestroying = new ThreadLocal(){

            protected java.lang.Object initialValue() {
                return Boolean.FALSE;
            }
        };
    }

    private void initialize(POAManagerImpl pOAManagerImpl, Policies policies) {
        if (this.debug) {
            ORBUtility.dprint(this, "Initializing poa " + this + " with POAManager=" + (java.lang.Object)((java.lang.Object)pOAManagerImpl) + " policies=" + policies);
        }
        this.manager = pOAManagerImpl;
        pOAManagerImpl.addPOA(this);
        this.mediator = POAPolicyMediatorFactory.create(policies, this);
        int n = this.mediator.getServerId();
        int n2 = this.mediator.getScid();
        String string = this.getORB().getORBData().getORBId();
        POAObjectKeyTemplate pOAObjectKeyTemplate = new POAObjectKeyTemplate(this.getORB(), n2, n, string, this.poaId);
        if (this.debug) {
            ORBUtility.dprint(this, "Initializing poa: oktemp=" + pOAObjectKeyTemplate);
            ORBUtility.dprint(this, "oktemp data: scid: " + n2 + " serverid: " + n + " orbId: " + string + " poaId: " + this.poaId);
        }
        boolean bl = true;
        this.initializeTemplate(pOAObjectKeyTemplate, bl, policies, null, null, pOAObjectKeyTemplate.getObjectAdapterId());
        if (this.state == 0) {
            this.state = 3;
        } else if (this.state == 1) {
            this.state = 2;
        } else {
            throw this.lifecycleWrapper().illegalPoaStateTrans();
        }
    }

    private boolean waitUntilRunning() {
        if (this.debug) {
            ORBUtility.dprint(this, "Calling waitUntilRunning on poa " + this);
        }
        while (this.state < 3) {
            try {
                this.adapterActivatorCV.await();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.debug) {
            ORBUtility.dprint(this, "Exiting waitUntilRunning on poa " + this);
        }
        return this.state == 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean destroyIfNotInitDone() {
        boolean bl;
        block6: {
            try {
                boolean bl2;
                this.lock();
                if (this.debug) {
                    ORBUtility.dprint(this, "Calling destroyIfNotInitDone on poa " + this);
                }
                boolean bl3 = bl2 = this.state == 2;
                if (bl2) {
                    this.state = 3;
                } else {
                    DestroyThread destroyThread = new DestroyThread(false, this.debug);
                    destroyThread.doIt(this, true);
                }
                bl = bl2;
                java.lang.Object var4_4 = null;
                this.adapterActivatorCV.broadcast();
                if (!this.debug) break block6;
            }
            catch (Throwable throwable) {
                java.lang.Object var4_5 = null;
                this.adapterActivatorCV.broadcast();
                if (this.debug) {
                    ORBUtility.dprint(this, "Exiting destroyIfNotInitDone on poa " + this);
                }
                this.unlock();
                throw throwable;
            }
            ORBUtility.dprint(this, "Exiting destroyIfNotInitDone on poa " + this);
        }
        this.unlock();
        return bl;
    }

    private byte[] internalReferenceToId(Object object) throws WrongAdapter {
        IOR iOR = ORBUtility.getIOR(object);
        IORTemplateList iORTemplateList = iOR.getIORTemplates();
        ObjectReferenceFactory objectReferenceFactory = this.getCurrentFactory();
        IORTemplateList iORTemplateList2 = IORFactories.getIORTemplateList(objectReferenceFactory);
        if (!iORTemplateList2.isEquivalent(iORTemplateList)) {
            throw new WrongAdapter();
        }
        Iterator iterator = iOR.iterator();
        if (!iterator.hasNext()) {
            throw this.iorWrapper().noProfilesInIor();
        }
        TaggedProfile taggedProfile = (TaggedProfile)iterator.next();
        ObjectId objectId = taggedProfile.getObjectId();
        return objectId.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void etherealizeAll() {
        block4: {
            try {
                this.lock();
                if (this.debug) {
                    ORBUtility.dprint(this, "Calling etheralizeAll on poa " + this);
                }
                this.mediator.etherealizeAll();
                java.lang.Object var2_1 = null;
                if (!this.debug) break block4;
            }
            catch (Throwable throwable) {
                java.lang.Object var2_2 = null;
                if (this.debug) {
                    ORBUtility.dprint(this, "Exiting etheralizeAll on poa " + this);
                }
                this.unlock();
                throw throwable;
            }
            ORBUtility.dprint(this, "Exiting etheralizeAll on poa " + this);
        }
        this.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public POA create_POA(String string, POAManager pOAManager, Policy[] policyArray) throws AdapterAlreadyExists, InvalidPolicy {
        try {
            this.lock();
            if (this.debug) {
                ORBUtility.dprint(this, "Calling create_POA(name=" + string + " theManager=" + pOAManager + " policies=" + policyArray + ") on poa " + this);
            }
            if (this.state > 3) {
                throw this.omgLifecycleWrapper().createPoaDestroy();
            }
            POAImpl pOAImpl = (POAImpl)this.children.get(string);
            if (pOAImpl == null) {
                pOAImpl = new POAImpl(string, this, this.getORB(), 0);
            }
            try {
                pOAImpl.lock();
                if (this.debug) {
                    ORBUtility.dprint(this, "Calling create_POA: new poa is " + pOAImpl);
                }
                if (pOAImpl.state != 0 && pOAImpl.state != 1) {
                    throw new AdapterAlreadyExists();
                }
                POAManagerImpl pOAManagerImpl = (POAManagerImpl)pOAManager;
                if (pOAManagerImpl == null) {
                    pOAManagerImpl = new POAManagerImpl(this.manager.getFactory(), this.manager.getPIHandler());
                }
                int n = this.getORB().getCopierManager().getDefaultId();
                Policies policies = new Policies(policyArray, n);
                pOAImpl.initialize(pOAManagerImpl, policies);
                POAImpl pOAImpl2 = pOAImpl;
                pOAImpl.unlock();
                return pOAImpl2;
            }
            catch (Throwable throwable) {
                pOAImpl.unlock();
                throw throwable;
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public POA find_POA(String string, boolean bl) throws AdapterNonExistent {
        AdapterActivator adapterActivator;
        POAImpl pOAImpl;
        block29: {
            pOAImpl = null;
            adapterActivator = null;
            this.lock();
            if (this.debug) {
                ORBUtility.dprint(this, "Calling find_POA(name=" + string + " activate=" + bl + ") on poa " + this);
            }
            if ((pOAImpl = (POAImpl)this.children.get(string)) != null) {
                if (this.debug) {
                    ORBUtility.dprint(this, "Calling find_POA: found poa " + pOAImpl);
                }
                try {
                    pOAImpl.lock();
                    this.unlock();
                    if (!pOAImpl.waitUntilRunning()) {
                        throw this.omgLifecycleWrapper().poaDestroyed();
                    }
                    break block29;
                }
                finally {
                    pOAImpl.unlock();
                }
            }
            try {
                if (this.debug) {
                    ORBUtility.dprint(this, "Calling find_POA: no poa found");
                }
                if (bl && this.activator != null) {
                    pOAImpl = new POAImpl(string, this, this.getORB(), 1);
                    if (this.debug) {
                        ORBUtility.dprint(this, "Calling find_POA: created poa " + pOAImpl);
                    }
                    adapterActivator = this.activator;
                    break block29;
                }
                throw new AdapterNonExistent();
            }
            finally {
                this.unlock();
            }
        }
        if (adapterActivator != null) {
            boolean bl2 = false;
            boolean bl3 = false;
            if (this.debug) {
                ORBUtility.dprint(this, "Calling find_POA: calling AdapterActivator");
            }
            try {
                AdapterActivator adapterActivator2 = adapterActivator;
                synchronized (adapterActivator2) {
                    bl2 = adapterActivator.unknown_adapter((POA)this, string);
                }
            }
            catch (SystemException systemException) {
                throw this.omgLifecycleWrapper().adapterActivatorException(systemException, (java.lang.Object)string, (java.lang.Object)this.poaId.toString());
            }
            catch (Throwable throwable) {
                this.lifecycleWrapper().unexpectedException(throwable, (java.lang.Object)this.toString());
                if (throwable instanceof ThreadDeath) {
                    throw (ThreadDeath)throwable;
                }
            }
            finally {
                bl3 = pOAImpl.destroyIfNotInitDone();
            }
            if (bl2) {
                if (!bl3) {
                    throw this.omgLifecycleWrapper().adapterActivatorException(string, this.poaId.toString());
                }
            } else {
                if (this.debug) {
                    ORBUtility.dprint(this, "Calling find_POA: AdapterActivator returned false");
                }
                throw new AdapterNonExistent();
            }
        }
        return pOAImpl;
    }

    public void destroy(boolean bl, boolean bl2) {
        if (bl2 && this.getORB().isDuringDispatch()) {
            throw this.lifecycleWrapper().destroyDeadlock();
        }
        DestroyThread destroyThread = new DestroyThread(bl, this.debug);
        destroyThread.doIt(this, bl2);
    }

    public ThreadPolicy create_thread_policy(ThreadPolicyValue threadPolicyValue) {
        return new ThreadPolicyImpl(threadPolicyValue);
    }

    public LifespanPolicy create_lifespan_policy(LifespanPolicyValue lifespanPolicyValue) {
        return new LifespanPolicyImpl(lifespanPolicyValue);
    }

    public IdUniquenessPolicy create_id_uniqueness_policy(IdUniquenessPolicyValue idUniquenessPolicyValue) {
        return new IdUniquenessPolicyImpl(idUniquenessPolicyValue);
    }

    public IdAssignmentPolicy create_id_assignment_policy(IdAssignmentPolicyValue idAssignmentPolicyValue) {
        return new IdAssignmentPolicyImpl(idAssignmentPolicyValue);
    }

    public ImplicitActivationPolicy create_implicit_activation_policy(ImplicitActivationPolicyValue implicitActivationPolicyValue) {
        return new ImplicitActivationPolicyImpl(implicitActivationPolicyValue);
    }

    public ServantRetentionPolicy create_servant_retention_policy(ServantRetentionPolicyValue servantRetentionPolicyValue) {
        return new ServantRetentionPolicyImpl(servantRetentionPolicyValue);
    }

    public RequestProcessingPolicy create_request_processing_policy(RequestProcessingPolicyValue requestProcessingPolicyValue) {
        return new RequestProcessingPolicyImpl(requestProcessingPolicyValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String the_name() {
        try {
            this.lock();
            String string = this.name;
            return string;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public POA the_parent() {
        try {
            this.lock();
            POAImpl pOAImpl = this.parent;
            return pOAImpl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public POA[] the_children() {
        try {
            POA pOA;
            this.lock();
            Collection collection = this.children.values();
            int n = collection.size();
            POA pOA2 = new POA[n];
            int n2 = 0;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                pOA = (POA)iterator.next();
                pOA2[n2++] = pOA;
            }
            pOA = pOA2;
            return pOA;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public POAManager the_POAManager() {
        try {
            this.lock();
            POAManagerImpl pOAManagerImpl = this.manager;
            return pOAManagerImpl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdapterActivator the_activator() {
        try {
            this.lock();
            AdapterActivator adapterActivator = this.activator;
            return adapterActivator;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void the_activator(AdapterActivator adapterActivator) {
        try {
            this.lock();
            if (this.debug) {
                ORBUtility.dprint(this, "Calling the_activator on poa " + this + " activator=" + adapterActivator);
            }
            this.activator = adapterActivator;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServantManager get_servant_manager() throws WrongPolicy {
        try {
            this.lock();
            ServantManager servantManager = this.mediator.getServantManager();
            return servantManager;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set_servant_manager(ServantManager servantManager) throws WrongPolicy {
        try {
            this.lock();
            if (this.debug) {
                ORBUtility.dprint(this, "Calling set_servant_manager on poa " + this + " servantManager=" + servantManager);
            }
            this.mediator.setServantManager(servantManager);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Servant get_servant() throws NoServant, WrongPolicy {
        try {
            this.lock();
            Servant servant = this.mediator.getDefaultServant();
            return servant;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set_servant(Servant servant) throws WrongPolicy {
        try {
            this.lock();
            if (this.debug) {
                ORBUtility.dprint(this, "Calling set_servant on poa " + this + " defaultServant=" + servant);
            }
            this.mediator.setDefaultServant(servant);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] activate_object(Servant servant) throws ServantAlreadyActive, WrongPolicy {
        byte[] byArray;
        block6: {
            try {
                this.lock();
                if (this.debug) {
                    ORBUtility.dprint(this, "Calling activate_object on poa " + this + " (servant=" + servant + ")");
                }
                byte[] byArray2 = this.mediator.newSystemId();
                try {
                    this.mediator.activateObject(byArray2, servant);
                }
                catch (ObjectAlreadyActive objectAlreadyActive) {
                    // empty catch block
                }
                byArray = byArray2;
                java.lang.Object var5_5 = null;
                if (!this.debug) break block6;
            }
            catch (Throwable throwable) {
                java.lang.Object var5_6 = null;
                if (this.debug) {
                    ORBUtility.dprint(this, "Exiting activate_object on poa " + this);
                }
                this.unlock();
                throw throwable;
            }
            ORBUtility.dprint(this, "Exiting activate_object on poa " + this);
        }
        this.unlock();
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void activate_object_with_id(byte[] byArray, Servant servant) throws ObjectAlreadyActive, ServantAlreadyActive, WrongPolicy {
        block4: {
            try {
                this.lock();
                if (this.debug) {
                    ORBUtility.dprint(this, "Calling activate_object_with_id on poa " + this + " (servant=" + servant + " id=" + byArray + ")");
                }
                byte[] byArray2 = (byte[])byArray.clone();
                this.mediator.activateObject(byArray2, servant);
                java.lang.Object var5_4 = null;
                if (!this.debug) break block4;
            }
            catch (Throwable throwable) {
                java.lang.Object var5_5 = null;
                if (this.debug) {
                    ORBUtility.dprint(this, "Exiting activate_object_with_id on poa " + this);
                }
                this.unlock();
                throw throwable;
            }
            ORBUtility.dprint(this, "Exiting activate_object_with_id on poa " + this);
        }
        this.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deactivate_object(byte[] byArray) throws ObjectNotActive, WrongPolicy {
        block4: {
            try {
                this.lock();
                if (this.debug) {
                    ORBUtility.dprint(this, "Calling deactivate_object on poa " + this + " (id=" + byArray + ")");
                }
                this.mediator.deactivateObject(byArray);
                java.lang.Object var3_2 = null;
                if (!this.debug) break block4;
            }
            catch (Throwable throwable) {
                java.lang.Object var3_3 = null;
                if (this.debug) {
                    ORBUtility.dprint(this, "Exiting deactivate_object on poa " + this);
                }
                this.unlock();
                throw throwable;
            }
            ORBUtility.dprint(this, "Exiting deactivate_object on poa " + this);
        }
        this.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object create_reference(String string) throws WrongPolicy {
        try {
            this.lock();
            if (this.debug) {
                ORBUtility.dprint(this, "Calling create_reference(repId=" + string + ") on poa " + this);
            }
            Object object = this.makeObject(string, this.mediator.newSystemId());
            return object;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object create_reference_with_id(byte[] byArray, String string) {
        try {
            this.lock();
            if (this.debug) {
                ORBUtility.dprint(this, "Calling create_reference_with_id(oid=" + byArray + " repId=" + string + ") on poa " + this);
            }
            byte[] byArray2 = (byte[])byArray.clone();
            Object object = this.makeObject(string, byArray2);
            return object;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] servant_to_id(Servant servant) throws ServantNotActive, WrongPolicy {
        try {
            this.lock();
            if (this.debug) {
                ORBUtility.dprint(this, "Calling servant_to_id(servant=" + servant + ") on poa " + this);
            }
            byte[] byArray = this.mediator.servantToId(servant);
            return byArray;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object servant_to_reference(Servant servant) throws ServantNotActive, WrongPolicy {
        try {
            this.lock();
            if (this.debug) {
                ORBUtility.dprint(this, "Calling servant_to_reference(servant=" + servant + ") on poa " + this);
            }
            byte[] byArray = this.mediator.servantToId(servant);
            String string = servant._all_interfaces((POA)this, byArray)[0];
            Object object = this.create_reference_with_id(byArray, string);
            return object;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Servant reference_to_servant(Object object) throws ObjectNotActive, WrongPolicy, WrongAdapter {
        try {
            this.lock();
            if (this.debug) {
                ORBUtility.dprint(this, "Calling reference_to_servant(reference=" + object + ") on poa " + this);
            }
            if (this.state >= 4) {
                throw this.lifecycleWrapper().adapterDestroyed();
            }
            byte[] byArray = this.internalReferenceToId(object);
            Servant servant = this.mediator.idToServant(byArray);
            return servant;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] reference_to_id(Object object) throws WrongAdapter, WrongPolicy {
        try {
            this.lock();
            if (this.debug) {
                ORBUtility.dprint(this, "Calling reference_to_id(reference=" + object + ") on poa " + this);
            }
            if (this.state >= 4) {
                throw this.lifecycleWrapper().adapterDestroyed();
            }
            byte[] byArray = this.internalReferenceToId(object);
            return byArray;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Servant id_to_servant(byte[] byArray) throws ObjectNotActive, WrongPolicy {
        try {
            this.lock();
            if (this.debug) {
                ORBUtility.dprint(this, "Calling id_to_servant(id=" + byArray + ") on poa " + this);
            }
            if (this.state >= 4) {
                throw this.lifecycleWrapper().adapterDestroyed();
            }
            Servant servant = this.mediator.idToServant(byArray);
            return servant;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object id_to_reference(byte[] byArray) throws ObjectNotActive, WrongPolicy {
        try {
            this.lock();
            if (this.debug) {
                ORBUtility.dprint(this, "Calling id_to_reference(id=" + byArray + ") on poa " + this);
            }
            if (this.state >= 4) {
                throw this.lifecycleWrapper().adapterDestroyed();
            }
            Servant servant = this.mediator.idToServant(byArray);
            String string = servant._all_interfaces((POA)this, byArray)[0];
            Object object = this.makeObject(string, byArray);
            return object;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] id() {
        try {
            this.lock();
            byte[] byArray = this.getAdapterId();
            return byArray;
        }
        finally {
            this.unlock();
        }
    }

    public Policy getEffectivePolicy(int n) {
        return this.mediator.getPolicies().get_effective_policy(n);
    }

    public int getManagerId() {
        return this.manager.getManagerId();
    }

    public short getState() {
        return this.manager.getORTState();
    }

    public String[] getInterfaces(java.lang.Object object, byte[] byArray) {
        Servant servant = (Servant)object;
        return servant._all_interfaces((POA)this, byArray);
    }

    protected ObjectCopierFactory getObjectCopierFactory() {
        int n = this.mediator.getPolicies().getCopierId();
        CopierManager copierManager = this.getORB().getCopierManager();
        return copierManager.getObjectCopierFactory(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void enter() throws OADestroyed {
        block8: {
            try {
                this.lock();
                if (this.debug) {
                    ORBUtility.dprint(this, "Calling enter on poa " + this);
                }
                while (this.state == 4 && this.isDestroying.get() == Boolean.FALSE) {
                    try {
                        this.beingDestroyedCV.await();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!this.waitUntilRunning()) {
                    throw new OADestroyed();
                }
                ++this.invocationCount;
                java.lang.Object var3_2 = null;
                if (!this.debug) break block8;
            }
            catch (Throwable throwable) {
                java.lang.Object var3_3 = null;
                if (this.debug) {
                    ORBUtility.dprint(this, "Exiting enter on poa " + this);
                }
                this.unlock();
                throw throwable;
            }
            ORBUtility.dprint(this, "Exiting enter on poa " + this);
        }
        this.unlock();
        this.manager.enter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exit() {
        block5: {
            try {
                this.lock();
                if (this.debug) {
                    ORBUtility.dprint(this, "Calling exit on poa " + this);
                }
                --this.invocationCount;
                if (this.invocationCount == 0 && this.state == 4) {
                    this.invokeCV.broadcast();
                }
                java.lang.Object var2_1 = null;
                if (!this.debug) break block5;
            }
            catch (Throwable throwable) {
                java.lang.Object var2_2 = null;
                if (this.debug) {
                    ORBUtility.dprint(this, "Exiting exit on poa " + this);
                }
                this.unlock();
                throw throwable;
            }
            ORBUtility.dprint(this, "Exiting exit on poa " + this);
        }
        this.unlock();
        this.manager.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getInvocationServant(OAInvocationInfo oAInvocationInfo) {
        block6: {
            try {
                this.lock();
                if (this.debug) {
                    ORBUtility.dprint(this, "Calling getInvocationServant on poa " + this);
                }
                java.lang.Object object = null;
                try {
                    object = this.mediator.getInvocationServant(oAInvocationInfo.id(), oAInvocationInfo.getOperation());
                }
                catch (ForwardRequest forwardRequest) {
                    throw new ForwardException(this.getORB(), forwardRequest.forward_reference);
                }
                oAInvocationInfo.setServant(object);
                java.lang.Object var5_4 = null;
                if (!this.debug) break block6;
            }
            catch (Throwable throwable) {
                java.lang.Object var5_5 = null;
                if (this.debug) {
                    ORBUtility.dprint(this, "Exiting getInvocationServant on poa " + this);
                }
                this.unlock();
                throw throwable;
            }
            ORBUtility.dprint(this, "Exiting getInvocationServant on poa " + this);
        }
        this.unlock();
    }

    public Object getLocalServant(byte[] byArray) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void returnServant() {
        block11: {
            try {
                try {
                    this.lock();
                    if (this.debug) {
                        ORBUtility.dprint(this, "Calling returnServant on poa " + this);
                    }
                    this.mediator.returnServant();
                }
                catch (Throwable throwable) {
                    if (this.debug) {
                        ORBUtility.dprint(this, "Exception " + throwable + " in returnServant on poa " + this);
                    }
                    if (throwable instanceof Error) {
                        throw (Error)throwable;
                    }
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable;
                    }
                    java.lang.Object var3_2 = null;
                    if (this.debug) {
                        ORBUtility.dprint(this, "Exiting returnServant on poa " + this);
                    }
                    this.unlock();
                    return;
                }
                java.lang.Object var3_1 = null;
                if (!this.debug) break block11;
            }
            catch (Throwable throwable) {
                java.lang.Object var3_3 = null;
                if (this.debug) {
                    ORBUtility.dprint(this, "Exiting returnServant on poa " + this);
                }
                this.unlock();
                throw throwable;
            }
            ORBUtility.dprint(this, "Exiting returnServant on poa " + this);
        }
        this.unlock();
    }

    static class DestroyThread
    extends Thread {
        private boolean wait;
        private boolean etherealize;
        private boolean debug;
        private POAImpl thePoa;

        public DestroyThread(boolean bl, boolean bl2) {
            this.etherealize = bl;
            this.debug = bl2;
        }

        public void doIt(POAImpl pOAImpl, boolean bl) {
            if (this.debug) {
                ORBUtility.dprint(this, "Calling DestroyThread.doIt(thePOA=" + pOAImpl + " wait=" + bl + " etherealize=" + this.etherealize);
            }
            this.thePoa = pOAImpl;
            this.wait = bl;
            if (bl) {
                this.run();
            } else {
                try {
                    this.setDaemon(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.start();
            }
        }

        public void run() {
            HashSet hashSet = new HashSet();
            this.performDestroy(this.thePoa, hashSet);
            Iterator iterator = hashSet.iterator();
            ObjectReferenceTemplate[] objectReferenceTemplateArray = new ObjectReferenceTemplate[hashSet.size()];
            int n = 0;
            while (iterator.hasNext()) {
                objectReferenceTemplateArray[n++] = (ObjectReferenceTemplate)iterator.next();
            }
            this.thePoa.getORB().getPIHandler().adapterStateChanged(objectReferenceTemplateArray, (short)4);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean prepareForDestruction(POAImpl pOAImpl, Set set) {
            POAImpl[] pOAImplArray = null;
            try {
                pOAImpl.lock();
                if (this.debug) {
                    ORBUtility.dprint(this, "Calling performDestroy on poa " + pOAImpl);
                }
                if (pOAImpl.state > 3) {
                    if (this.wait) {
                        while (pOAImpl.state != 5) {
                            try {
                                pOAImpl.beingDestroyedCV.await();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    boolean bl = false;
                    return bl;
                }
                pOAImpl.state = 4;
                pOAImpl.isDestroying.set(Boolean.TRUE);
                pOAImplArray = pOAImpl.children.values().toArray(new POAImpl[0]);
            }
            finally {
                pOAImpl.unlock();
            }
            for (int i = 0; i < pOAImplArray.length; ++i) {
                this.performDestroy(pOAImplArray[i], set);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void performDestroy(POAImpl pOAImpl, Set set) {
            block9: {
                if (!this.prepareForDestruction(pOAImpl, set)) {
                    return;
                }
                POAImpl pOAImpl2 = pOAImpl.parent;
                boolean bl = pOAImpl2 == null;
                try {
                    if (!bl) {
                        pOAImpl2.lock();
                    }
                    try {
                        pOAImpl.lock();
                        this.completeDestruction(pOAImpl, pOAImpl2, set);
                        java.lang.Object var6_5 = null;
                        pOAImpl.unlock();
                        if (bl) {
                            pOAImpl.manager.getFactory().registerRootPOA();
                        }
                    }
                    catch (Throwable throwable) {
                        java.lang.Object var6_6 = null;
                        pOAImpl.unlock();
                        if (bl) {
                            pOAImpl.manager.getFactory().registerRootPOA();
                        }
                        throw throwable;
                    }
                    java.lang.Object var8_8 = null;
                    if (bl) break block9;
                    pOAImpl2.unlock();
                }
                catch (Throwable throwable) {
                    java.lang.Object var8_9 = null;
                    if (!bl) {
                        pOAImpl2.unlock();
                        pOAImpl.parent = null;
                    }
                    throw throwable;
                }
                pOAImpl.parent = null;
                {
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void completeDestruction(POAImpl pOAImpl, POAImpl pOAImpl2, Set set) {
            if (this.debug) {
                ORBUtility.dprint(this, "Calling completeDestruction on poa " + pOAImpl);
            }
            try {
                try {}
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadDeath) {
                        throw (ThreadDeath)throwable;
                    }
                    pOAImpl.lifecycleWrapper().unexpectedException(throwable, (java.lang.Object)pOAImpl.toString());
                    java.lang.Object var6_7 = null;
                    pOAImpl.state = 5;
                    pOAImpl.beingDestroyedCV.broadcast();
                    pOAImpl.isDestroying.set(Boolean.FALSE);
                    if (!this.debug) return;
                    ORBUtility.dprint(this, "Exiting completeDestruction on poa " + pOAImpl);
                    return;
                }
            }
            catch (Throwable throwable) {
                java.lang.Object var6_8 = null;
                pOAImpl.state = 5;
                pOAImpl.beingDestroyedCV.broadcast();
                pOAImpl.isDestroying.set(Boolean.FALSE);
                if (!this.debug) throw throwable;
                ORBUtility.dprint(this, "Exiting completeDestruction on poa " + pOAImpl);
                throw throwable;
            }
            while (pOAImpl.invocationCount != 0) {
                try {
                    pOAImpl.invokeCV.await();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (pOAImpl.mediator != null) {
                if (this.etherealize) {
                    pOAImpl.mediator.etherealizeAll();
                }
                pOAImpl.mediator.clearAOM();
            }
            if (pOAImpl.manager != null) {
                pOAImpl.manager.removePOA(pOAImpl);
            }
            if (pOAImpl2 != null) {
                pOAImpl2.children.remove(pOAImpl.name);
            }
            set.add(pOAImpl.getAdapterTemplate());
            java.lang.Object var6_6 = null;
            pOAImpl.state = 5;
            pOAImpl.beingDestroyedCV.broadcast();
            pOAImpl.isDestroying.set(Boolean.FALSE);
            if (!this.debug) return;
            ORBUtility.dprint(this, "Exiting completeDestruction on poa " + pOAImpl);
        }
    }
}

