/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.ior;

import com.sun.corba.ee.impl.encoding.CDROutputStream;
import com.sun.corba.ee.impl.encoding.EncapsInputStream;
import com.sun.corba.ee.impl.encoding.EncapsOutputStream;
import com.sun.corba.ee.spi.ior.Identifiable;
import com.sun.corba.ee.spi.ior.IdentifiableFactoryFinder;
import com.sun.corba.ee.spi.ior.WriteContents;
import com.sun.corba.ee.spi.orb.ORB;
import java.util.Iterator;
import java.util.List;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public class EncapsulationUtility {
    private EncapsulationUtility() {
    }

    public static void readIdentifiableSequence(List list, IdentifiableFactoryFinder identifiableFactoryFinder, InputStream inputStream) {
        int n = inputStream.read_long();
        for (int i = 0; i < n; ++i) {
            int n2 = inputStream.read_long();
            Identifiable identifiable = identifiableFactoryFinder.create(n2, inputStream);
            list.add(identifiable);
        }
    }

    public static void writeIdentifiableSequence(List list, OutputStream outputStream) {
        outputStream.write_long(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Identifiable identifiable = (Identifiable)iterator.next();
            outputStream.write_long(identifiable.getId());
            identifiable.write(outputStream);
        }
    }

    public static void writeOutputStream(OutputStream outputStream, OutputStream outputStream2) {
        byte[] byArray = ((CDROutputStream)outputStream).toByteArray();
        outputStream2.write_long(byArray.length);
        outputStream2.write_octet_array(byArray, 0, byArray.length);
    }

    public static InputStream getEncapsulationStream(InputStream inputStream) {
        byte[] byArray = EncapsulationUtility.readOctets(inputStream);
        EncapsInputStream encapsInputStream = new EncapsInputStream(inputStream.orb(), byArray, byArray.length);
        encapsInputStream.consumeEndian();
        return encapsInputStream;
    }

    public static byte[] readOctets(InputStream inputStream) {
        int n = inputStream.read_ulong();
        byte[] byArray = new byte[n];
        inputStream.read_octet_array(byArray, 0, n);
        return byArray;
    }

    public static void writeEncapsulation(WriteContents writeContents, OutputStream outputStream) {
        EncapsOutputStream encapsOutputStream = new EncapsOutputStream((ORB)((Object)outputStream.orb()));
        encapsOutputStream.putEndian();
        writeContents.writeContents(encapsOutputStream);
        EncapsulationUtility.writeOutputStream(encapsOutputStream, outputStream);
    }
}

