/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.interceptors;

import com.sun.corba.ee.impl.interceptors.SlotTable;
import com.sun.corba.ee.impl.logging.InterceptorsSystemException;
import com.sun.corba.ee.spi.orb.ORB;
import java.util.ArrayList;
import java.util.List;

public class SlotTableStack {
    private List tableContainer;
    private int currentIndex;
    private SlotTablePool tablePool;
    private ORB orb;
    private InterceptorsSystemException wrapper;

    SlotTableStack(ORB oRB, SlotTable slotTable) {
        this.orb = oRB;
        this.wrapper = InterceptorsSystemException.get(oRB, "rpc.protocol");
        this.currentIndex = 0;
        this.tableContainer = new ArrayList();
        this.tablePool = new SlotTablePool();
        this.tableContainer.add(this.currentIndex, slotTable);
        ++this.currentIndex;
    }

    void pushSlotTable() {
        SlotTable slotTable = this.tablePool.getSlotTable();
        if (slotTable == null) {
            SlotTable slotTable2 = this.peekSlotTable();
            slotTable = new SlotTable(this.orb, slotTable2.getSize());
        }
        if (this.currentIndex == this.tableContainer.size()) {
            this.tableContainer.add(this.currentIndex, slotTable);
        } else {
            if (this.currentIndex > this.tableContainer.size()) {
                throw this.wrapper.slotTableInvariant(new Integer(this.currentIndex), new Integer(this.tableContainer.size()));
            }
            this.tableContainer.set(this.currentIndex, slotTable);
        }
        ++this.currentIndex;
    }

    void popSlotTable() {
        if (this.currentIndex <= 1) {
            throw this.wrapper.cantPopOnlyPicurrent();
        }
        --this.currentIndex;
        SlotTable slotTable = (SlotTable)this.tableContainer.get(this.currentIndex);
        this.tableContainer.set(this.currentIndex, null);
        slotTable.resetSlots();
        this.tablePool.putSlotTable(slotTable);
    }

    SlotTable peekSlotTable() {
        return (SlotTable)this.tableContainer.get(this.currentIndex - 1);
    }

    private class SlotTablePool {
        private SlotTable[] pool = new SlotTable[5];
        private final int HIGH_WATER_MARK = 5;
        private int currentIndex = 0;

        SlotTablePool() {
        }

        void putSlotTable(SlotTable slotTable) {
            if (this.currentIndex >= 5) {
                return;
            }
            this.pool[this.currentIndex] = slotTable;
            ++this.currentIndex;
        }

        SlotTable getSlotTable() {
            if (this.currentIndex == 0) {
                return null;
            }
            --this.currentIndex;
            return this.pool[this.currentIndex];
        }
    }
}

