/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.copyobject.newreflect;

import com.sun.corba.ee.impl.copyobject.newreflect.CachingClassCopierFactory;
import com.sun.corba.ee.impl.copyobject.newreflect.ClassCopier;
import com.sun.corba.ee.impl.copyobject.newreflect.ClassCopierFactory;
import com.sun.corba.ee.impl.copyobject.newreflect.ClassCopierFactoryArrayImpl;
import com.sun.corba.ee.impl.copyobject.newreflect.ClassCopierFactoryPipelineImpl;
import com.sun.corba.ee.impl.copyobject.newreflect.ClassCopierOrdinaryImpl;
import com.sun.corba.ee.impl.copyobject.newreflect.PipelineClassCopierFactory;
import com.sun.corba.ee.spi.copyobject.ReflectiveCopyException;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class DefaultClassCopierFactories {
    private DefaultClassCopierFactories() {
    }

    public static ClassCopierFactory makeArrayClassCopierFactory(ClassCopierFactory classCopierFactory) {
        return new ClassCopierFactoryArrayImpl(classCopierFactory);
    }

    public static ClassCopierFactory makeOrdinaryClassCopierFactory(final PipelineClassCopierFactory pipelineClassCopierFactory) {
        return new ClassCopierFactory(){

            public ClassCopier get(Class clazz) throws ReflectiveCopyException {
                return new ClassCopierOrdinaryImpl(pipelineClassCopierFactory, clazz);
            }
        };
    }

    public static CachingClassCopierFactory makeCachingClassCopierFactory() {
        return new CachingClassCopierFactory(){
            private Map cache = new WeakHashMap();

            public void put(Class clazz, ClassCopier classCopier) {
                this.cache.put(clazz, classCopier);
            }

            public ClassCopier get(Class clazz) {
                return (ClassCopier)this.cache.get(clazz);
            }
        };
    }

    public static ClassCopierFactory getNullClassCopierFactory() {
        return new ClassCopierFactory(){

            public ClassCopier get(Class clazz) {
                return null;
            }
        };
    }

    public static PipelineClassCopierFactory getPipelineClassCopierFactory() {
        return new ClassCopierFactoryPipelineImpl();
    }
}

