/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.web.cache;

import com.sun.appserv.util.cache.Cache;
import com.sun.appserv.web.cache.CacheHelper;
import com.sun.appserv.web.cache.CacheManagerListener;
import com.sun.appserv.web.cache.DefaultCacheHelper;
import com.sun.appserv.web.cache.mapping.CacheMapping;
import com.sun.logging.LogDomains;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.apache.catalina.LifecycleException;

public class CacheManager {
    public static final String CACHE_MANAGER_ATTR_NAME = "com.sun.appserv.web.CacheManager";
    public static final int DEFAULT_CACHE_MAX_ENTRIES = 4096;
    public static final int DEFAULT_CACHE_TIMEOUT = 30;
    public static final String DEFAULT_CACHE_CLASSNAME = "com.sun.appserv.util.cache.LruCache";
    private static Logger _logger;
    private static ResourceBundle _rb;
    int maxEntries = 4096;
    int defaultTimeout = 30;
    String cacheClassName = "com.sun.appserv.util.cache.LruCache";
    boolean enabled = false;
    ServletContext context;
    Properties cacheProps;
    Cache defaultCache;
    HashMap cacheMappings = new HashMap();
    Map defaultHelperProps;
    DefaultCacheHelper defaultHelper;
    HashMap helperDefs = new HashMap();
    HashMap cacheHelpers = new HashMap();
    HashMap cacheHelpersByFilterName = new HashMap();
    ArrayList listeners = new ArrayList();

    public void setMaxEntries(int maxEntries) {
        this.maxEntries = maxEntries;
    }

    public void setDefaultTimeout(int defaultTimeout) {
        this.defaultTimeout = defaultTimeout;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void addProperty(String name, String value) {
        if (name.equalsIgnoreCase("cacheClassName")) {
            this.cacheClassName = value;
        } else {
            if (this.cacheProps == null) {
                this.cacheProps = new Properties();
            }
            this.cacheProps.setProperty(name, value);
        }
    }

    public void addCacheHelperDef(String name, HashMap helperDef) {
        this.helperDefs.put(name, helperDef);
    }

    public void setDefaultHelperProps(Map map) {
        this.defaultHelperProps = map;
    }

    public void setServletContext(ServletContext context) {
        this.context = context;
    }

    private CacheHelper loadCacheHelper(String className) throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class<?> helperClass = cl.loadClass(className);
        CacheHelper helper = (CacheHelper)helperClass.newInstance();
        return helper;
    }

    public void start() throws LifecycleException {
        if (!this.enabled) {
            return;
        }
        _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
        _rb = _logger.getResourceBundle();
        try {
            this.defaultCache = this.createCache(this.maxEntries, this.cacheClassName);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "cache.manager.excep_createCache", e);
            String msg = _rb.getString("cache.manager.excep_createCache");
            throw new LifecycleException(msg, e);
        }
        this.defaultHelper = new DefaultCacheHelper();
        this.defaultHelper.setCacheManager(this);
        this.defaultHelper.init(this.context, this.defaultHelperProps);
        Iterator helperNames = this.helperDefs.keySet().iterator();
        while (helperNames.hasNext()) {
            String name = (String)helperNames.next();
            HashMap map = (HashMap)this.helperDefs.get(name);
            try {
                String className = (String)map.get("class-name");
                CacheHelper helper = this.loadCacheHelper(className);
                helper.init(this.context, map);
                this.cacheHelpers.put(name, helper);
            }
            catch (Exception e) {
                String msg = _rb.getString("cache.manager.excep_initCacheHelper");
                Object[] params = new Object[]{name};
                msg = MessageFormat.format(msg, params);
                throw new LifecycleException(msg, e);
            }
        }
        Iterator filterNames = this.cacheMappings.keySet().iterator();
        while (filterNames.hasNext()) {
            String name = (String)filterNames.next();
            CacheMapping mapping = (CacheMapping)this.cacheMappings.get(name);
            String helperNameRef = mapping.getHelperNameRef();
            CacheHelper helper = helperNameRef == null || helperNameRef.equals("default") ? this.defaultHelper : (CacheHelper)this.cacheHelpers.get(helperNameRef);
            this.cacheHelpersByFilterName.put(name, helper);
        }
    }

    public String getCacheClassName() {
        return this.cacheClassName;
    }

    public Cache createCache() throws Exception {
        return this.createCache(this.maxEntries, DEFAULT_CACHE_CLASSNAME);
    }

    public Cache createCache(int cacacity, String className) throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class<?> cacheClass = cl.loadClass(className);
        Cache cacheImpl = (Cache)cacheClass.newInstance();
        cacheImpl.init(this.maxEntries, this.cacheProps);
        return cacheImpl;
    }

    public int getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public Cache getDefaultCache() {
        return this.defaultCache;
    }

    public void addCacheMapping(String name, CacheMapping mapping) {
        this.cacheMappings.put(name, mapping);
    }

    public CacheMapping getCacheMapping(String name) {
        return (CacheMapping)this.cacheMappings.get(name);
    }

    public CacheHelper getCacheHelper(String name) {
        return (CacheHelper)this.cacheHelpers.get(name);
    }

    public CacheHelper getCacheHelperByFilterName(String filterName) {
        return (CacheHelper)this.cacheHelpersByFilterName.get(filterName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCacheManagerListener(CacheManagerListener listener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCacheManagerListener(CacheManagerListener listener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
        }
    }

    public void enable() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            CacheManagerListener listener = (CacheManagerListener)this.listeners.get(i);
            listener.cacheManagerEnabled();
        }
    }

    public void disable() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            CacheManagerListener listener = (CacheManagerListener)this.listeners.get(i);
            listener.cacheManagerDisabled();
        }
    }

    public void stop() throws LifecycleException {
        this.disable();
        try {
            this.defaultHelper.destroy();
        }
        catch (Exception e) {
            // empty catch block
        }
        Enumeration helpers = Collections.enumeration(this.cacheHelpers.values());
        while (helpers.hasMoreElements()) {
            CacheHelper cacheHelper = (CacheHelper)helpers.nextElement();
            try {
                cacheHelper.destroy();
            }
            catch (Exception exception) {}
        }
        this.cacheHelpers.clear();
        this.cacheMappings.clear();
        this.cacheHelpersByFilterName.clear();
        this.listeners.clear();
    }

    static {
        _rb = null;
    }
}

