/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.server.util;

import com.sun.appserv.BytecodePreprocessor;
import com.sun.logging.LogDomains;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PreprocessorUtil {
    private static boolean _preprocessorEnabled = false;
    private static BytecodePreprocessor[] _preprocessor;
    private static Logger _logger;

    public static boolean init(String[] ppClassNames) {
        if (ppClassNames != null) {
            PreprocessorUtil.setupPreprocessor(ppClassNames);
        }
        return _preprocessorEnabled;
    }

    public static byte[] processClass(String className, byte[] classBytes) {
        byte[] goodBytes = classBytes;
        if (_preprocessorEnabled && _preprocessor != null) {
            for (int i = 0; i < _preprocessor.length; ++i) {
                classBytes = _preprocessor[i].preprocess(className, classBytes);
                _logger.fine("[PreprocessorUtil.processClass] Preprocessor " + i + " Processed Class: " + className);
                if (classBytes != null) {
                    goodBytes = classBytes;
                    continue;
                }
                _logger.log(Level.SEVERE, "core.preprocessor_preprocess_failed", new String[]{className, _preprocessor[i].getClass().getName()});
                if (i == 0) {
                    _logger.log(Level.SEVERE, "core.preprocessor_resetting_original", className);
                    continue;
                }
                _logger.log(Level.SEVERE, "core.preprocessor_resetting_last_good");
            }
        }
        return goodBytes;
    }

    private static synchronized void setupPreprocessor(String[] ppClassNames) {
        if (_preprocessor != null) {
            return;
        }
        try {
            _preprocessor = new BytecodePreprocessor[ppClassNames.length];
            for (int i = 0; i < ppClassNames.length; ++i) {
                String ppClassName = ppClassNames[i].trim();
                Class<?> ppClass = Class.forName(ppClassName);
                if (ppClass != null) {
                    PreprocessorUtil._preprocessor[i] = (BytecodePreprocessor)ppClass.newInstance();
                    if (_preprocessor[i] instanceof BytecodePreprocessor) {
                        PreprocessorUtil._preprocessor[i] = _preprocessor[i];
                        _preprocessorEnabled = true;
                    } else {
                        _logger.log(Level.SEVERE, "core.preprocessor_invalid_type", ppClassName);
                        _logger.log(Level.SEVERE, "core.preprocessor_disabled");
                        _preprocessorEnabled = false;
                    }
                }
                if (_preprocessor[i] != null) {
                    if (_preprocessor[i].initialize(new Hashtable())) continue;
                    _logger.log(Level.SEVERE, "core.preprocessor_failed_init", ppClassName);
                    _logger.log(Level.SEVERE, "core.preprocessor_disabled");
                    _preprocessorEnabled = false;
                    continue;
                }
                _logger.log(Level.SEVERE, "core.preprocessor_failed_init", ppClassName);
                _logger.log(Level.SEVERE, "core.preprocessor_disabled");
                _preprocessorEnabled = false;
            }
        }
        catch (Throwable t) {
            _logger.log(Level.SEVERE, "core.preprocessor_setup_ex", t.toString());
            _logger.log(Level.SEVERE, "core.preprocessor_disabled");
            _preprocessorEnabled = false;
            return;
        }
    }

    public static boolean isPreprocessorEnabled() {
        return _preprocessorEnabled;
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.core");
    }
}

