/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.client.dii;

import com.sun.xml.rpc.client.dii.DynamicInvocationException;
import com.sun.xml.rpc.util.Holders;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.rpc.Call;
import javax.xml.rpc.Stub;
import javax.xml.rpc.holders.Holder;

public class CallInvocationHandler
implements InvocationHandler,
Stub {
    private static final Set recognizedProperties;
    private Map callMap = new HashMap();
    private Map properties = new HashMap();
    private Class portInterface;

    CallInvocationHandler(Class portInterface) {
        this.portInterface = portInterface;
    }

    public void addCall(Method key, Call call) {
        this.callMap.put(key, call);
    }

    public Call getCall(Method key) {
        return (Call)this.callMap.get(key);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
        if (this.portInterface.equals(method.getDeclaringClass())) {
            Call call = this.getCall(method);
            if (call == null) {
                String knownMethodNames = "";
                Iterator eachKnownMethod = this.callMap.keySet().iterator();
                while (eachKnownMethod.hasNext()) {
                    Method knownMethod = (Method)eachKnownMethod.next();
                    knownMethodNames = knownMethodNames + "\n" + knownMethod.getName();
                }
                throw new DynamicInvocationException("dii.dynamicproxy.method.unrecognized", new Object[]{method != null ? method.getName() : null, knownMethodNames});
            }
            return this.doCall(call, args);
        }
        return this.doNonPort(method, args);
    }

    protected Object doCall(Call call, Object[] args) throws RemoteException {
        if (args == null) {
            args = new Object[]{};
        }
        Holder[] holders = new Holder[args.length];
        int[] holderLocations = new int[args.length];
        int lastHolderIndex = 0;
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (!(arg instanceof Holder)) continue;
            Holder holderArg = (Holder)arg;
            holderLocations[lastHolderIndex] = i;
            holders[lastHolderIndex] = holderArg;
            args[i] = Holders.getValue(holderArg);
            ++lastHolderIndex;
        }
        Object returnValue = call.invoke(args);
        if (lastHolderIndex > 0) {
            List outputValues = call.getOutputValues();
            Iterator eachOutputValue = outputValues.iterator();
            int holderIndex = 0;
            while (eachOutputValue.hasNext()) {
                Object outParameter = eachOutputValue.next();
                int holderLocation = holderLocations[holderIndex];
                Holder holder = holders[holderIndex];
                Holders.setValue(holder, outParameter);
                args[holderLocation] = holder;
                ++holderIndex;
            }
        }
        return returnValue;
    }

    protected Object doNonPort(Method method, Object[] args) {
        try {
            return method.invoke((Object)this, args);
        }
        catch (Exception e) {
            throw new DynamicInvocationException("dii.exception.nested", new LocalizableExceptionAdapter(e));
        }
    }

    public void _setProperty(String name, Object value) {
        if (!recognizedProperties.contains(name)) {
            throw new IllegalArgumentException("Call object does not recognize property: " + name);
        }
        this.properties.put(name, value);
        this.setPropertyOnCallObjects(name, value);
    }

    public Object _getProperty(String name) {
        return this.properties.get(name);
    }

    public Iterator _getPropertyNames() {
        return this.properties.keySet().iterator();
    }

    private void setPropertyOnCallObjects(String propertyName, Object value) {
        Iterator eachCall = this.callMap.values().iterator();
        while (eachCall.hasNext()) {
            Call call = (Call)eachCall.next();
            if ("javax.xml.rpc.service.endpoint.address".equals(propertyName)) {
                call.setTargetEndpointAddress((String)value);
                continue;
            }
            call.setProperty(propertyName, value);
        }
    }

    public String _getDefaultEnvelopeEncodingStyle() {
        return null;
    }

    public String _getImplicitEnvelopeEncodingStyle() {
        return "";
    }

    public String _getEncodingStyle() {
        return "http://schemas.xmlsoap.org/soap/encoding/";
    }

    public void _setEncodingStyle(String encodingStyle) {
        throw new UnsupportedOperationException("cannot set encoding style");
    }

    static {
        HashSet<String> temp = new HashSet<String>();
        temp.add("javax.xml.rpc.security.auth.username");
        temp.add("javax.xml.rpc.security.auth.password");
        temp.add("javax.xml.rpc.service.endpoint.address");
        temp.add("javax.xml.rpc.session.maintain");
        temp.add("com.sun.xml.rpc.client.http.CookieJar");
        recognizedProperties = Collections.unmodifiableSet(temp);
    }
}

