/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.XAConnectionFactory;
import com.sun.messaging.jmq.jmsclient.XAConnectionImpl;
import com.sun.messaging.jms.ra.ConnectionManager;
import com.sun.messaging.jms.ra.EndpointConsumer;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkManager;
import javax.transaction.xa.XAResource;

public class ResourceAdapter
implements javax.resource.spi.ResourceAdapter,
ExceptionListener,
Serializable {
    private transient String raUID = null;
    private transient BootstrapContext b_context = null;
    protected transient WorkManager workMgr = null;
    private transient boolean started = false;
    private transient boolean stopping;
    private transient HashMap epFactories = null;
    private transient HashMap epConsumers = null;
    private transient HashMap epFactoryToConsumer = null;
    private transient int _factoryID = 0;
    private transient int _consumerID = 0;
    private transient XAConnectionFactory xacf = null;
    protected transient XAConnectionImpl xac = null;
    private transient Method onMessage = null;
    private boolean logRCFailures = true;
    private String connectionURL = "localhost";
    private String userName = "guest";
    private String password = "guest";
    private boolean reconnectEnabled = false;
    private int reconnectInterval = 30000;
    private int reconnectAttempts = 6;
    private String addressListBehavior = "PRIORITY";
    private int addressListIterations = 1;
    private int maxLoopDelay = 120000;
    private boolean inAppClientContainer = false;
    private boolean inClusteredContainer = false;
    private String groupName = null;
    protected static transient Logger _logger = Logger.getLogger("imqjms.ra", "com.sun.messaging.jms.ra.LogStrings");
    protected static transient ConnectionManager _cm = new ConnectionManager();
    static /* synthetic */ Class class$javax$jms$MessageListener;
    static /* synthetic */ Class class$javax$jms$Message;

    public void start(BootstrapContext bootstrapContext) throws ResourceAdapterInternalException {
        this.stopping = false;
        if (this.started) {
            // empty if block
        }
        this.b_context = bootstrapContext;
        if (this.b_context != null) {
            this.workMgr = this.b_context.getWorkManager();
        }
        this._adjustInAppClientContainer();
        this.xacf = new XAConnectionFactory();
        if (!this.inAppClientContainer) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    System.setProperty("imq.DaemonThreads", "true");
                    return null;
                }
            });
        }
        try {
            this.xacf.setProperty("imqAddressList", this.connectionURL);
            this.xacf.setProperty("imqAddressListBehavior", this.addressListBehavior);
            this.xacf.setProperty("imqDefaultUsername", this.userName);
            this.xacf.setProperty("imqDefaultPassword", this.password);
            this.xacf.setProperty("imqAddressListIterations", Integer.toString(this.addressListIterations));
            this.xacf.setProperty("imqReconnectEnabled", Boolean.toString(true));
            this.xacf.setProperty("imqReconnectInterval", Integer.toString(this.reconnectInterval));
            this.xacf.setProperty("imqReconnectAttempts", Integer.toString(this.reconnectAttempts));
            this.xac = (XAConnectionImpl)this.xacf.createXAConnection();
            this.init();
        }
        catch (JMSSecurityException jMSSecurityException) {
            System.err.println("MQRA:RA:start:createConnection JMSSecurityException:" + jMSSecurityException.getMessage());
            jMSSecurityException.printStackTrace();
            ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException("MQRA-start:Error:createConnection failed:aborting");
            resourceAdapterInternalException.initCause((Throwable)jMSSecurityException);
            throw resourceAdapterInternalException;
        }
        catch (JMSException jMSException) {
            System.err.println("MQRA:RA:start:createConnection Exception:message=" + jMSException.getMessage());
            System.err.println("MQRA:RA:start:createConnction failed:aborting");
            jMSException.printStackTrace();
            ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException("MQRA-start:Error:createConnection failed:aborting");
            resourceAdapterInternalException.initCause((Throwable)jMSException);
            throw resourceAdapterInternalException;
        }
        this.epFactories = new HashMap(10);
        this.epConsumers = new HashMap(10);
        this.epFactoryToConsumer = new HashMap(10);
        this.setOnMessageMethod();
        this.started = true;
    }

    public void stop() {
        this.stopping = true;
        if (!this.started) {
            System.err.println("MQRA:RA:stop:already stopped:ignoring");
            return;
        }
        this.removeAllConsumers();
        if (this.xac != null) {
            try {
                this.xac.close();
            }
            catch (JMSException jMSException) {
                System.err.println("MQRA-stop:Warning:closeConnection Exception:ignoring");
            }
        }
        if (_cm != null) {
            _cm.destroyConnections();
        }
        this.started = false;
    }

    public void endpointActivation(MessageEndpointFactory messageEndpointFactory, ActivationSpec activationSpec) throws NotSupportedException {
        if (!this.started) {
            System.err.println("MQRA-endpointActivation:Error:RA not started:aborting");
            throw new NotSupportedException("MQRA-endpointActivation:Error:RA not started:aborting");
        }
        EndpointConsumer endpointConsumer = new EndpointConsumer(this);
        try {
            endpointConsumer.createMessageConsumer(messageEndpointFactory, activationSpec);
        }
        catch (Exception exception) {
            System.err.println("MQRA-endpointActivation:Error:creatMessageConsumer failed:aborting");
            NotSupportedException notSupportedException = new NotSupportedException("MQRA-endpointActivation:Error:creatMessageConsumer failed:aborting");
            notSupportedException.initCause((Throwable)exception);
            throw notSupportedException;
        }
    }

    public void endpointDeactivation(MessageEndpointFactory messageEndpointFactory, ActivationSpec activationSpec) {
        if (!this.started) {
            System.err.println("MQRA-endpointDeactivation:Error:RA not started:ignoring");
            return;
        }
        int n = this.matchMessageFactory(messageEndpointFactory);
        int n2 = this.getConsumerIDbyFactoryID(n);
        EndpointConsumer endpointConsumer = this.getEndpointConsumer(n2);
        endpointConsumer.setDeactivated();
        try {
            endpointConsumer.stopMessageConsumer(activationSpec);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.removeFromMaps(n);
    }

    public XAResource[] getXAResources(ActivationSpec[] activationSpecArray) throws ResourceException {
        XAResource[] xAResourceArray = new XAResource[]{};
        return xAResourceArray;
    }

    public void onException(JMSException jMSException) {
        System.err.println("MQRA:RA:EL:connection failed:attempting to re-establish:Exception msg=" + jMSException.getMessage());
        this.logRCFailures = true;
        int n = this.reconnectInterval;
        int n2 = 0;
        while (this.started && !this.stopping) {
            try {
                Thread.sleep(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                System.err.println("MQRA:RA:EL:addressList reconnect attempt_loop#" + ++n2 + ":Delayed " + n + " milliseconds.");
                this.xac = (XAConnectionImpl)this.xacf.createXAConnection();
                this.init();
                System.err.println("MQRA:RA:EL:RE-CONNECTED RA:on loop#" + n2);
                break;
            }
            catch (JMSException jMSException2) {
                if (this.logRCFailures) {
                    System.err.println("MQRA:RA:EL:Exception SEVERE:Unable to re-connect RA:" + this.toString());
                    jMSException2.printStackTrace();
                } else {
                    System.err.println("MQRA:RA:EL:Exception SEVERE:Unable to re-connect RA on attempt_loop#" + n2);
                }
                this.logRCFailures = false;
                if (n >= this.maxLoopDelay || (n *= 3) <= this.maxLoopDelay) continue;
                n = this.maxLoopDelay;
            }
        }
    }

    public void setConnectionURL(String string) {
        this.connectionURL = string;
    }

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setReconnectEnabled(boolean bl) {
        this.reconnectEnabled = bl;
    }

    public boolean getReconnectEnabled() {
        return this.reconnectEnabled;
    }

    public void setReconnectInterval(int n) {
        this.reconnectInterval = n;
    }

    public int getReconnectInterval() {
        return this.reconnectInterval;
    }

    public void setReconnectAttempts(int n) {
        this.reconnectAttempts = n;
    }

    public int getReconnectAttempts() {
        return this.reconnectAttempts;
    }

    public void setAddressListBehavior(String string) {
        this.addressListBehavior = "RANDOM".equalsIgnoreCase(string) ? "RANDOM" : "PRIORITY";
    }

    public String getAddressListBehavior() {
        return this.addressListBehavior;
    }

    public void setAddressListIterations(int n) {
        this.addressListIterations = n < 0 ? -1 : n;
    }

    public int getAddressListIterations() {
        return this.addressListIterations;
    }

    public void setInAppClientContainer(boolean bl) {
        this.inAppClientContainer = bl;
        this._adjustInAppClientContainer();
    }

    public boolean getInAppClientContainer() {
        return this.inAppClientContainer;
    }

    public void setInClusteredContainer(boolean bl) {
        this.inClusteredContainer = bl;
    }

    public boolean getInClusteredContainer() {
        return this.inClusteredContainer;
    }

    public void setGroupName(String string) {
        this.groupName = string;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public XAConnectionFactory getXACF() {
        return this.xacf;
    }

    public String _getRAUID() {
        return this.raUID;
    }

    public Method getOnMessageMethod() {
        if (this.onMessage == null) {
            this.setOnMessageMethod();
        }
        return this.onMessage;
    }

    private void init() throws JMSException {
        if (this.xac != null) {
            if (this.inClusteredContainer && this.raUID == null) {
                this.raUID = Long.toString(this.xac.generateUID());
            }
            this.xac.setExceptionListener(this);
        }
    }

    private int createFactoryID() {
        return ++this._factoryID;
    }

    private int createConsumerID() {
        return ++this._consumerID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int addMessageFactory(MessageEndpointFactory messageEndpointFactory) {
        int n = this.createFactoryID();
        HashMap hashMap = this.epFactories;
        synchronized (hashMap) {
            this.epFactories.put(new Integer(n), messageEndpointFactory);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeMessageFactory(int n) {
        HashMap hashMap = this.epFactories;
        synchronized (hashMap) {
            this.epFactories.remove(new Integer(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageEndpointFactory getMessageFactory(int n) {
        HashMap hashMap = this.epFactories;
        synchronized (hashMap) {
            MessageEndpointFactory messageEndpointFactory = (MessageEndpointFactory)this.epFactories.get(new Integer(n));
            return messageEndpointFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int matchMessageFactory(MessageEndpointFactory messageEndpointFactory) {
        int n = -1;
        if (messageEndpointFactory != null) {
            HashMap hashMap = this.epFactories;
            synchronized (hashMap) {
                Set set = this.epFactories.entrySet();
                if (set != null) {
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = (Map.Entry)iterator.next();
                        if (!messageEndpointFactory.equals(entry.getValue())) continue;
                        Integer n2 = (Integer)entry.getKey();
                        n = n2;
                        break;
                    }
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFactorytoConsumerLink(int n, int n2) {
        HashMap hashMap = this.epFactoryToConsumer;
        synchronized (hashMap) {
            this.epFactoryToConsumer.put(new Integer(n), new Integer(n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFactorytoConsumerLink(int n) {
        HashMap hashMap = this.epFactoryToConsumer;
        synchronized (hashMap) {
            this.epFactoryToConsumer.remove(new Integer(n));
        }
    }

    protected int getConsumerIDbyFactoryID(int n) {
        return (Integer)this.epFactoryToConsumer.get(new Integer(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int addEndpointConsumer(EndpointConsumer endpointConsumer) {
        int n = this.createConsumerID();
        HashMap hashMap = this.epConsumers;
        synchronized (hashMap) {
            this.epConsumers.put(new Integer(n), endpointConsumer);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeEndpointConsumer(int n) {
        HashMap hashMap = this.epConsumers;
        synchronized (hashMap) {
            this.epConsumers.remove(new Integer(n));
        }
    }

    protected EndpointConsumer getEndpointConsumer(int n) {
        EndpointConsumer endpointConsumer = (EndpointConsumer)this.epConsumers.get(new Integer(n));
        return endpointConsumer;
    }

    protected void removeFromMaps(int n) {
        int n2 = this.getConsumerIDbyFactoryID(n);
        this.removeEndpointConsumer(n2);
        this.removeMessageFactory(n);
        this.removeFactorytoConsumerLink(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllConsumers() {
        HashMap hashMap = this.epFactories;
        synchronized (hashMap) {
            Set set = this.epFactories.entrySet();
            if (set != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    int n = (Integer)entry.getKey();
                    int n2 = this.getConsumerIDbyFactoryID(n);
                    EndpointConsumer endpointConsumer = this.getEndpointConsumer(n2);
                    try {
                        endpointConsumer.stopMessageConsumer();
                    }
                    catch (Exception exception) {
                        System.err.println("MQRA:RA::Error:stopMessageConsumer exception:ignoring");
                    }
                }
                this.clearMaps();
            }
        }
    }

    private void clearMaps() {
        this.epFactories.clear();
        this.epConsumers.clear();
        this.epFactoryToConsumer.clear();
    }

    private void setOnMessageMethod() {
        Method method = null;
        try {
            Class clazz = class$javax$jms$MessageListener == null ? (class$javax$jms$MessageListener = ResourceAdapter.class$("javax.jms.MessageListener")) : class$javax$jms$MessageListener;
            Class[] classArray = new Class[]{class$javax$jms$Message == null ? (class$javax$jms$Message = ResourceAdapter.class$("javax.jms.Message")) : class$javax$jms$Message};
            method = clazz.getMethod("onMessage", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        this.onMessage = method;
    }

    private void _adjustInAppClientContainer() {
        String string = System.getProperty("com.sun.messaging.jms.ra.inACC");
        if (string != null) {
            System.err.println("MQRA:RA:AIACC:SystemProp com.sun.messaging.jms.ra.inACC is NOT null!!");
            if ("true".equals(string)) {
                System.err.println("MQRA:RA:AIACC:setting inACC true");
                this.inAppClientContainer = true;
            } else {
                System.err.println("MQRA:RA:AIACC:setting inACC false");
                this.inAppClientContainer = false;
            }
        } else if (this.workMgr != null) {
            try {
                this.workMgr.doWork(new Work(){

                    public void run() {
                    }

                    public void release() {
                    }
                });
            }
            catch (Exception exception) {
                this.inAppClientContainer = true;
            }
        } else {
            this.inAppClientContainer = true;
        }
    }

    public String toString() {
        return "ResourceAdaapter configuration=\n\traUID                               =" + this.raUID + "\n" + "\tConnectionURL                       =" + this.connectionURL + "\n" + "\tUserName                            =" + this.userName + "\n" + "\tPassword                            =" + this.password + "\n" + "\tReconnectEnabled                    =" + this.reconnectEnabled + "\n" + "\tReconnectInterval                   =" + this.reconnectInterval + "\n" + "\tReconnectAttempts                   =" + this.reconnectAttempts + "\n" + "\tAddressListBehavior                 =" + this.addressListBehavior + "\n" + "\tAddressListIterations               =" + this.addressListIterations + "\n" + "\tInAppClientContainer                =" + this.inAppClientContainer + "\n" + "\tInClusteredContainer                =" + this.inClusteredContainer + "\n" + "\tGroupName                           =" + this.groupName + "\n";
    }

    public static ConnectionManager _getConnectionManager() {
        return _cm;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

