/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jms.JMSException;
import com.sun.messaging.jms.ra.ActivationSpec;
import com.sun.messaging.jms.ra.EndpointConsumer;
import com.sun.messaging.jms.ra.OnMessageRunner;
import java.util.ArrayList;
import java.util.Vector;
import javax.resource.spi.endpoint.MessageEndpointFactory;

public class OnMessageRunnerPool {
    private int max;
    private int min;
    private int freeCount;
    private int slackCount;
    private MessageEndpointFactory epFactory;
    private EndpointConsumer epConsumer;
    private ActivationSpec spec = null;
    private ArrayList onMessageRunners;
    private Vector available;

    public OnMessageRunnerPool(MessageEndpointFactory messageEndpointFactory, EndpointConsumer endpointConsumer, ActivationSpec activationSpec) {
        this.epFactory = messageEndpointFactory;
        this.epConsumer = endpointConsumer;
        this.spec = activationSpec;
        int n = activationSpec.getEndpointPoolSteadySize();
        int n2 = activationSpec.getEndpointPoolMaxSize();
        this.max = n2 < 1 ? 10 : n2;
        this.min = n < 1 || n > this.max ? 1 : n;
        this.available = new Vector(this.min);
        this.onMessageRunners = new ArrayList(this.min);
        for (int i = 0; i < this.min; ++i) {
            OnMessageRunner onMessageRunner = new OnMessageRunner(i, this, messageEndpointFactory, endpointConsumer, activationSpec);
            this.onMessageRunners.add(onMessageRunner);
            this.available.addElement(onMessageRunner);
        }
        this.freeCount = this.min;
        this.slackCount = this.max - this.min;
    }

    public synchronized OnMessageRunner getOnMessageRunner() throws javax.jms.JMSException {
        if (this.available.size() == 0 && this.slackCount > 0) {
            OnMessageRunner onMessageRunner = new OnMessageRunner(this.onMessageRunners.size(), this, this.epFactory, this.epConsumer, this.spec);
            this.onMessageRunners.add(onMessageRunner);
            --this.slackCount;
            return onMessageRunner;
        }
        while (this.available.size() == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                JMSException jMSException = new JMSException("MQRA:OMRP:Unable to get OMR from pool:" + interruptedException.getMessage());
                jMSException.setLinkedException(interruptedException);
                throw jMSException;
            }
        }
        OnMessageRunner onMessageRunner = (OnMessageRunner)this.available.elementAt(this.available.size() - 1);
        this.available.removeElementAt(this.available.size() - 1);
        --this.freeCount;
        return onMessageRunner;
    }

    public synchronized void putOnMessageRunner(OnMessageRunner onMessageRunner) {
        this.available.addElement(onMessageRunner);
        ++this.freeCount;
        this.notifyAll();
    }

    public synchronized void removeOnMessageRunner(OnMessageRunner onMessageRunner) {
        int n = this.onMessageRunners.indexOf(onMessageRunner);
        if (n != -1) {
            this.onMessageRunners.remove(n);
            ++this.freeCount;
            if (this.slackCount < this.max - this.min) {
                ++this.slackCount;
            }
        }
    }

    public synchronized void waitForAllOnMessageRunners() throws javax.jms.JMSException {
        while (this.available.size() < this.onMessageRunners.size()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                JMSException jMSException = new JMSException("MQRA:OMRP:Didnot finish waiting for OMRs to return:" + interruptedException.getMessage());
                jMSException.setLinkedException(interruptedException);
                throw jMSException;
            }
        }
    }

    public synchronized void releaseOnMessageRunners() {
        for (int i = 0; i < this.onMessageRunners.size(); ++i) {
            ((OnMessageRunner)this.onMessageRunners.get(i)).releaseEndpoint();
        }
        this.onMessageRunners.clear();
        this.available.removeAllElements();
        this.freeCount = 0;
        this.slackCount = this.max;
    }

    public synchronized void invalidateOnMessageRunners() {
        for (int i = 0; i < this.onMessageRunners.size(); ++i) {
            ((OnMessageRunner)this.onMessageRunners.get(i)).invalidate();
        }
        this.releaseOnMessageRunners();
    }
}

