/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.XAConnectionFactory;
import com.sun.messaging.jms.ra.ConnectionFactoryAdapter;
import com.sun.messaging.jms.ra.ConnectionRequestInfo;
import com.sun.messaging.jms.ra.ManagedConnection;
import com.sun.messaging.jms.ra.ResourceAdapter;
import com.sun.messaging.jms.ra.Util;
import java.io.PrintWriter;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Set;
import javax.jms.JMSException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;

public class ManagedConnectionFactory
implements javax.resource.spi.ManagedConnectionFactory,
ResourceAdapterAssociation,
Serializable {
    private ResourceAdapter ra = null;
    private XAConnectionFactory xacf = new XAConnectionFactory();
    private String messageServiceAddressList = null;
    private String userName = null;
    private String password = null;
    private String clientId = null;
    private boolean reconnectEnabled = false;
    private boolean reconnectEnabledSet = false;
    private int reconnectInterval = -1;
    private int reconnectAttempts = -1;
    private String addressListBehavior = null;
    private int addressListIterations = -1;
    private transient PrintWriter logWriter = null;
    private transient int mcfId = ++idCounter;
    private static int idCounter = 0;

    public Object createConnectionFactory(ConnectionManager connectionManager) {
        return new ConnectionFactoryAdapter(this, connectionManager);
    }

    public Object createConnectionFactory() {
        return this.createConnectionFactory(ResourceAdapter._getConnectionManager());
    }

    public javax.resource.spi.ManagedConnection createManagedConnection(Subject subject, javax.resource.spi.ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        return new ManagedConnection(this, subject, (ConnectionRequestInfo)connectionRequestInfo, this.ra);
    }

    public javax.resource.spi.ManagedConnection matchManagedConnections(Set set, Subject subject, javax.resource.spi.ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        PasswordCredential passwordCredential = Util.getPasswordCredential(this, subject, (ConnectionRequestInfo)connectionRequestInfo);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof ManagedConnection)) continue;
            ManagedConnection managedConnection = (ManagedConnection)e;
            ManagedConnectionFactory managedConnectionFactory = managedConnection.getManagedConnectionFactory();
            if (managedConnection.isDestroyed() || !Util.isPasswordCredentialEqual(managedConnection.getPasswordCredential(), passwordCredential) || !managedConnectionFactory.equals(this)) continue;
            return managedConnection;
        }
        return null;
    }

    public void setLogWriter(PrintWriter printWriter) throws ResourceException {
        this.logWriter = printWriter;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    public int hashCode() {
        if (this.mcfId == 0) {
            this.mcfId = ++idCounter;
        }
        return this.mcfId;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof ManagedConnectionFactory) {
            ManagedConnectionFactory managedConnectionFactory = (ManagedConnectionFactory)object;
            String string = managedConnectionFactory.getAddressList();
            String string2 = managedConnectionFactory.getUserName();
            String string3 = managedConnectionFactory.getPassword();
            String string4 = managedConnectionFactory.getClientId();
            return (string != null && string.equals(this.messageServiceAddressList) || string == null && this.messageServiceAddressList == null) && (string2 != null && string2.equals(this.userName) || string2 == null && this.userName == null) && (string3 != null && string3.equals(this.password) || string3 == null && this.password == null) && (string4 != null && string4.equals(this.clientId) || string4 == null && this.clientId == null);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setResourceAdapter(javax.resource.spi.ResourceAdapter resourceAdapter) throws ResourceException {
        ManagedConnectionFactory managedConnectionFactory = this;
        synchronized (managedConnectionFactory) {
            ResourceAdapter resourceAdapter2;
            if (this.ra != null) throw new ResourceException("MQRA:MCF:illegal to change resource adapter association");
            if (!(resourceAdapter instanceof ResourceAdapter)) throw new ResourceException("MQRA:MCF:associating unkown resource adapter class - " + resourceAdapter.getClass());
            this.ra = resourceAdapter2 = (ResourceAdapter)resourceAdapter;
            if (!resourceAdapter2.getInAppClientContainer()) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        System.setProperty("imq.DaemonThreads", "true");
                        return null;
                    }
                });
            }
            if (this.messageServiceAddressList == null) {
                try {
                    this.setAddressList(resourceAdapter2.getConnectionURL());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (this.userName == null) {
                try {
                    this.setUserName(resourceAdapter2.getUserName());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (this.password == null) {
                try {
                    this.setPassword(resourceAdapter2.getPassword());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (!this.reconnectEnabledSet) {
                try {
                    this.setReconnectEnabled(resourceAdapter2.getReconnectEnabled());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (this.reconnectInterval == -1) {
                try {
                    this.setReconnectInterval(resourceAdapter2.getReconnectInterval());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (this.reconnectAttempts == -1) {
                try {
                    this.setReconnectAttempts(resourceAdapter2.getReconnectAttempts());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (this.addressListIterations == -1) {
                try {
                    this.setAddressListIterations(resourceAdapter2.getAddressListIterations());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (this.addressListBehavior != null) return;
            try {
                this.setAddressListBehavior(resourceAdapter2.getAddressListBehavior());
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            return;
        }
    }

    public javax.resource.spi.ResourceAdapter getResourceAdapter() {
        return this.ra;
    }

    public int getMCFId() {
        if (this.mcfId == 0) {
            this.mcfId = ++idCounter;
        }
        return this.mcfId;
    }

    public void _setMessageServiceAddressList(String string) {
        this.messageServiceAddressList = string;
        try {
            this.xacf.setProperty("imqAddressList", string);
        }
        catch (JMSException jMSException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("MQRA:MCF-Invalid Property-" + string);
            illegalArgumentException.initCause(jMSException);
            throw illegalArgumentException;
        }
    }

    public String _getMessageServiceAddressList() {
        return this.messageServiceAddressList;
    }

    public void setAddressList(String string) {
        this._setMessageServiceAddressList(string);
    }

    public String getAddressList() {
        return this.messageServiceAddressList;
    }

    public void setUserName(String string) {
        this.userName = string;
        try {
            this.xacf.setProperty("imqDefaultUsername", string);
        }
        catch (JMSException jMSException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("MQRA:MCF-Invalid Property-" + string);
            illegalArgumentException.initCause(jMSException);
            throw illegalArgumentException;
        }
    }

    public String getUserName() {
        return this.userName;
    }

    public void setPassword(String string) {
        this.password = string;
        try {
            this.xacf.setProperty("imqDefaultPassword", string);
        }
        catch (JMSException jMSException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("MQRA:MCF-Invalid Property-" + string);
            illegalArgumentException.initCause(jMSException);
            throw illegalArgumentException;
        }
    }

    public String getPassword() {
        return this.password;
    }

    public void setClientId(String string) {
        if (string == null || "".equals(string)) {
            throw new IllegalArgumentException("MQRA:MCF-Invalid Property-ClientId=" + string);
        }
        this.clientId = string;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setReconnectEnabled(boolean bl) {
        try {
            this.xacf.setProperty("imqReconnectEnabled", Boolean.toString(bl));
            this.reconnectEnabled = bl;
            this.reconnectEnabledSet = true;
        }
        catch (JMSException jMSException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("MQRA:MCF-Invalid Property-" + bl);
            illegalArgumentException.initCause(jMSException);
            throw illegalArgumentException;
        }
    }

    public boolean getReconnectEnabled() {
        return this.reconnectEnabled;
    }

    public void setReconnectInterval(int n) {
        this.reconnectInterval = n;
        try {
            this.xacf.setProperty("imqReconnectInterval", Integer.toString(n));
        }
        catch (JMSException jMSException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("MQRA:MCF-Invalid Property-" + n);
            illegalArgumentException.initCause(jMSException);
            throw illegalArgumentException;
        }
    }

    public int getReconnectInterval() {
        return this.reconnectInterval;
    }

    public void setReconnectAttempts(int n) {
        this.reconnectAttempts = n;
        try {
            this.xacf.setProperty("imqReconnectAttempts", Integer.toString(n));
        }
        catch (JMSException jMSException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("MQRA:MCF-Invalid Property-" + n);
            illegalArgumentException.initCause(jMSException);
            throw illegalArgumentException;
        }
    }

    public int getReconnectAttempts() {
        return this.reconnectAttempts;
    }

    public void setAddressListBehavior(String string) {
        this.addressListBehavior = "RANDOM".equalsIgnoreCase(string) ? "RANDOM" : "PRIORITY";
        try {
            this.xacf.setProperty("imqAddressListBehavior", string);
        }
        catch (JMSException jMSException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("MQRA:MCF-Invalid Property-" + string);
            illegalArgumentException.initCause(jMSException);
            throw illegalArgumentException;
        }
    }

    public String getAddressListBehavior() {
        return this.addressListBehavior;
    }

    public void setAddressListIterations(int n) {
        this.addressListIterations = n < 0 ? -1 : n;
        try {
            this.xacf.setProperty("imqAddressListIterations", Integer.toString(n));
        }
        catch (JMSException jMSException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("MQRA:MCF-Invalid Property-" + n);
            illegalArgumentException.initCause(jMSException);
            throw illegalArgumentException;
        }
    }

    public int getAddressListIterations() {
        return this.addressListIterations;
    }

    public void setProperty(String string, String string2) {
        try {
            if ("MessageServiceAddressList".equalsIgnoreCase(string)) {
                this.xacf.setProperty("imqAddressList", string2);
            } else {
                this.xacf.setProperty(string, string2);
            }
        }
        catch (JMSException jMSException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("MQRA:MCF-Error setting property named-" + string + " to value-" + string2);
            illegalArgumentException.initCause(jMSException);
            throw illegalArgumentException;
        }
    }

    public String getProperty(String string) {
        String string2 = null;
        try {
            string2 = this.xacf.getProperty(string);
        }
        catch (JMSException jMSException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("MQRA:MCF-Error getting property named-" + string);
            illegalArgumentException.initCause(jMSException);
            throw illegalArgumentException;
        }
        return string2;
    }

    protected XAConnectionFactory _getXACF() {
        return this.xacf;
    }

    public String toString() {
        return "ManagedConnectionFactory configuration=\n\tMCFId                               =" + this.mcfId + "\n" + "\tAddressList                         =" + this.messageServiceAddressList + "\n" + "\tUserName                            =" + this.userName + "\n" + "\tPassword                            =" + this.password + "\n" + "\tClientId                            =" + this.clientId + "\n" + "\tReconnectEnabled                    =" + this.reconnectEnabled + "\n" + "\tReconnectInterval                   =" + this.reconnectInterval + "\n" + "\tReconnectAttempts                   =" + this.reconnectAttempts + "\n" + "\tAddressListBehavior                 =" + this.addressListBehavior + "\n" + "\tAddressListIterations               =" + this.addressListIterations + "\n";
    }
}

