/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsselector;

public class NumericValue {
    Number value = null;
    String image = null;
    int imageType = 0;
    private static final int ByteValue = 0;
    private static final int ShortValue = 1;
    private static final int IntValue = 2;
    private static final int FloatValue = 3;
    static final int LongValue = 4;
    static final int DoubleValue = 5;
    private static final int[][] returnTypes = new int[][]{{0, 1, 2, 3, 4, 5}, {1, 1, 2, 3, 4, 5}, {2, 2, 2, 3, 4, 5}, {3, 3, 3, 3, 3, 5}, {4, 4, 4, 3, 4, 5}, {5, 5, 5, 5, 5, 5}};
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;

    public NumericValue(Object object) throws ClassCastException {
        if (this.value != null && !(object instanceof Number)) {
            throw new ClassCastException("Cannot make a NumericValue from a " + object.getClass().getName());
        }
        if (object instanceof NumericValue) {
            NumericValue numericValue = (NumericValue)object;
            this.value = numericValue.value;
            this.image = numericValue.image;
            this.imageType = numericValue.imageType;
        } else {
            this.value = (Number)object;
        }
    }

    public NumericValue(String string, int n) {
        this.image = string;
        this.imageType = n;
        this.value = null;
    }

    public Number getValue() {
        if (this.value == null && this.image != null) {
            switch (this.imageType) {
                case 5: {
                    this.value = new Double(this.image);
                    break;
                }
                case 4: {
                    this.value = Long.decode(this.image);
                    break;
                }
            }
            this.image = null;
            this.imageType = -1;
        }
        return this.value;
    }

    private int getIndexForType(Number number) {
        int n = -1;
        Class<?> clazz = number.getClass();
        if (clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = NumericValue.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            n = 0;
        } else if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = NumericValue.class$("java.lang.Short")) : class$java$lang$Short)) {
            n = 1;
        } else if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = NumericValue.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            n = 2;
        } else if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = NumericValue.class$("java.lang.Float")) : class$java$lang$Float)) {
            n = 3;
        } else if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = NumericValue.class$("java.lang.Long")) : class$java$lang$Long)) {
            n = 4;
        } else if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = NumericValue.class$("java.lang.Double")) : class$java$lang$Double)) {
            n = 5;
        } else {
            System.err.println("Unexpected failure in getIndexForType objClass=" + number.getClass().getName());
        }
        return n;
    }

    int getUnifiedTypeIndex(Number number, Number number2) {
        int n = -1;
        if (number != null && number2 != null) {
            int n2 = this.getIndexForType(number);
            int n3 = this.getIndexForType(number2);
            n = returnTypes[n2][n3];
        }
        return n;
    }

    private Number convertNumber(Number number, int n) {
        switch (n) {
            case 0: {
                return new Byte(number.byteValue());
            }
            case 1: {
                return new Short(number.shortValue());
            }
            case 2: {
                return new Integer(number.intValue());
            }
            case 4: {
                return new Long(number.longValue());
            }
            case 5: {
                return new Double(number.doubleValue());
            }
        }
        return null;
    }

    public boolean between(NumericValue numericValue, NumericValue numericValue2) {
        boolean bl = false;
        if (this.getValue() != null && numericValue != null && numericValue2 != null) {
            int n;
            Number number = numericValue.getValue();
            Number number2 = numericValue2.getValue();
            int n2 = this.getUnifiedTypeIndex(this.value, number);
            int n3 = n2 >= (n = this.getUnifiedTypeIndex(this.value, number2)) ? n2 : n;
            Number number3 = this.convertNumber(this.value, n3);
            Number number4 = this.convertNumber(number, n3);
            Number number5 = this.convertNumber(number2, n3);
            switch (n3) {
                case 0: {
                    bl = number3.byteValue() >= number4.byteValue() && number3.byteValue() <= number5.byteValue() || number3.byteValue() <= number4.byteValue() && number3.byteValue() >= number5.byteValue();
                    break;
                }
                case 1: {
                    bl = number3.shortValue() >= number4.shortValue() && number3.shortValue() <= number5.shortValue() || number3.shortValue() <= number4.shortValue() && number3.shortValue() >= number5.shortValue();
                    break;
                }
                case 2: {
                    bl = number3.intValue() >= number4.intValue() && number3.intValue() <= number5.intValue() || number3.intValue() <= number4.intValue() && number3.intValue() >= number5.intValue();
                    break;
                }
                case 3: {
                    bl = number3.floatValue() >= number4.floatValue() && number3.floatValue() <= number5.floatValue() || number3.floatValue() <= number4.floatValue() && number3.floatValue() >= number5.floatValue();
                    break;
                }
                case 4: {
                    bl = number3.longValue() >= number4.longValue() && number3.longValue() <= number5.longValue() || number3.longValue() <= number4.longValue() && number3.longValue() >= number5.longValue();
                    break;
                }
                case 5: {
                    bl = number3.doubleValue() >= number4.doubleValue() && number3.doubleValue() <= number5.doubleValue() || number3.doubleValue() <= number4.doubleValue() && number3.doubleValue() >= number5.doubleValue();
                    break;
                }
            }
        }
        return bl;
    }

    public Number add(NumericValue numericValue) {
        Number number = null;
        if (this.getValue() != null && numericValue != null) {
            Number number2 = numericValue.getValue();
            int n = this.getUnifiedTypeIndex(this.value, number2);
            Number number3 = this.convertNumber(this.value, n);
            Number number4 = this.convertNumber(number2, n);
            switch (n) {
                case 0: {
                    number = new Byte((byte)(number3.byteValue() + number4.byteValue()));
                    break;
                }
                case 1: {
                    number = new Short((short)(number3.shortValue() + number4.shortValue()));
                    break;
                }
                case 2: {
                    number = new Integer(number3.intValue() + number4.intValue());
                    break;
                }
                case 3: {
                    number = new Float(number3.floatValue() + number4.floatValue());
                    break;
                }
                case 4: {
                    number = new Long(number3.longValue() + number4.longValue());
                    break;
                }
                case 5: {
                    number = new Double(number3.doubleValue() + number4.doubleValue());
                    break;
                }
            }
        }
        return number;
    }

    public Number subtract(NumericValue numericValue) {
        Number number = null;
        if (this.getValue() != null && numericValue != null) {
            Number number2 = numericValue.getValue();
            int n = this.getUnifiedTypeIndex(this.value, number2);
            Number number3 = this.convertNumber(this.value, n);
            Number number4 = this.convertNumber(number2, n);
            switch (n) {
                case 0: {
                    number = new Byte((byte)(number3.byteValue() - number4.byteValue()));
                    break;
                }
                case 1: {
                    number = new Short((short)(number3.shortValue() - number4.shortValue()));
                    break;
                }
                case 2: {
                    number = new Integer(number3.intValue() - number4.intValue());
                    break;
                }
                case 3: {
                    number = new Float(number3.floatValue() - number4.floatValue());
                    break;
                }
                case 4: {
                    number = new Long(number3.longValue() - number4.longValue());
                    break;
                }
                case 5: {
                    number = new Double(number3.doubleValue() - number4.doubleValue());
                    break;
                }
            }
        }
        return number;
    }

    public Number multiply(NumericValue numericValue) {
        Number number = null;
        if (this.getValue() != null && numericValue != null) {
            Number number2 = numericValue.getValue();
            int n = this.getUnifiedTypeIndex(this.value, number2);
            Number number3 = this.convertNumber(this.value, n);
            Number number4 = this.convertNumber(number2, n);
            switch (n) {
                case 0: {
                    number = new Byte((byte)(number3.byteValue() * number4.byteValue()));
                    break;
                }
                case 1: {
                    number = new Short((short)(number3.shortValue() * number4.shortValue()));
                    break;
                }
                case 2: {
                    number = new Integer(number3.intValue() * number4.intValue());
                    break;
                }
                case 3: {
                    number = new Float(number3.floatValue() * number4.floatValue());
                    break;
                }
                case 4: {
                    number = new Long(number3.longValue() * number4.longValue());
                    break;
                }
                case 5: {
                    number = new Double(number3.doubleValue() * number4.doubleValue());
                    break;
                }
            }
        }
        return number;
    }

    public Number divide(NumericValue numericValue) {
        Number number = null;
        if (this.getValue() != null && numericValue != null) {
            Number number2 = numericValue.getValue();
            int n = this.getUnifiedTypeIndex(this.value, number2);
            Number number3 = this.convertNumber(this.value, n);
            Number number4 = this.convertNumber(number2, n);
            switch (n) {
                case 0: {
                    number = new Byte((byte)(number3.byteValue() / number4.byteValue()));
                    break;
                }
                case 1: {
                    number = new Short((short)(number3.shortValue() / number4.shortValue()));
                    break;
                }
                case 2: {
                    number = new Integer(number3.intValue() / number4.intValue());
                    break;
                }
                case 3: {
                    number = new Float(number3.floatValue() / number4.floatValue());
                    break;
                }
                case 4: {
                    number = new Long(number3.longValue() / number4.longValue());
                    break;
                }
                case 5: {
                    number = new Double(number3.doubleValue() / number4.doubleValue());
                    break;
                }
            }
        }
        return number;
    }

    public Number negate() {
        Number number = null;
        if (this.image != null) {
            this.image = "-" + this.image;
            return this.getValue();
        }
        if (this.getValue() != null) {
            int n = this.getIndexForType(this.value);
            switch (n) {
                case 0: {
                    number = new Byte(-this.value.byteValue());
                    break;
                }
                case 1: {
                    number = new Short(-this.value.shortValue());
                    break;
                }
                case 2: {
                    number = new Integer(-this.value.intValue());
                    break;
                }
                case 3: {
                    number = new Float(-this.value.floatValue());
                    break;
                }
                case 4: {
                    number = new Long(-this.value.longValue());
                    break;
                }
                case 5: {
                    number = new Double(-this.value.doubleValue());
                    break;
                }
            }
        }
        return number;
    }

    public String toString() {
        String string = "null";
        if (this.getValue() != null) {
            string = this.value.toString();
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

