/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient.protocol.tcp;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsclient.ConnectionHandler;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.PortMapperClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import javax.jms.JMSException;

public class TCPConnectionHandler
implements ConnectionHandler {
    private static int connectionCount = 0;
    private int counter = 0;
    private Socket socket = null;
    private String host = null;
    private int baseport = 0;
    private int directport = 0;
    private int port = 0;

    TCPConnectionHandler(Object object) throws JMSException {
        ConnectionImpl connectionImpl = (ConnectionImpl)object;
        this.directport = 0;
        this.host = connectionImpl.getProperty("imqBrokerHostName");
        this.baseport = Integer.parseInt(connectionImpl.getProperty("imqBrokerHostPort"));
        this.directport = Integer.parseInt(connectionImpl.getProperty("imqBrokerServicePort"));
        String string = connectionImpl.getProperty("imqBrokerServiceName");
        if (this.directport == 0) {
            PortMapperClient portMapperClient = new PortMapperClient(connectionImpl);
            this.port = string != null && !"".equals(string) ? portMapperClient.getPortForService("tcp", string) : portMapperClient.getPortForProtocol("tcp");
        } else {
            this.port = this.directport;
        }
        ConnectionImpl.checkHostPort(this.host, this.port);
        try {
            this.socket = this.makeSocket(this.host, this.port);
            this.counter = ++connectionCount;
        }
        catch (Exception exception) {
            connectionImpl.getExceptionHandler().handleConnectException(exception, this.host, this.port);
        }
    }

    TCPConnectionHandler(MQAddress mQAddress, ConnectionImpl connectionImpl) throws JMSException {
        ConnectionImpl connectionImpl2 = connectionImpl;
        this.port = 0;
        this.host = mQAddress.getHostName();
        this.directport = 0;
        if (mQAddress.isServicePortFinal()) {
            this.directport = mQAddress.getPort();
        }
        String string = mQAddress.getServiceName();
        if (this.directport == 0) {
            PortMapperClient portMapperClient = new PortMapperClient(mQAddress, connectionImpl2);
            this.baseport = portMapperClient.getHostPort();
            this.port = string != null && !"".equals(string) ? portMapperClient.getPortForService("tcp", string) : portMapperClient.getPortForProtocol("tcp");
        } else {
            this.port = this.directport;
        }
        ConnectionImpl.checkHostPort(this.host, this.port);
        try {
            this.socket = this.makeSocket(this.host, this.port);
            this.counter = ++connectionCount;
        }
        catch (Exception exception) {
            connectionImpl2.getExceptionHandler().handleConnectException(exception, this.host, this.port);
        }
    }

    private Socket makeSocket(String string, int n) throws Exception {
        if (Debug.debug) {
            Debug.println("in TCPConnectionHandler.makeSocket()");
        }
        boolean bl = true;
        String string2 = System.getProperty("imqTcpNoDelay", "true");
        if (string2.equals("false")) {
            bl = false;
        }
        Socket socket = new Socket(string, n);
        socket.setTcpNoDelay(bl);
        return socket;
    }

    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    public int getLocalPort() throws IOException {
        return this.socket.getLocalPort();
    }

    public void close() throws IOException {
        this.socket.close();
    }

    public String getBrokerHostName() {
        return this.host;
    }

    public String getBrokerAddress() {
        if (this.directport == 0) {
            return this.host + ":" + this.baseport + "(" + this.port + ")";
        }
        return this.host + ":" + this.directport;
    }

    public String toString() {
        String string = null;
        try {
            string = "TCPConnectionHandler: " + this.counter + "-" + this.getLocalPort();
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
        }
        return string;
    }
}

