/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.Traceable;
import com.sun.messaging.jmq.jmsclient.ValueConvert;
import com.sun.messaging.jms.MessageEOFException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.StreamMessage;

public class StreamMessageImpl
extends MessageImpl
implements StreamMessage,
Traceable {
    private byte[] messageBody = null;
    private ByteArrayOutputStream byteArrayOutputStream = null;
    private ObjectOutputStream objectOutputStream = null;
    private ByteArrayInputStream byteArrayInputStream = null;
    private ObjectInputStream objectInputStream = null;
    private boolean bufferIsDirty = false;
    private boolean byteArrayReadState = false;
    private ByteArrayInputStream byteArrayFieldInputStream = null;
    private Object notYetProcessedPrimitiveObject = null;

    protected StreamMessageImpl() throws JMSException {
        this.setPacketType(4);
    }

    protected StreamMessageImpl(boolean bl) throws JMSException {
        this();
        if (bl) {
            this.initOutputStream();
        }
    }

    protected void initOutputStream() throws JMSException {
        try {
            this.byteArrayOutputStream = new ByteArrayOutputStream();
            this.objectOutputStream = new ObjectOutputStream(this.byteArrayOutputStream);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4038");
        }
    }

    protected void setMessageBodyToPacket() throws JMSException {
        this.reset();
        this.setMessageBody(this.messageBody);
    }

    protected void getMessageBodyFromPacket() throws JMSException {
        this.messageBody = this.getMessageBody();
        this.reset();
    }

    private Object readPrimitiveObject() throws JMSException {
        Object object = null;
        this.checkReadAccess();
        this.checkReadBytesState();
        try {
            if (this.notYetProcessedPrimitiveObject != null) {
                object = this.notYetProcessedPrimitiveObject;
                this.notYetProcessedPrimitiveObject = null;
            } else {
                object = this.objectInputStream.readObject();
            }
        }
        catch (EOFException eOFException) {
            String string = ExceptionHandler.getExceptionMessage(eOFException, "C4013");
            MessageEOFException messageEOFException = new MessageEOFException(string, "C4013");
            ExceptionHandler.handleException((Exception)eOFException, (JMSException)((Object)messageEOFException));
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4038");
        }
        return object;
    }

    private void writePrimitiveObject(Object object) throws JMSException {
        this.checkMessageAccess();
        try {
            this.objectOutputStream.writeObject(object);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4038");
        }
        this.setBufferIsDirty(true);
    }

    private void checkReadBytesState() throws MessageFormatException {
        if (this.byteArrayReadState) {
            String string = AdministeredObject.cr.getKString("C4017");
            throw new MessageFormatException(string, "C4017");
        }
    }

    protected void setBufferIsDirty(boolean bl) {
        this.bufferIsDirty = bl;
    }

    protected boolean getBufferIsDirty() {
        return this.bufferIsDirty;
    }

    public void clearBody() throws JMSException {
        this.messageBody = null;
        this.setMessageBody(null);
        this.initOutputStream();
        this.setMessageReadMode(false);
    }

    public boolean readBoolean() throws JMSException {
        Object object = this.readPrimitiveObject();
        return ValueConvert.toBoolean(object);
    }

    public byte readByte() throws JMSException {
        Object object = this.readPrimitiveObject();
        try {
            byte by = ValueConvert.toByte(object);
            return by;
        }
        catch (NumberFormatException numberFormatException) {
            this.notYetProcessedPrimitiveObject = object;
            throw numberFormatException;
        }
    }

    public short readShort() throws JMSException {
        Object object = this.readPrimitiveObject();
        return ValueConvert.toShort(object);
    }

    public char readChar() throws JMSException {
        Object object = this.readPrimitiveObject();
        return ValueConvert.toChar(object);
    }

    public int readInt() throws JMSException {
        Object object = this.readPrimitiveObject();
        return ValueConvert.toInt(object);
    }

    public long readLong() throws JMSException {
        Object object = this.readPrimitiveObject();
        return ValueConvert.toLong(object);
    }

    public float readFloat() throws JMSException {
        Object object = this.readPrimitiveObject();
        return ValueConvert.toFloat(object);
    }

    public double readDouble() throws JMSException {
        Object object = this.readPrimitiveObject();
        return ValueConvert.toDouble(object);
    }

    public String readString() throws JMSException {
        Object object = this.readPrimitiveObject();
        return ValueConvert.toString(object);
    }

    public int readBytes(byte[] byArray) throws JMSException {
        int n = -1;
        if (this.messageBody == null) {
            this.checkReadAccess();
            return -1;
        }
        if (!this.byteArrayReadState) {
            Object object = this.readPrimitiveObject();
            if (object == null) {
                return -1;
            }
            if (!(object instanceof byte[])) {
                String string = AdministeredObject.cr.getKString("C4017");
                throw new MessageFormatException(string, "C4017");
            }
            byte[] byArray2 = (byte[])object;
            if (byArray2.length == 0) {
                return 0;
            }
            this.byteArrayFieldInputStream = new ByteArrayInputStream(byArray2);
            this.byteArrayReadState = true;
        }
        if ((n = this.byteArrayFieldInputStream.read(byArray, 0, byArray.length)) < byArray.length) {
            this.byteArrayReadState = false;
            try {
                this.byteArrayFieldInputStream.close();
                this.byteArrayFieldInputStream = null;
            }
            catch (IOException iOException) {
                ExceptionHandler.handleException((Exception)iOException, "C4038");
            }
        }
        return n;
    }

    public Object readObject() throws JMSException {
        Object object = this.readPrimitiveObject();
        return object;
    }

    public void writeBoolean(boolean bl) throws JMSException {
        this.writePrimitiveObject(new Boolean(bl));
    }

    public void writeByte(byte by) throws JMSException {
        this.writePrimitiveObject(new Byte(by));
    }

    public void writeShort(short s) throws JMSException {
        this.writePrimitiveObject(new Short(s));
    }

    public void writeChar(char c) throws JMSException {
        this.writePrimitiveObject(new Character(c));
    }

    public void writeInt(int n) throws JMSException {
        this.writePrimitiveObject(new Integer(n));
    }

    public void writeLong(long l) throws JMSException {
        this.writePrimitiveObject(new Long(l));
    }

    public void writeFloat(float f) throws JMSException {
        this.writePrimitiveObject(new Float(f));
    }

    public void writeDouble(double d) throws JMSException {
        this.writePrimitiveObject(new Double(d));
    }

    public void writeString(String string) throws JMSException {
        this.writePrimitiveObject(string);
    }

    public void writeBytes(byte[] byArray) throws JMSException {
        this.writePrimitiveObject(byArray);
    }

    public void writeBytes(byte[] byArray, int n, int n2) throws JMSException {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.writePrimitiveObject(byArray2);
    }

    public void writeObject(Object object) throws JMSException {
        this.checkValidObjectType(object);
        this.writePrimitiveObject(object);
    }

    private void checkValidObjectType(Object object) throws MessageFormatException {
        if (object == null) {
            return;
        }
        if (!(object instanceof Boolean || object instanceof Byte || object instanceof Short || object instanceof Character || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof String || object instanceof byte[])) {
            String string = AdministeredObject.cr.getKString("C4017");
            throw new MessageFormatException(string, "C4017");
        }
    }

    public void reset() throws JMSException {
        try {
            if (this.bufferIsDirty) {
                this.objectOutputStream.flush();
                this.messageBody = this.byteArrayOutputStream.toByteArray();
                this.objectOutputStream.close();
                this.byteArrayOutputStream.close();
            }
            if (this.messageBody != null) {
                this.byteArrayInputStream = new ByteArrayInputStream(this.messageBody);
                this.objectInputStream = new ObjectInputStream(this.byteArrayInputStream);
            }
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4012", true);
        }
        this.setBufferIsDirty(false);
        this.setMessageReadMode(true);
        this.byteArrayReadState = false;
        this.notYetProcessedPrimitiveObject = null;
    }

    public void dump(PrintStream printStream) {
        printStream.println("------ StreamMessageImpl dump ------");
        super.dump(printStream);
    }

    public String toString() {
        return super.toString();
    }
}

