/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.apps.console.ActionManager;
import com.sun.messaging.jmq.admin.apps.console.BrokerListCObj;
import com.sun.messaging.jmq.admin.apps.console.ConsoleObj;
import com.sun.messaging.jmq.admin.apps.console.ExplorerMouseAdapter;
import com.sun.messaging.jmq.admin.apps.console.ExplorerTreeCellRenderer;
import com.sun.messaging.jmq.admin.apps.console.ExplorerTreeModel;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreListCObj;
import com.sun.messaging.jmq.admin.apps.console.event.AdminEvent;
import com.sun.messaging.jmq.admin.apps.console.event.AdminEventListener;
import com.sun.messaging.jmq.admin.apps.console.event.SelectionEvent;
import java.awt.Dimension;
import java.util.Enumeration;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class AExplorer
extends JScrollPane
implements TreeSelectionListener {
    private ActionManager actionMgr;
    private EventListenerList aListeners = new EventListenerList();
    private JTree tree;
    private ExplorerTreeModel model;
    private Object temp;
    private DefaultMutableTreeNode root;
    private ObjStoreListCObj objStoreListCObj;
    private BrokerListCObj brokerListCObj;
    private boolean scrollToPath;
    static /* synthetic */ Class class$com$sun$messaging$jmq$admin$apps$console$event$AdminEventListener;

    public AExplorer(ActionManager actionManager, ObjStoreListCObj objStoreListCObj, BrokerListCObj brokerListCObj) {
        this.objStoreListCObj = objStoreListCObj;
        this.brokerListCObj = brokerListCObj;
        this.actionMgr = actionManager;
        this.initGui();
    }

    public void select(ConsoleObj consoleObj) {
        ConsoleObj consoleObj2 = consoleObj;
        this.tree.setSelectionPath(new TreePath(consoleObj2.getPath()));
        SelectionEvent selectionEvent = new SelectionEvent(this, 0);
        selectionEvent.setSelectedObj(consoleObj2);
        this.fireAdminEventDispatched(selectionEvent);
    }

    public void clearSelection() {
        this.tree.clearSelection();
    }

    public void addObjStore(ConsoleObj consoleObj) {
        this.insertNewNode(this.objStoreListCObj, consoleObj);
    }

    public void loadObjStores(ConsoleObj[] consoleObjArray) {
    }

    public void deleteObjStore(ConsoleObj consoleObj) {
    }

    public void addToParent(ConsoleObj consoleObj, ConsoleObj consoleObj2) {
        this.insertNewNode(consoleObj, consoleObj2);
    }

    public void removeFromParent(ConsoleObj consoleObj) {
        if (consoleObj.getParent() != null) {
            this.model.removeNodeFromParent(consoleObj);
        }
    }

    public void addBroker(ConsoleObj consoleObj) {
        this.insertNewNode(this.brokerListCObj, consoleObj);
    }

    public void removeBroker() {
    }

    public void addAdminEventListener(AdminEventListener adminEventListener) {
        this.aListeners.add(class$com$sun$messaging$jmq$admin$apps$console$event$AdminEventListener == null ? (class$com$sun$messaging$jmq$admin$apps$console$event$AdminEventListener = AExplorer.class$("com.sun.messaging.jmq.admin.apps.console.event.AdminEventListener")) : class$com$sun$messaging$jmq$admin$apps$console$event$AdminEventListener, adminEventListener);
    }

    public void removeAdminEventListener(AdminEventListener adminEventListener) {
        this.aListeners.remove(class$com$sun$messaging$jmq$admin$apps$console$event$AdminEventListener == null ? (class$com$sun$messaging$jmq$admin$apps$console$event$AdminEventListener = AExplorer.class$("com.sun.messaging.jmq.admin.apps.console.event.AdminEventListener")) : class$com$sun$messaging$jmq$admin$apps$console$event$AdminEventListener, adminEventListener);
    }

    public void expandAll() {
        int n = this.tree.getRowCount();
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
    }

    public void collapseAll() {
        int n = this.tree.getRowCount();
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.collapseRow(i);
        }
    }

    public void nodeChanged(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.model.nodeChanged(defaultMutableTreeNode);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode != null) {
            SelectionEvent selectionEvent = new SelectionEvent(this, 0);
            selectionEvent.setSelectedObj((ConsoleObj)defaultMutableTreeNode);
            this.fireAdminEventDispatched(selectionEvent);
        }
    }

    private void fireAdminEventDispatched(AdminEvent adminEvent) {
        Object[] objectArray = this.aListeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$com$sun$messaging$jmq$admin$apps$console$event$AdminEventListener == null ? AExplorer.class$("com.sun.messaging.jmq.admin.apps.console.event.AdminEventListener") : class$com$sun$messaging$jmq$admin$apps$console$event$AdminEventListener)) continue;
            ((AdminEventListener)objectArray[i + 1]).adminEventDispatched(adminEvent);
        }
    }

    private void initGui() {
        this.root = new DefaultMutableTreeNode("JMQ Administration");
        this.model = new ExplorerTreeModel(this.root);
        this.tree = new JTree(this.model);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        String string = "Angled";
        this.tree.putClientProperty("JTree.lineStyle", string);
        this.tree.setShowsRootHandles(true);
        this.tree.setRootVisible(false);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.tree.setCellRenderer(new ExplorerTreeCellRenderer());
        ExplorerMouseAdapter explorerMouseAdapter = new ExplorerMouseAdapter(this.actionMgr, this.tree);
        this.tree.addMouseListener(explorerMouseAdapter);
        this.model.insertNodeInto(this.objStoreListCObj, this.root, 0);
        this.model.insertNodeInto(this.brokerListCObj, this.root, 1);
        this.model.reload();
        this.setViewportView(this.tree);
        this.setPreferredSize(new Dimension(210, 50));
    }

    public void setScrollToPath(boolean bl) {
        this.scrollToPath = bl;
    }

    private void insertNewNode(ConsoleObj consoleObj, ConsoleObj consoleObj2) {
        int n = this.model.getChildCount(consoleObj);
        this.model.insertNodeInto(consoleObj2, consoleObj, n);
        Enumeration<TreeNode> enumeration = consoleObj2.children();
        if (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (this.scrollToPath) {
                this.tree.scrollPathToVisible(new TreePath(defaultMutableTreeNode.getPath()));
            }
        }
    }

    private void insertNewNode(ConsoleObj consoleObj, ConsoleObj consoleObj2, int n) {
        this.model.insertNodeInto(consoleObj2, consoleObj, n);
        Enumeration<TreeNode> enumeration = consoleObj2.children();
        if (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (this.scrollToPath && this.scrollToPath) {
                this.tree.scrollPathToVisible(new TreePath(defaultMutableTreeNode.getPath()));
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

