/*
 * Decompiled with CFR 0.152.
 */
package org.openide.windows;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListener;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;

final class DefaultTopComponentLookup
extends ProxyLookup
implements PropertyChangeListener,
InstanceContent.Convertor,
LookupListener {
    private TopComponent tc;
    private LookupListener listener;
    private Map attachedTo;
    private static Lookup[] EMPTY_ARRAY = new Lookup[0];
    static /* synthetic */ Class class$org$openide$util$LookupListener;
    static /* synthetic */ Class class$org$openide$nodes$Node;
    static /* synthetic */ Class class$java$lang$Object;

    public DefaultTopComponentLookup(TopComponent tc) {
        this.tc = tc;
        this.listener = (LookupListener)WeakListener.create(class$org$openide$util$LookupListener == null ? (class$org$openide$util$LookupListener = DefaultTopComponentLookup.class$("org.openide.util.LookupListener")) : class$org$openide$util$LookupListener, this, null);
        this.updateLookups();
        tc.addPropertyChangeListener("activatedNodes", WeakListener.propertyChange(this, tc));
    }

    private void updateLookups() {
        HashMap copy;
        Object[] arr = this.tc.getActivatedNodes();
        if (arr == null) {
            this.setLookups(EMPTY_ARRAY);
            return;
        }
        Lookup[] lookups = new Lookup[arr.length + 1];
        DefaultTopComponentLookup defaultTopComponentLookup = this;
        synchronized (defaultTopComponentLookup) {
            copy = this.attachedTo == null ? Collections.EMPTY_MAP : new HashMap(this.attachedTo);
        }
        int i = 0;
        while (i < arr.length) {
            lookups[i] = arr[i].getLookup();
            if (copy != null) {
                copy.remove(arr[i]);
            }
            ++i;
        }
        lookups[arr.length] = Lookups.fixed(arr, this);
        Iterator it = copy.values().iterator();
        while (it.hasNext()) {
            Lookup.Result res = (Lookup.Result)it.next();
            res.removeLookupListener(this.listener);
        }
        DefaultTopComponentLookup defaultTopComponentLookup2 = this;
        synchronized (defaultTopComponentLookup2) {
            this.attachedTo = null;
        }
        this.setLookups(lookups);
    }

    public void propertyChange(PropertyChangeEvent ev) {
        this.updateLookups();
    }

    public void resultChanged(LookupEvent ev) {
        this.updateLookups();
    }

    private static boolean isNodeQuery(Class c) {
        return (class$org$openide$nodes$Node == null ? (class$org$openide$nodes$Node = DefaultTopComponentLookup.class$("org.openide.nodes.Node")) : class$org$openide$nodes$Node).isAssignableFrom(c) || c.isAssignableFrom(class$org$openide$nodes$Node == null ? (class$org$openide$nodes$Node = DefaultTopComponentLookup.class$("org.openide.nodes.Node")) : class$org$openide$nodes$Node);
    }

    protected synchronized void beforeLookup(Lookup.Template t) {
        if (this.attachedTo == null && DefaultTopComponentLookup.isNodeQuery(t.getType())) {
            Lookup[] arr = this.getLookups();
            this.attachedTo = new WeakHashMap(arr.length * 2);
            int i = 0;
            while (i < arr.length - 1) {
                Lookup.Result res = arr[i].lookup(t);
                res.addLookupListener(this.listener);
                this.attachedTo.put(arr[i], res);
                ++i;
            }
        }
    }

    public Object convert(Object obj) {
        Lookup[] arr = this.getLookups();
        int i = 0;
        while (i < arr.length - 1) {
            if (arr[i].lookup(class$org$openide$nodes$Node == null ? DefaultTopComponentLookup.class$("org.openide.nodes.Node") : class$org$openide$nodes$Node) == obj) {
                return null;
            }
            ++i;
        }
        return obj;
    }

    public String displayName(Object obj) {
        return ((Node)obj).getDisplayName();
    }

    public String id(Object obj) {
        return ((Node)obj).getName();
    }

    public Class type(Object obj) {
        Class clazz = this.convert(obj) == null ? (class$java$lang$Object == null ? (class$java$lang$Object = DefaultTopComponentLookup.class$("java.lang.Object")) : class$java$lang$Object) : obj.getClass();
        return clazz;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

