/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.datatransfer;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import javax.swing.event.EventListenerList;
import org.openide.util.datatransfer.ClipboardEvent;
import org.openide.util.datatransfer.ClipboardListener;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;

public abstract class ExClipboard
extends Clipboard {
    private EventListenerList listeners = new EventListenerList();
    static /* synthetic */ Class class$org$openide$util$datatransfer$ClipboardListener;

    public ExClipboard(String name) {
        super(name);
    }

    public final void addClipboardListener(ClipboardListener list) {
        this.listeners.add(class$org$openide$util$datatransfer$ClipboardListener == null ? (class$org$openide$util$datatransfer$ClipboardListener = ExClipboard.class$("org.openide.util.datatransfer.ClipboardListener")) : class$org$openide$util$datatransfer$ClipboardListener, list);
    }

    public final void removeClipboardListener(ClipboardListener list) {
        this.listeners.remove(class$org$openide$util$datatransfer$ClipboardListener == null ? (class$org$openide$util$datatransfer$ClipboardListener = ExClipboard.class$("org.openide.util.datatransfer.ClipboardListener")) : class$org$openide$util$datatransfer$ClipboardListener, list);
    }

    protected final void fireClipboardChange() {
        Object[] l = this.listeners.getListenerList();
        ClipboardEvent ev = null;
        int i = l.length - 2;
        while (i >= 0) {
            ClipboardListener list = (ClipboardListener)l[i + 1];
            if (ev == null) {
                ev = new ClipboardEvent(this);
            }
            list.clipboardChanged(ev);
            i -= 2;
        }
    }

    protected abstract Convertor[] getConvertors();

    public Transferable convert(Transferable t) {
        Convertor[] convertors = this.getConvertors();
        int i = 0;
        while (i < convertors.length) {
            t = convertors[i].convert(t);
            ++i;
        }
        return t;
    }

    public static void transferableAccepted(Transferable t, int action) {
        if (t instanceof ExTransferable) {
            ((ExTransferable)t).fireAccepted(action);
        } else if (t.isDataFlavorSupported(ExTransferable.multiFlavor)) {
            try {
                MultiTransferObject mto = (MultiTransferObject)t.getTransferData(ExTransferable.multiFlavor);
                int cnt = mto.getCount();
                int i = 0;
                while (i < cnt) {
                    ExClipboard.transferableAccepted(mto.getTransferableAt(i), action);
                    ++i;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void transferableRejected(Transferable t) {
        if (t instanceof ExTransferable) {
            ((ExTransferable)t).fireRejected();
        } else if (t.isDataFlavorSupported(ExTransferable.multiFlavor)) {
            try {
                MultiTransferObject mto = (MultiTransferObject)t.getTransferData(ExTransferable.multiFlavor);
                int cnt = mto.getCount();
                int i = 0;
                while (i < cnt) {
                    ExClipboard.transferableRejected(mto.getTransferableAt(i));
                    ++i;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void transferableOwnershipLost(Transferable t) {
        if (t instanceof ExTransferable) {
            ((ExTransferable)t).fireOwnershipLost();
        } else if (t.isDataFlavorSupported(ExTransferable.multiFlavor)) {
            try {
                MultiTransferObject mto = (MultiTransferObject)t.getTransferData(ExTransferable.multiFlavor);
                int cnt = mto.getCount();
                int i = 0;
                while (i < cnt) {
                    ExClipboard.transferableOwnershipLost(mto.getTransferableAt(i));
                    ++i;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface Convertor {
        public Transferable convert(Transferable var1);
    }
}

